/*
 * Decompiled with CFR 0.152.
 */
package io.continual.http.app.htmlForms;

import io.continual.util.collections.MultiMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;

public class CHttpInvalidFormException
extends Exception {
    private final LinkedList<String> fFormProblems;
    private MultiMap<String, String> fFieldProblems = new MultiMap();
    private MultiMap<String, String> fFieldWarnings = new MultiMap();
    private static final long serialVersionUID = 1L;

    public CHttpInvalidFormException() {
        super("Form validation errors");
        this.fFormProblems = new LinkedList();
    }

    public CHttpInvalidFormException addProblem(String problem) {
        this.fFormProblems.add(problem);
        return this;
    }

    public CHttpInvalidFormException addProblem(String field, String problem) {
        this.fFieldProblems.put((Object)field, (Object)problem);
        return this;
    }

    public CHttpInvalidFormException addWarning(String field, String problem) {
        this.fFieldWarnings.put((Object)field, (Object)problem);
        return this;
    }

    public CHttpInvalidFormException addProblemsFrom(CHttpInvalidFormException that) {
        this.fFormProblems.addAll(that.getFormProblems());
        this.fFieldProblems.putAll(that.getFieldProblems());
        return this;
    }

    public int size() {
        return this.fFieldProblems.size() + this.fFormProblems.size();
    }

    public Map<String, List<String>> getFieldProblems() {
        return this.fFieldProblems.getValues();
    }

    public List<String> getProblemsOn(String field) {
        LinkedList<String> list = new LinkedList<String>();
        List vals = this.fFieldProblems.get((Object)field);
        if (vals != null) {
            list.addAll(vals);
        }
        return list;
    }

    public Map<String, List<String>> getFieldWarnings() {
        return this.fFieldWarnings.getValues();
    }

    public List<String> getFormProblems() {
        return this.fFormProblems;
    }
}

