/*
 * Decompiled with CFR 0.152.
 */
package io.continual.http.service.framework;

import io.continual.http.service.framework.CHttpConnection;
import io.continual.http.service.framework.CHttpConnectionContext;
import io.continual.http.service.framework.CHttpErrorHandler;
import io.continual.http.service.framework.CHttpMetricNamer;
import io.continual.http.service.framework.CHttpRuntimeControls;
import io.continual.http.service.framework.CHttpServletSettings;
import io.continual.http.service.framework.CHttpVersionInfo;
import io.continual.http.service.framework.context.CHttpRequest;
import io.continual.http.service.framework.context.CHttpRequestContext;
import io.continual.http.service.framework.context.StdRequest;
import io.continual.http.service.framework.inspection.CHttpObserverMgr;
import io.continual.http.service.framework.inspection.impl.ObserveNoneMgr;
import io.continual.http.service.framework.routing.CHttpRequestRouter;
import io.continual.http.service.framework.routing.CHttpRouteInvocation;
import io.continual.metrics.MetricsCatalog;
import io.continual.metrics.metricTypes.Timer;
import io.continual.util.naming.Name;
import io.continual.util.naming.Path;
import io.continual.util.nv.NvReadable;
import io.continual.util.nv.impl.nvInstallTypeWrapper;
import io.continual.util.nv.impl.nvPropertiesFile;
import io.continual.util.nv.impl.nvReadableStack;
import io.continual.util.time.Clock;
import java.io.File;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.lang.reflect.InvocationTargetException;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URL;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.concurrent.TimeUnit;
import javax.servlet.ServletConfig;
import javax.servlet.ServletException;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.json.JSONObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CHttpServlet
extends HttpServlet {
    private NvReadable fSettings;
    private final CHttpRuntimeControls fRuntimeControls;
    private File fWebInfDir = null;
    private final NvReadable fProvidedPrefs;
    private final String fPrefsConfigFilename;
    private final LinkedList<File> fSearchDirs;
    private final SessionLifeCycle fSessionLifeCycle;
    private CHttpRequestRouter fRouter;
    private final HashMap<String, Object> fObjects;
    private final MetricsCatalog fMetrics;
    private final CHttpObserverMgr fInspector;
    public static final String kJvmSetting_FileRoot = "CHTTP_FILES";
    public static final String kSetting_BaseWebAppDir = "chttp.webapp.base";
    private static final String kWebSessionObject = "chttp.session.";
    public static final String kSetting_BaseTemplateDir = "chttp.templates.path";
    private static final String kSetting_SearchDirs = "chttp.config.search.dirs";
    private static final long serialVersionUID = 1L;
    private static Logger log = LoggerFactory.getLogger(CHttpServlet.class);

    public CHttpServlet() {
        this(SessionLifeCycle.NO_SESSION);
    }

    public CHttpServlet(String prefsFileName) {
        this(prefsFileName, SessionLifeCycle.NO_SESSION);
    }

    public CHttpServlet(SessionLifeCycle slc) {
        this(null, slc);
    }

    public CHttpServlet(String prefsFileName, SessionLifeCycle slc) {
        this(null, prefsFileName, slc, null, null);
    }

    public CHttpServlet(NvReadable settings, String addlSettingsFileName, SessionLifeCycle slc, MetricsCatalog metrics, CHttpObserverMgr inspector) {
        this.fProvidedPrefs = settings;
        this.fPrefsConfigFilename = addlSettingsFileName;
        this.fSessionLifeCycle = slc;
        this.fRouter = null;
        this.fObjects = new HashMap();
        this.fSearchDirs = new LinkedList();
        this.fRuntimeControls = new CHttpRuntimeControls();
        this.fMetrics = metrics;
        this.fInspector = inspector != null ? inspector : new ObserveNoneMgr();
    }

    public final void init(ServletConfig sc) throws ServletException {
        nvReadableStack settingsStack;
        block16: {
            String webappDirName;
            File checkDir;
            super.init(sc);
            for (String msg : CHttpVersionInfo.getTitleAndCopyright()) {
                log.info(msg);
            }
            String basePath = sc.getServletContext().getRealPath("/");
            if (basePath == null) {
                throw new ServletException("Couldn't get the base path from '/'. Container returned null.");
            }
            log.info("working dir = " + System.getProperty("user.dir"));
            log.info("servlet class: " + ((Object)((Object)this)).getClass().getName());
            log.info("real path of '/' = " + basePath);
            settingsStack = new nvReadableStack();
            settingsStack.push((NvReadable)new CHttpServletSettings(sc));
            if (this.fProvidedPrefs != null) {
                settingsStack.push(this.fProvidedPrefs);
            }
            if ((checkDir = new File(webappDirName = settingsStack.getString(kSetting_BaseWebAppDir, new File(basePath, "WEB-INF").getAbsolutePath()))).exists()) {
                this.fWebInfDir = checkDir;
            } else {
                log.info("Can't find the webapp's base directory. Used '" + webappDirName + "'.");
            }
            String searchDirString = settingsStack.getString(kSetting_SearchDirs, null);
            if (searchDirString != null) {
                String[] searchDirs;
                log.info("config search dirs: " + searchDirString);
                for (String searchDir : searchDirs = searchDirString.split(":")) {
                    this.addToFileSearchDirs(new File(searchDir));
                }
            } else {
                log.info("chttp.config.search.dirs is not set. (Typically set in web.xml)");
            }
            if (this.fPrefsConfigFilename != null && this.fPrefsConfigFilename.length() > 0) {
                try {
                    log.info("finding config stream named [" + this.fPrefsConfigFilename + "].");
                    URL configFile = this.findStream(this.fPrefsConfigFilename);
                    if (configFile != null) {
                        log.info("chose stream [" + configFile.toString() + "].");
                        nvPropertiesFile filePrefs = new nvPropertiesFile(configFile);
                        settingsStack.push((NvReadable)filePrefs);
                        break block16;
                    }
                    log.warn("could not find config stream.");
                }
                catch (NvReadable.LoadException e) {
                    log.warn("Couldn't load settings from [" + this.fPrefsConfigFilename + "].");
                }
            } else {
                log.info("no preferences file specified to " + ((Object)((Object)this)).getClass().getSimpleName() + "'s constructor.");
            }
        }
        settingsStack.push((NvReadable)this.fRuntimeControls);
        NvReadable appLevelSettings = this.makeSettings((NvReadable)settingsStack);
        this.fSettings = new nvInstallTypeWrapper(appLevelSettings);
        this.fRouter = new CHttpRequestRouter();
        try {
            log.info("Calling app servlet setup.");
            this.servletSetup();
        }
        catch (NvReadable.MissingReqdSettingException e) {
            log.error("Shutting down due to missing setting. " + e.getMessage());
            throw new ServletException((Throwable)e);
        }
        catch (NvReadable.InvalidSettingValueException e) {
            log.error("Shutting down due to invalid setting. " + e.getMessage());
            throw new ServletException((Throwable)e);
        }
        log.info("Servlet is ready.");
    }

    public final void destroy() {
        super.destroy();
        try {
            this.servletShutdown();
        }
        catch (Exception x) {
            log.error("During tear-down: " + x.getMessage());
        }
    }

    public URL findStream(String resourceName) {
        try {
            URL res;
            File file = new File(resourceName);
            if (file.isAbsolute() && file.exists()) {
                return file.toURI().toURL();
            }
            String filesRoot = System.getProperty(kJvmSetting_FileRoot, null);
            if (filesRoot != null) {
                String fullPath = filesRoot + "/" + resourceName;
                log.debug("Looking for [" + fullPath + "].");
                file = new File(fullPath);
                if (file.exists()) {
                    return file.toURI().toURL();
                }
            }
            if ((res = ((Object)((Object)this)).getClass().getClassLoader().getResource(resourceName)) != null) {
                return res;
            }
            res = ClassLoader.getSystemResource(resourceName);
            if (res != null) {
                return res;
            }
            File f = this.findFile(resourceName);
            if (f.exists()) {
                URI u = f.toURI();
                return u.toURL();
            }
        }
        catch (MalformedURLException e) {
            log.warn("Unexpected failure to convert a local filename into a URL: " + e.getMessage());
        }
        return null;
    }

    public File findFile(String appRelativePath) {
        File file = new File(appRelativePath);
        if (!file.isAbsolute()) {
            String filesRoot = System.getProperty(kJvmSetting_FileRoot, null);
            if (filesRoot != null) {
                String fullPath = filesRoot + "/" + appRelativePath;
                log.debug("Looking for [" + fullPath + "].");
                file = new File(fullPath);
            }
            if (!file.exists() && this.fWebInfDir != null) {
                file = new File(this.fWebInfDir, appRelativePath);
                log.debug("Looking for [" + file.getAbsolutePath() + "].");
            }
            if (!file.exists()) {
                String basePath = super.getServletContext().getRealPath("/");
                String fullPath = basePath + (basePath.endsWith("/") ? "" : "/") + appRelativePath;
                log.debug("Looking for [" + fullPath + "].");
                file = new File(fullPath);
            }
            if (!file.exists()) {
                for (File dir : this.fSearchDirs) {
                    File candidate = new File(dir, appRelativePath);
                    log.debug("Looking for [" + candidate.getAbsolutePath() + "].");
                    if (!candidate.exists()) continue;
                    file = candidate;
                    break;
                }
            }
            if (!file.exists()) {
                file = new File(appRelativePath);
            }
        }
        log.debug("Given [" + appRelativePath + "], using file [" + file.getAbsolutePath() + "].");
        return file;
    }

    public NvReadable getSettings() {
        return this.fSettings;
    }

    public CHttpRuntimeControls getControls() {
        return this.fRuntimeControls;
    }

    public void putObject(String key, Object o) {
        this.fObjects.put(key, o);
    }

    public Object getObject(String key) {
        return this.fObjects.get(key);
    }

    public CHttpConnection createSession() throws NvReadable.MissingReqdSettingException {
        return null;
    }

    public CHttpRequestRouter getRequestRouter() {
        return this.fRouter;
    }

    protected NvReadable makeSettings(NvReadable fromBase) {
        return fromBase;
    }

    protected synchronized void addToFileSearchDirs(File dir) {
        if (dir.exists() && dir.isDirectory()) {
            this.fSearchDirs.add(dir);
        } else {
            log.warn("File [" + dir.toString() + "] is not a directory. Ignored.");
        }
    }

    protected void servletSetup() throws NvReadable.MissingReqdSettingException, NvReadable.InvalidSettingValueException, ServletException {
    }

    protected void servletShutdown() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final void service(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        long startMs = Clock.now();
        String clientIp = StdRequest.getBestRemoteAddress(req);
        String reqId = clientIp + " " + req.getMethod() + " " + req.getRequestURI();
        log.debug("start " + reqId);
        if (this.getSettings().getBoolean("chttp.logging.requestHeaders", false)) {
            log.info("--");
            log.info("REQUEST from " + req.getRemoteHost() + " (" + req.getRemoteAddr() + "):");
            log.info("    " + req.getMethod() + " " + req.getPathInfo() + " " + req.getQueryString());
            log.info("");
            Enumeration e = req.getHeaderNames();
            while (e.hasMoreElements()) {
                String name = e.nextElement().toString();
                String val = req.getHeader(name);
                log.info("    " + name + ": " + val);
            }
            log.info("--");
        }
        CHttpConnection session = this.getSession(req);
        CHttpRequestContext ctx = this.createHandlingContext(req, resp, session, this.fObjects, this.fRouter);
        this.fInspector.consider(ctx);
        CHttpRequest reqObj = ctx.request();
        Path pathAsMetricName = this.getMetricNamer().getMetricNameFor(reqObj);
        try {
            CHttpRouteInvocation handler = this.fRouter.route(reqObj, session);
            pathAsMetricName = handler.getRouteNameForMetrics();
            Timer.Context timer = this.fMetrics == null ? null : this.fMetrics.timer(pathAsMetricName.makeChildItem(Name.fromString((String)"executionTime"))).time();
            try {
                handler.run(ctx);
            }
            finally {
                if (timer != null) {
                    timer.stop();
                }
            }
        }
        catch (CHttpRequestRouter.noMatchingRoute e) {
            this.onError(ctx, e, new CHttpErrorHandler(){

                @Override
                public void handle(CHttpRequestContext ctx, Throwable cause) {
                    CHttpServlet.this.sendStdJsonError(ctx, 404, "Not found.");
                }
            });
            pathAsMetricName = null;
            if (this.fMetrics != null) {
                this.fMetrics.meter(Path.fromString((String)"/noMatchForMethodAndPath")).mark();
            }
        }
        catch (InvocationTargetException x) {
            Throwable t = x.getCause();
            if (t != null) {
                this.onError(ctx, t, null);
            } else {
                this.onError(ctx, x, null);
            }
        }
        catch (Throwable t) {
            this.onError(ctx, t, null);
        }
        long endMs = Clock.now();
        long durationMs = endMs - startMs;
        int returnedStatusCode = ctx.response().getStatusCode();
        log.info("{} {} {} ms", new Object[]{reqId, returnedStatusCode, durationMs});
        ctx.close();
        if (this.fMetrics != null && pathAsMetricName != null) {
            this.fMetrics.meter(pathAsMetricName.makeChildItem(Name.fromString((String)"statusCode")).makeChildItem(Name.fromString((String)("" + returnedStatusCode)))).mark();
        }
    }

    protected CHttpRequestContext createHandlingContext(HttpServletRequest req, HttpServletResponse resp, CHttpConnection dc, HashMap<String, Object> objects, CHttpRequestRouter rr) {
        return new CHttpRequestContext(this, req, resp, dc, objects, rr);
    }

    private void sendStdJsonError(CHttpRequestContext ctx, int err, String msg) {
        ctx.response().sendErrorAndBody(err, new JSONObject().put("statusCode", err).put("status", (Object)msg).toString(4), "application/json");
    }

    private void onError(CHttpRequestContext ctx, Throwable t, CHttpErrorHandler defHandler) {
        CHttpErrorHandler eh = this.fRouter.route(t);
        if (eh == null && defHandler != null) {
            eh = defHandler;
        }
        if (eh != null) {
            try {
                eh.handle(ctx, t);
            }
            catch (Throwable tt) {
                log.warn("Error handler failed, handling a " + t.getClass().getName() + ", with " + tt.getMessage());
                this.sendStdJsonError(ctx, 500, t.getMessage());
            }
        } else {
            log.warn("No handler defined for " + t.getClass().getName() + ". Sending 500.");
            this.sendStdJsonError(ctx, 500, t.getMessage());
            StringWriter sw = new StringWriter();
            PrintWriter pw = new PrintWriter(sw);
            t.printStackTrace(pw);
            pw.close();
            log.warn(sw.toString());
        }
    }

    private String getSessionIdFromCookie(HttpServletRequest req) {
        Cookie[] cookies = req.getCookies();
        if (cookies != null) {
            for (Cookie c : req.getCookies()) {
                if (!c.getName().equals("JSESSIONID")) continue;
                return c.getValue();
            }
        }
        return null;
    }

    private CHttpConnection getSession(final HttpServletRequest req) throws ServletException {
        CHttpConnection result = null;
        if (!this.fSessionLifeCycle.equals((Object)SessionLifeCycle.NO_SESSION)) {
            try {
                String servletSessionName = CHttpServlet.getSessionObjectName(((Object)((Object)this)).getClass());
                String sessionCookieWas = this.getSessionIdFromCookie(req);
                log.debug("Session ID from request cookie: " + sessionCookieWas);
                final HttpSession session = req.getSession(true);
                log.debug("Session ID on response session: " + session.getId());
                result = (CHttpConnection)session.getAttribute(servletSessionName);
                if (result == null && (result = this.createSession()) != null) {
                    session.setAttribute(servletSessionName, (Object)result);
                    result.onSessionCreate(this, new CHttpConnectionContext(){

                        @Override
                        public void setInactiveExpiration(long units, TimeUnit tu) {
                            long timeInSeconds = TimeUnit.SECONDS.convert(units, tu);
                            if (timeInSeconds < 0L || timeInSeconds > Integer.MAX_VALUE) {
                                throw new IllegalArgumentException("Invalid time specification.");
                            }
                            int timeInSecondsInt = (int)timeInSeconds;
                            session.setMaxInactiveInterval(timeInSecondsInt);
                        }

                        @Override
                        public String getRemoteAddress(boolean actual) {
                            return actual ? StdRequest.getActualRemoteAddress(req) : StdRequest.getBestRemoteAddress(req);
                        }
                    });
                }
                if (result != null) {
                    result.noteActivity();
                }
            }
            catch (NvReadable.MissingReqdSettingException e) {
                throw new ServletException((Throwable)e);
            }
        }
        return result;
    }

    private static String getSessionObjectName(Class<?> c) {
        return kWebSessionObject + c.getName();
    }

    protected CHttpMetricNamer getMetricNamer() {
        return new CHttpMetricNamer(){

            @Override
            public Path getMetricNameFor(CHttpRequest req) {
                return Path.fromString((String)("/" + req.getMethod() + " " + req.getPathInContext().replaceAll("\\.", "%2E")));
            }
        };
    }

    public static enum SessionLifeCycle {
        NO_SESSION,
        FULL_SESSION;

    }
}

