/*
 * Decompiled with CFR 0.152.
 */
package io.continual.http.service.framework.context;

import io.continual.http.service.framework.CHttpConnection;
import io.continual.http.service.framework.CHttpServlet;
import io.continual.http.service.framework.context.CHttpRequest;
import io.continual.http.service.framework.context.CHttpResponse;
import io.continual.http.service.framework.context.StdRequest;
import io.continual.http.service.framework.context.StdResponse;
import io.continual.http.service.framework.inspection.CHttpObserver;
import io.continual.http.service.framework.inspection.impl.NoopInspector;
import io.continual.http.service.framework.routing.CHttpRequestRouter;
import io.continual.util.nv.NvReadable;
import java.util.HashMap;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CHttpRequestContext {
    private final HttpServletRequest fRequest;
    private final HttpServletResponse fResponse;
    final CHttpConnection fSession;
    private final CHttpServlet fServlet;
    final HashMap<String, Object> fLocalContext;
    private final Map<String, Object> fObjects;
    private final CHttpRequestRouter fRouter;
    private StdRequest fRequestWrapper;
    private StdResponse fResponseWrapper;
    private CHttpObserver fInspector;
    static Logger log = LoggerFactory.getLogger(CHttpRequestContext.class);

    public CHttpRequestContext(CHttpServlet webServlet, HttpServletRequest req, HttpServletResponse resp, CHttpConnection s, Map<String, Object> objects, CHttpRequestRouter router) {
        this.fRequest = req;
        this.fResponse = resp;
        this.fSession = s;
        this.fServlet = webServlet;
        this.fLocalContext = new HashMap();
        this.fObjects = objects;
        this.fRouter = router;
        this.fRequestWrapper = null;
        this.fResponseWrapper = null;
        this.fInspector = new NoopInspector();
    }

    public void install(CHttpObserver i) {
        if (i != null) {
            this.fInspector = i;
            this.fRequestWrapper = null;
            this.fResponseWrapper = null;
        }
    }

    public void close() {
        if (this.fInspector != null) {
            this.fInspector.closeTrx();
        }
    }

    public CHttpConnection session() {
        return this.fSession;
    }

    public NvReadable systemSettings() {
        return this.fServlet.getSettings();
    }

    public CHttpRequestRouter router() {
        return this.fRouter;
    }

    public CHttpServlet getServlet() {
        return this.fServlet;
    }

    public String servletPathToFullUrl(String contentUrl) {
        StringBuilder url = new StringBuilder();
        String scheme = this.fRequest.getScheme().toLowerCase();
        url.append(scheme);
        url.append("://");
        url.append(this.fRequest.getServerName());
        int serverPort = this.fRequest.getServerPort();
        if (!(scheme.equals("http") && serverPort == 80 || scheme.equals("https") && serverPort == 443)) {
            url.append(":");
            url.append(serverPort);
        }
        String path = this.servletPathToFullPath(contentUrl);
        url.append(path);
        log.info("calculated full URL for [" + contentUrl + "]: [" + url + "]");
        return url.toString();
    }

    public String servletPathToFullPath(String contentUrl) {
        return CHttpRequestContext.servletPathToFullPath(contentUrl, this.fRequest);
    }

    public static String servletPathToFullPath(String contentUrl, HttpServletRequest req) {
        StringBuilder sb = new StringBuilder();
        String contextPart = req.getContextPath();
        sb.append(contextPart);
        String servletPart = req.getServletPath();
        sb.append(servletPart);
        sb.append(contentUrl);
        log.info("calculated full path for [" + contentUrl + "]: context=[" + contextPart + "], servlet=[" + servletPart + "], result=[" + sb.toString() + "]");
        return sb.toString();
    }

    public Object object(String key) {
        return this.fObjects.get(key);
    }

    public CHttpRequest request() {
        if (this.fRequestWrapper == null) {
            this.fRequestWrapper = new StdRequest(this.fRequest, this.fInspector);
        }
        return this.fRequestWrapper;
    }

    public CHttpResponse response() {
        if (this.fResponseWrapper == null) {
            this.fResponseWrapper = new StdResponse(this.fRequest, this.fResponse, this.fRouter, this.fInspector);
        }
        return this.fResponseWrapper;
    }
}

