/*
 * Decompiled with CFR 0.152.
 */
package io.continual.http.service.framework.context;

import io.continual.http.service.framework.CHttpConnection;
import io.continual.http.service.framework.context.CHttpRequestContext;
import io.continual.http.service.framework.context.CHttpResponse;
import io.continual.http.service.framework.inspection.CHttpObserver;
import io.continual.http.service.framework.routing.CHttpRequestRouter;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.io.Writer;
import java.util.HashMap;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class StdResponse
implements CHttpResponse {
    private final HttpServletRequest fRequest;
    private final boolean fResponseEntityAllowed;
    private final HttpServletResponse fResponse;
    private final CHttpRequestRouter fRouter;
    private final CHttpObserver fInspector;
    private static Logger log = LoggerFactory.getLogger(StdResponse.class);

    public StdResponse(HttpServletRequest req, HttpServletResponse r, CHttpRequestRouter rr, CHttpObserver inspector) {
        this.fRequest = req;
        this.fResponseEntityAllowed = !req.getMethod().equalsIgnoreCase("HEAD");
        this.fResponse = r;
        this.fRouter = rr;
        this.fInspector = inspector;
    }

    @Override
    public void sendErrorAndBody(int err, String content, String mimeType) {
        try {
            this.setStatus(err);
            this.getStreamForTextResponse(mimeType).println(content);
        }
        catch (IOException e) {
            log.warn("Error sending error response: " + e.getMessage());
        }
    }

    @Override
    public void sendError(int err, String msg) {
        this.sendStatusAndMessage(err, msg);
    }

    @Override
    public void sendStatusAndMessage(int status, String msg) {
        try {
            this.fInspector.replyWith(status, msg);
            this.fResponse.sendError(status, msg);
        }
        catch (IOException e) {
            log.error("Error sending response: " + e.getMessage());
        }
    }

    @Override
    public CHttpResponse setStatus(int code) {
        this.fInspector.replyWith(code);
        this.fResponse.setStatus(code);
        return this;
    }

    @Override
    public int getStatusCode() {
        return this.fResponse.getStatus();
    }

    @Override
    public CHttpResponse setContentType(String mimeType) {
        this.fInspector.replyHeader("ContentType", mimeType);
        this.fResponse.setContentType(mimeType);
        return this;
    }

    @Override
    public CHttpResponse send(String content) throws IOException {
        PrintWriter pw = new PrintWriter(this.fResponse.getWriter());
        pw.print(content);
        pw.close();
        return this;
    }

    @Override
    public CHttpResponse writeHeader(String headerName, String headerValue) {
        this.writeHeader(headerName, headerValue, false);
        return this;
    }

    @Override
    public CHttpResponse writeHeader(String headerName, String headerValue, boolean overwrite) {
        this.fInspector.replyHeader(headerName, headerValue);
        if (overwrite) {
            this.fResponse.setHeader(headerName, headerValue);
        } else {
            this.fResponse.addHeader(headerName, headerValue);
        }
        return this;
    }

    @Override
    public OutputStream getStreamForBinaryResponse() throws IOException {
        return this.getStreamForBinaryResponse("application/octet-stream");
    }

    @Override
    public OutputStream getStreamForBinaryResponse(String contentType) throws IOException {
        this.fResponse.setContentType(contentType);
        OutputStream os = this.fResponseEntityAllowed ? this.fInspector.wrap(this.fResponse.getOutputStream()) : new NullStream();
        return os;
    }

    @Override
    public PrintWriter getStreamForTextResponse() throws IOException {
        return this.getStreamForTextResponse("text/html");
    }

    @Override
    public PrintWriter getStreamForTextResponse(String contentType) throws IOException {
        return this.getStreamForTextResponse(contentType, "UTF-8");
    }

    @Override
    public PrintWriter getStreamForTextResponse(String contentType, String encoding) throws IOException {
        this.fResponse.setContentType(contentType);
        this.fResponse.setCharacterEncoding(encoding);
        PrintWriter pw = this.fResponseEntityAllowed ? this.fInspector.wrap(this.fResponse.getWriter()) : new PrintWriter(new NullWriter());
        return pw;
    }

    @Override
    public void redirect(String url) {
        this.redirectExactly(CHttpRequestContext.servletPathToFullPath(url, this.fRequest));
    }

    @Override
    public void redirect(Class<?> cls, String method, CHttpConnection forSession) {
        this.redirect(cls, method, new HashMap<String, Object>(), forSession);
    }

    @Override
    public void redirect(Class<?> cls, String method, Map<String, Object> args, CHttpConnection forSession) {
        String localUrl = this.fRouter.reverseRoute(cls, method, args, forSession);
        if (localUrl == null) {
            log.error("No reverse route for " + cls.getName() + "::" + method + " with " + (args == null ? 0 : args.size()) + " args.");
            localUrl = "/";
        }
        this.redirect(localUrl);
    }

    @Override
    public void redirectExactly(String url) {
        try {
            this.fResponse.sendRedirect(url);
        }
        catch (IOException e) {
            log.error("Error sending redirect: " + e.getMessage());
        }
    }

    private static class NullStream
    extends OutputStream {
        private NullStream() {
        }

        @Override
        public void write(int b) {
        }
    }

    private static class NullWriter
    extends Writer {
        private NullWriter() {
        }

        @Override
        public void write(char[] cbuf, int off, int len) {
        }

        @Override
        public void flush() {
        }

        @Override
        public void close() {
        }
    }
}

