/*
 * Decompiled with CFR 0.152.
 */
package io.continual.iam.apiserver.endpoints;

import io.continual.http.service.framework.context.CHttpRequestContext;
import io.continual.iam.IamServiceManager;
import io.continual.iam.exceptions.IamGroupDoesNotExist;
import io.continual.iam.exceptions.IamGroupExists;
import io.continual.iam.exceptions.IamIdentityDoesNotExist;
import io.continual.iam.exceptions.IamIdentityExists;
import io.continual.iam.exceptions.IamSvcException;
import io.continual.iam.identity.Group;
import io.continual.iam.identity.Identity;
import io.continual.iam.identity.UserContext;
import io.continual.restHttp.ApiContextHelper;
import io.continual.restHttp.HttpServlet;
import io.continual.util.data.json.JsonVisitor;
import java.io.IOException;
import java.util.Collection;
import java.util.Map;
import java.util.Set;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class IamApiHandler
extends ApiContextHelper<Identity> {
    private final IamServiceManager<?, ?> fAccts;
    private final ApiContextHelper.ResourceAccess fAcctReader;
    private final ApiContextHelper.ResourceAccess fAcctWriter;

    public IamApiHandler(IamServiceManager<?, ?> accts, String acctResourceId) {
        this.fAccts = accts;
        this.fAcctReader = new ApiContextHelper.ResourceAccess(acctResourceId, "read");
        this.fAcctWriter = new ApiContextHelper.ResourceAccess(acctResourceId, "update");
    }

    public void getUsers(CHttpRequestContext context) throws IamSvcException {
        this.handleWithApiAuthAndAccess(context, (ApiContextHelper.ApiHandler)new ApiContextHelper.ApiHandler<Identity>(){

            public void handle(CHttpRequestContext context, HttpServlet servlet, UserContext<Identity> uc) throws IOException {
                try {
                    Collection users = IamApiHandler.this.fAccts.getIdentityManager().getAllUsers();
                    JSONArray usersJson = JsonVisitor.listToArray((Collection)users);
                    IamApiHandler.sendJson((CHttpRequestContext)context, (JSONObject)new JSONObject().put("users", (Object)usersJson));
                }
                catch (IamSvcException x) {
                    IamApiHandler.sendStatusCodeAndMessage((CHttpRequestContext)context, (int)503, (String)"Couldn't access the IAM service.");
                }
            }
        }, new ApiContextHelper.ResourceAccess[]{this.fAcctReader});
    }

    public void getUser(CHttpRequestContext context, final String userId) throws IamSvcException {
        this.handleWithApiAuthAndAccess(context, (ApiContextHelper.ApiHandler)new ApiContextHelper.ApiHandler<Identity>(){

            public void handle(CHttpRequestContext context, HttpServlet servlet, UserContext<Identity> uc) throws IOException {
                try {
                    Identity user = IamApiHandler.this.fAccts.getIdentityManager().loadUser(userId);
                    if (user == null) {
                        IamApiHandler.sendStatusCodeAndMessage((CHttpRequestContext)context, (int)404, (String)"User not found.");
                    } else {
                        IamApiHandler.sendJson((CHttpRequestContext)context, (JSONObject)IamApiHandler.this.renderUser(user));
                    }
                }
                catch (IamSvcException x) {
                    IamApiHandler.sendStatusCodeAndMessage((CHttpRequestContext)context, (int)503, (String)"Couldn't access the IAM service.");
                }
            }
        }, new ApiContextHelper.ResourceAccess[]{this.fAcctReader});
    }

    public void createUser(CHttpRequestContext context) throws IamSvcException {
        this.handleWithApiAuthAndAccess(context, (ApiContextHelper.ApiHandler)new ApiContextHelper.ApiHandler<Identity>(){

            public void handle(CHttpRequestContext context, HttpServlet servlet, UserContext<Identity> uc) throws IOException {
                try {
                    JSONObject body = IamApiHandler.readBody((CHttpRequestContext)context);
                    String username = body.getString("username");
                    Identity user = IamApiHandler.this.fAccts.getIdentityManager().createUser(username);
                    JSONArray groups = body.optJSONArray("groups");
                    if (groups != null) {
                        for (int i = 0; i < groups.length(); ++i) {
                            try {
                                IamApiHandler.this.fAccts.getAccessManager().addUserToGroup(groups.getString(i), user.getId());
                                continue;
                            }
                            catch (IamIdentityDoesNotExist e) {
                                throw new IamSvcException((Throwable)e);
                            }
                        }
                    }
                    IamApiHandler.sendJson((CHttpRequestContext)context, (JSONObject)IamApiHandler.this.renderUser(user));
                }
                catch (IamSvcException x) {
                    IamApiHandler.sendStatusCodeAndMessage((CHttpRequestContext)context, (int)503, (String)"Couldn't access the IAM service.");
                }
                catch (IamIdentityExists e) {
                    IamApiHandler.sendStatusCodeAndMessage((CHttpRequestContext)context, (int)409, (String)"User exists.");
                }
                catch (IamGroupDoesNotExist e) {
                    IamApiHandler.sendStatusCodeAndMessage((CHttpRequestContext)context, (int)400, (String)"Group does not exist.");
                }
            }
        }, new ApiContextHelper.ResourceAccess[]{this.fAcctWriter});
    }

    public void setPassword(CHttpRequestContext context, final String userId) throws IamSvcException {
        this.handleWithApiAuthAndAccess(context, (ApiContextHelper.ApiHandler)new ApiContextHelper.ApiHandler<Identity>(){

            public void handle(CHttpRequestContext context, HttpServlet servlet, UserContext<Identity> uc) throws IOException {
                try {
                    Identity user = IamApiHandler.this.fAccts.getIdentityManager().loadUser(userId);
                    if (user == null) {
                        IamApiHandler.sendStatusCodeAndMessage((CHttpRequestContext)context, (int)404, (String)"User not found.");
                    } else {
                        JSONObject body = IamApiHandler.readBody((CHttpRequestContext)context);
                        String pwd = body.getString("password");
                        user.setPassword(pwd);
                        IamApiHandler.sendJson((CHttpRequestContext)context, (JSONObject)IamApiHandler.this.renderUser(user));
                    }
                }
                catch (JSONException x) {
                    IamApiHandler.sendStatusCodeAndMessage((CHttpRequestContext)context, (int)400, (String)"Couldn't process this request.");
                }
                catch (IamSvcException x) {
                    IamApiHandler.sendStatusCodeAndMessage((CHttpRequestContext)context, (int)503, (String)"Couldn't access the IAM service.");
                }
            }
        }, new ApiContextHelper.ResourceAccess[]{this.fAcctWriter});
    }

    public void setData(CHttpRequestContext context, final String userId, final String dataKey) throws IamSvcException {
        this.handleWithApiAuthAndAccess(context, (ApiContextHelper.ApiHandler)new ApiContextHelper.ApiHandler<Identity>(){

            public void handle(CHttpRequestContext context, HttpServlet servlet, UserContext<Identity> uc) throws IOException {
                try {
                    Identity user = IamApiHandler.this.fAccts.getIdentityManager().loadUser(userId);
                    if (user == null) {
                        IamApiHandler.sendStatusCodeAndMessage((CHttpRequestContext)context, (int)404, (String)"User not found.");
                    } else {
                        JSONObject body = IamApiHandler.readBody((CHttpRequestContext)context);
                        String value = body.getString("value");
                        user.putUserData(dataKey, value);
                        IamApiHandler.sendJson((CHttpRequestContext)context, (JSONObject)IamApiHandler.this.renderUser(user));
                    }
                }
                catch (JSONException x) {
                    IamApiHandler.sendStatusCodeAndMessage((CHttpRequestContext)context, (int)400, (String)"Couldn't process this request.");
                }
                catch (IamSvcException x) {
                    IamApiHandler.sendStatusCodeAndMessage((CHttpRequestContext)context, (int)503, (String)"Couldn't access the IAM service.");
                }
            }
        }, new ApiContextHelper.ResourceAccess[]{this.fAcctWriter});
    }

    public void removeData(CHttpRequestContext context, final String userId, final String dataKey) throws IamSvcException {
        this.handleWithApiAuthAndAccess(context, (ApiContextHelper.ApiHandler)new ApiContextHelper.ApiHandler<Identity>(){

            public void handle(CHttpRequestContext context, HttpServlet servlet, UserContext<Identity> uc) throws IOException {
                try {
                    Identity user = IamApiHandler.this.fAccts.getIdentityManager().loadUser(userId);
                    if (user == null) {
                        IamApiHandler.sendStatusCodeAndMessage((CHttpRequestContext)context, (int)404, (String)"User not found.");
                    } else {
                        user.removeUserData(dataKey);
                        IamApiHandler.sendJson((CHttpRequestContext)context, (JSONObject)IamApiHandler.this.renderUser(user));
                    }
                }
                catch (JSONException x) {
                    IamApiHandler.sendStatusCodeAndMessage((CHttpRequestContext)context, (int)400, (String)"Couldn't process this request.");
                }
                catch (IamSvcException x) {
                    IamApiHandler.sendStatusCodeAndMessage((CHttpRequestContext)context, (int)503, (String)"Couldn't access the IAM service.");
                }
            }
        }, new ApiContextHelper.ResourceAccess[]{this.fAcctWriter});
    }

    public void removeDataSet(CHttpRequestContext context, final String userId) throws IamSvcException {
        this.handleWithApiAuthAndAccess(context, (ApiContextHelper.ApiHandler)new ApiContextHelper.ApiHandler<Identity>(){

            public void handle(CHttpRequestContext context, HttpServlet servlet, UserContext<Identity> uc) throws IOException {
                try {
                    Identity user = IamApiHandler.this.fAccts.getIdentityManager().loadUser(userId);
                    if (user == null) {
                        IamApiHandler.sendStatusCodeAndMessage((CHttpRequestContext)context, (int)404, (String)"User not found.");
                    } else {
                        JSONObject body = IamApiHandler.readBody((CHttpRequestContext)context);
                        JSONArray keys = body.getJSONArray("keys");
                        for (int i = 0; i < keys.length(); ++i) {
                            String key = keys.getString(i);
                            user.removeUserData(key);
                        }
                        IamApiHandler.sendJson((CHttpRequestContext)context, (JSONObject)IamApiHandler.this.renderUser(user));
                    }
                }
                catch (JSONException x) {
                    IamApiHandler.sendStatusCodeAndMessage((CHttpRequestContext)context, (int)400, (String)"Couldn't process this request.");
                }
                catch (IamSvcException x) {
                    IamApiHandler.sendStatusCodeAndMessage((CHttpRequestContext)context, (int)503, (String)"Couldn't access the IAM service.");
                }
            }
        }, new ApiContextHelper.ResourceAccess[]{this.fAcctWriter});
    }

    public void setEnabled(CHttpRequestContext context, final String userId) throws IamSvcException {
        this.handleWithApiAuthAndAccess(context, (ApiContextHelper.ApiHandler)new ApiContextHelper.ApiHandler<Identity>(){

            public void handle(CHttpRequestContext context, HttpServlet servlet, UserContext<Identity> uc) throws IOException {
                try {
                    Identity user = IamApiHandler.this.fAccts.getIdentityManager().loadUser(userId);
                    if (user == null) {
                        IamApiHandler.sendStatusCodeAndMessage((CHttpRequestContext)context, (int)404, (String)"User not found.");
                    } else {
                        JSONObject body = IamApiHandler.readBody((CHttpRequestContext)context);
                        user.enable(body.getBoolean("enabled"));
                        IamApiHandler.sendJson((CHttpRequestContext)context, (JSONObject)IamApiHandler.this.renderUser(user));
                    }
                }
                catch (JSONException x) {
                    IamApiHandler.sendStatusCodeAndMessage((CHttpRequestContext)context, (int)400, (String)"Couldn't process this request.");
                }
                catch (IamSvcException x) {
                    IamApiHandler.sendStatusCodeAndMessage((CHttpRequestContext)context, (int)503, (String)"Couldn't access the IAM service.");
                }
            }
        }, new ApiContextHelper.ResourceAccess[]{this.fAcctWriter});
    }

    public void createGroup(CHttpRequestContext context) throws IamSvcException {
        this.handleWithApiAuthAndAccess(context, (ApiContextHelper.ApiHandler)new ApiContextHelper.ApiHandler<Identity>(){

            public void handle(CHttpRequestContext context, HttpServlet servlet, UserContext<Identity> uc) throws IOException {
                try {
                    JSONObject body = IamApiHandler.readBody((CHttpRequestContext)context);
                    String groupName = body.getString("group");
                    Group group = IamApiHandler.this.fAccts.getAccessManager().createGroup(groupName, groupName);
                    IamApiHandler.sendJson((CHttpRequestContext)context, (JSONObject)IamApiHandler.this.renderGroup(group));
                }
                catch (IamSvcException x) {
                    IamApiHandler.sendStatusCodeAndMessage((CHttpRequestContext)context, (int)503, (String)"Couldn't access the IAM service.");
                }
                catch (IamGroupExists e) {
                    IamApiHandler.sendStatusCodeAndMessage((CHttpRequestContext)context, (int)409, (String)"The group exists.");
                }
            }
        }, new ApiContextHelper.ResourceAccess[]{this.fAcctWriter});
    }

    public void getGroups(CHttpRequestContext context) throws IamSvcException {
        this.handleWithApiAuthAndAccess(context, (ApiContextHelper.ApiHandler)new ApiContextHelper.ApiHandler<Identity>(){

            public void handle(CHttpRequestContext context, HttpServlet servlet, UserContext<Identity> uc) throws IOException {
                try {
                    Collection groups = IamApiHandler.this.fAccts.getAccessManager().getAllGroups();
                    JSONArray groupsJson = JsonVisitor.listToArray((Collection)groups);
                    IamApiHandler.sendJson((CHttpRequestContext)context, (JSONObject)new JSONObject().put("groups", (Object)groupsJson));
                }
                catch (IamSvcException x) {
                    IamApiHandler.sendStatusCodeAndMessage((CHttpRequestContext)context, (int)503, (String)"Couldn't access the IAM service.");
                }
            }
        }, new ApiContextHelper.ResourceAccess[]{this.fAcctReader});
    }

    public void getGroup(CHttpRequestContext context, final String groupId) throws IamSvcException {
        this.handleWithApiAuthAndAccess(context, (ApiContextHelper.ApiHandler)new ApiContextHelper.ApiHandler<Identity>(){

            public void handle(CHttpRequestContext context, HttpServlet servlet, UserContext<Identity> uc) throws IOException {
                try {
                    Group group = IamApiHandler.this.fAccts.getAccessManager().loadGroup(groupId);
                    if (group == null) {
                        IamApiHandler.sendStatusCodeAndMessage((CHttpRequestContext)context, (int)404, (String)"Group not found.");
                    } else {
                        IamApiHandler.sendJson((CHttpRequestContext)context, (JSONObject)IamApiHandler.this.renderGroup(group));
                    }
                }
                catch (IamSvcException x) {
                    IamApiHandler.sendStatusCodeAndMessage((CHttpRequestContext)context, (int)503, (String)"Couldn't access the IAM service.");
                }
            }
        }, new ApiContextHelper.ResourceAccess[]{this.fAcctReader});
    }

    public void addUserToGroup(CHttpRequestContext context, final String groupId, final String userId) throws IamSvcException {
        this.handleWithApiAuthAndAccess(context, (ApiContextHelper.ApiHandler)new ApiContextHelper.ApiHandler<Identity>(){

            public void handle(CHttpRequestContext context, HttpServlet servlet, UserContext<Identity> uc) throws IOException {
                try {
                    Group group = IamApiHandler.this.fAccts.getAccessManager().loadGroup(groupId);
                    if (group == null) {
                        IamApiHandler.sendStatusCodeAndMessage((CHttpRequestContext)context, (int)404, (String)"Group not found.");
                        return;
                    }
                    IamApiHandler.this.fAccts.getAccessManager().addUserToGroup(groupId, userId);
                    IamApiHandler.sendJson((CHttpRequestContext)context, (JSONObject)IamApiHandler.this.renderGroup(IamApiHandler.this.fAccts.getAccessManager().loadGroup(groupId)));
                }
                catch (IamGroupDoesNotExist x) {
                    IamApiHandler.sendStatusCodeAndMessage((CHttpRequestContext)context, (int)404, (String)"Group not found.");
                }
                catch (IamIdentityDoesNotExist x) {
                    IamApiHandler.sendStatusCodeAndMessage((CHttpRequestContext)context, (int)404, (String)"User not found.");
                }
                catch (IamSvcException x) {
                    IamApiHandler.sendStatusCodeAndMessage((CHttpRequestContext)context, (int)503, (String)"Couldn't access the IAM service.");
                }
            }
        }, new ApiContextHelper.ResourceAccess[]{this.fAcctWriter});
    }

    public void deleteUserFromGroup(CHttpRequestContext context, final String groupId, final String userId) throws IamSvcException {
        this.handleWithApiAuthAndAccess(context, (ApiContextHelper.ApiHandler)new ApiContextHelper.ApiHandler<Identity>(){

            public void handle(CHttpRequestContext context, HttpServlet servlet, UserContext<Identity> uc) throws IOException {
                try {
                    Group group = IamApiHandler.this.fAccts.getAccessManager().loadGroup(groupId);
                    if (group == null) {
                        IamApiHandler.sendStatusCodeAndMessage((CHttpRequestContext)context, (int)404, (String)"Group not found.");
                        return;
                    }
                    IamApiHandler.this.fAccts.getAccessManager().removeUserFromGroup(groupId, userId);
                    IamApiHandler.sendJson((CHttpRequestContext)context, (JSONObject)IamApiHandler.this.renderGroup(IamApiHandler.this.fAccts.getAccessManager().loadGroup(groupId)));
                }
                catch (IamGroupDoesNotExist x) {
                    IamApiHandler.sendStatusCodeAndMessage((CHttpRequestContext)context, (int)404, (String)"Group not found.");
                }
                catch (IamIdentityDoesNotExist x) {
                    IamApiHandler.sendStatusCodeAndMessage((CHttpRequestContext)context, (int)404, (String)"User not found.");
                }
                catch (IamSvcException x) {
                    IamApiHandler.sendStatusCodeAndMessage((CHttpRequestContext)context, (int)503, (String)"Couldn't access the IAM service.");
                }
            }
        }, new ApiContextHelper.ResourceAccess[]{this.fAcctWriter});
    }

    public void deleteUsersFromGroup(CHttpRequestContext context) throws IamSvcException {
        this.handleWithApiAuthAndAccess(context, (ApiContextHelper.ApiHandler)new ApiContextHelper.ApiHandler<Identity>(){

            public void handle(CHttpRequestContext context, HttpServlet servlet, UserContext<Identity> uc) throws IOException {
                try {
                    JSONObject body = IamApiHandler.readBody((CHttpRequestContext)context);
                    if (body.has("userId")) {
                        String userId = body.getString("userId");
                        JSONArray groups = body.getJSONArray("groups");
                        Identity user = IamApiHandler.this.fAccts.getIdentityManager().loadUser(userId);
                        if (user == null) {
                            IamApiHandler.sendStatusCodeAndMessage((CHttpRequestContext)context, (int)404, (String)"User not found.");
                            return;
                        }
                        for (int i = 0; i < groups.length(); ++i) {
                            String groupId = groups.getString(i);
                            IamApiHandler.this.fAccts.getAccessManager().removeUserFromGroup(groupId, userId);
                        }
                        IamApiHandler.sendJson((CHttpRequestContext)context, (JSONObject)IamApiHandler.this.renderUser(IamApiHandler.this.fAccts.getIdentityManager().loadUser(userId)));
                    } else {
                        String groupId = body.getString("groupId");
                        JSONArray users = body.getJSONArray("users");
                        Group group = IamApiHandler.this.fAccts.getAccessManager().loadGroup(groupId);
                        if (group == null) {
                            IamApiHandler.sendStatusCodeAndMessage((CHttpRequestContext)context, (int)404, (String)"Group not found.");
                            return;
                        }
                        for (int i = 0; i < users.length(); ++i) {
                            String userId = users.getString(i);
                            IamApiHandler.this.fAccts.getAccessManager().removeUserFromGroup(groupId, userId);
                        }
                        IamApiHandler.sendJson((CHttpRequestContext)context, (JSONObject)IamApiHandler.this.renderGroup(IamApiHandler.this.fAccts.getAccessManager().loadGroup(groupId)));
                    }
                }
                catch (IamGroupDoesNotExist x) {
                    IamApiHandler.sendStatusCodeAndMessage((CHttpRequestContext)context, (int)404, (String)"Group not found.");
                }
                catch (IamIdentityDoesNotExist x) {
                    IamApiHandler.sendStatusCodeAndMessage((CHttpRequestContext)context, (int)404, (String)"User not found.");
                }
                catch (IamSvcException x) {
                    IamApiHandler.sendStatusCodeAndMessage((CHttpRequestContext)context, (int)503, (String)"Couldn't access the IAM service.");
                }
            }
        }, new ApiContextHelper.ResourceAccess[]{this.fAcctWriter});
    }

    private JSONObject renderUser(Identity user) throws IamSvcException {
        Set groupIds = user.getGroupIds();
        JSONArray groupArr = JsonVisitor.listToArray((Collection)groupIds);
        Collection apiKeys = user.loadApiKeysForUser();
        JSONArray apiKeysArr = JsonVisitor.listToArray((Collection)apiKeys);
        Map data = user.getAllUserData();
        JSONObject dataObj = JsonVisitor.mapOfStringsToObject((Map)data);
        return new JSONObject().put("id", (Object)user.getId()).put("enabled", user.isEnabled()).put("groups", (Object)groupArr).put("apiKeys", (Object)apiKeysArr).put("data", (Object)dataObj);
    }

    private JSONObject renderGroup(Group group) throws IamSvcException {
        Set users = group.getMembers();
        JSONArray usersArr = JsonVisitor.listToArray((Collection)users);
        Map data = group.getAllUserData();
        JSONObject dataObj = JsonVisitor.mapOfStringsToObject((Map)data);
        return new JSONObject().put("id", (Object)group.getId()).put("name", (Object)group.getName()).put("users", (Object)usersArr).put("data", (Object)dataObj);
    }
}

