/*
 * Decompiled with CFR 0.152.
 */
package io.continual.services;

import io.continual.util.data.json.JsonUtil;
import java.util.Collection;
import java.util.TreeSet;
import org.json.JSONObject;

public class ConfigObject {
    private final JSONObject fData;
    private ConfigObject fBase = null;
    private JSONObject fMerged;

    public ConfigObject() {
        this(new JSONObject());
    }

    public ConfigObject(JSONObject o) {
        this.fData = JsonUtil.clone((JSONObject)(o == null ? new JSONObject() : o));
        this.mergeData();
    }

    public static ConfigObject read(JSONObject o) {
        return new ConfigObject(o);
    }

    public String toString() {
        return this.toJson().toString(4);
    }

    public JSONObject toJson() {
        return JsonUtil.clone((JSONObject)this.fMerged);
    }

    public int size() {
        return this.fMerged.length();
    }

    public ConfigObject setBaseConfig(ConfigObject co) {
        this.fBase = co;
        this.mergeData();
        return this;
    }

    public String get(String key) {
        return this.get(key, null);
    }

    public String get(String key, String defval) {
        if (this.fMerged.has(key)) {
            return this.fMerged.getString(key);
        }
        return defval;
    }

    public boolean getBoolean(String key) {
        return this.getBoolean(key, false);
    }

    public boolean getBoolean(String key, boolean defval) {
        if (this.fMerged.has(key)) {
            return this.fMerged.optBoolean(key);
        }
        return defval;
    }

    public Collection<String> getAllKeys() {
        TreeSet<String> keys = new TreeSet<String>();
        for (Object key : this.fMerged.keySet()) {
            keys.add(key.toString());
        }
        return keys;
    }

    protected void set(String key, String value) {
        this.fData.put(key, (Object)value);
        this.mergeData();
    }

    protected ConfigObject getSubConfig(String serviceName) {
        JSONObject data = this.fMerged.optJSONObject(serviceName);
        return data == null ? new ConfigObject() : new ConfigObject(data);
    }

    private void mergeData() {
        this.fMerged = this.fBase == null ? JsonUtil.clone((JSONObject)this.fData) : JsonUtil.overlay((JSONObject)JsonUtil.clone((JSONObject)this.fBase.toJson()), (JSONObject)this.fData);
    }
}

