/*
 * Decompiled with CFR 0.152.
 */
package io.continual.services;

import io.continual.builder.Builder;
import io.continual.builder.sources.BuilderJsonDataSource;
import io.continual.services.Server;
import io.continual.services.Service;
import io.continual.services.ServiceConfig;
import io.continual.services.ServiceContainerFactory;
import io.continual.services.ServiceSet;
import io.continual.util.collections.MultiMap;
import io.continual.util.console.ConsoleProgram;
import io.continual.util.data.exprEval.EnvDataSource;
import io.continual.util.data.exprEval.ExprDataSource;
import io.continual.util.data.exprEval.ExprDataSourceStack;
import io.continual.util.data.exprEval.ExpressionEvaluator;
import io.continual.util.data.exprEval.JsonDataSource;
import io.continual.util.data.exprEval.SpecialFnsDataSource;
import io.continual.util.nv.NvReadable;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.json.JSONObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ServiceContainer {
    public static final String kServices = "services";
    public static final String kServicesChar = "s";
    public static final String kProfile = "profile";
    public static final String kProfileChar = "p";
    private final LinkedList<Service> fServices = new LinkedList();
    private final MultiMap<String, Service> fServiceByName = new MultiMap();
    private static final Logger log = LoggerFactory.getLogger(ServiceContainer.class);

    public static ServiceContainer build(NvReadable p, boolean withStart) throws ConsoleProgram.StartupFailureException {
        return ServiceContainer.build(p, withStart, new Server.StdFactory());
    }

    public static <T extends ServiceContainer> T build(NvReadable p, boolean withStart, ServiceContainerFactory<T> scf) throws ConsoleProgram.StartupFailureException {
        String services = p.getString(kServices, "services.json");
        if (services == null) {
            throw new ConsoleProgram.StartupFailureException("No services configuration name provided.");
        }
        InputStream serviceStream = ServiceContainer.class.getClassLoader().getResourceAsStream(services);
        if (serviceStream == null) {
            throw new ConsoleProgram.StartupFailureException("No service stream available.");
        }
        return ServiceContainer.build(serviceStream, p.getStrings(kProfile, new String[]{"default"}), withStart, scf);
    }

    public static ServiceContainer build(InputStream serviceStream, String[] profiles, boolean withStart) throws ConsoleProgram.StartupFailureException {
        return ServiceContainer.build(serviceStream, profiles, withStart, new Server.StdFactory());
    }

    public static <T extends ServiceContainer> T build(InputStream serviceStream, String[] profiles, boolean withStart, ServiceContainerFactory<T> scf) throws ConsoleProgram.StartupFailureException {
        T svcContainer = scf.create();
        if (serviceStream == null) {
            throw new ConsoleProgram.StartupFailureException("No stream provided");
        }
        ServiceSet tlc = ServiceSet.readConfig(new InputStreamReader(serviceStream));
        for (String profile : profiles) {
            log.info("Profile [" + profile + "] is active.");
            tlc.applyProfile(profile);
        }
        for (ServiceConfig sc : tlc.getServices()) {
            if (sc.enabled()) {
                log.info("Service [" + sc.getName() + "] is enabled...");
                try {
                    Service s = Builder.withBaseClass(Service.class).usingClassName(sc.getClassname()).usingData(new BuilderJsonDataSource(sc.toJson())).providingContext(svcContainer).build();
                    ((ServiceContainer)svcContainer).add(sc.getName(), s);
                    continue;
                }
                catch (Builder.BuildFailure e) {
                    throw new ConsoleProgram.StartupFailureException((Exception)e);
                }
            }
            log.info("Service [" + sc.getName() + "] is disabled.");
        }
        try {
            if (withStart) {
                log.info("Starting services...");
                ((ServiceContainer)svcContainer).startAll();
                log.info("Server is ready.");
            }
        }
        catch (Service.FailedToStart e) {
            throw new ConsoleProgram.StartupFailureException((Exception)e);
        }
        return svcContainer;
    }

    public synchronized void add(String name, Service s) {
        this.fServices.add(s);
        if (name != null) {
            int count = this.fServiceByName.size((Object)name);
            if (count > 0) {
                log.warn("While adding service [{}], {} instances are already present.", (Object)name, (Object)count);
            }
            this.fServiceByName.put((Object)name, (Object)s);
        }
    }

    public synchronized List<String> getServiceNames() {
        return new LinkedList<String>(this.fServiceByName.getKeys());
    }

    public synchronized List<Service> getServices() {
        return new LinkedList<Service>(this.fServices);
    }

    public synchronized <T> T get(String name, Class<T> asClass) {
        List svcs = this.fServiceByName.get((Object)name);
        if (svcs != null) {
            for (Service svc : svcs) {
                if (!asClass.isInstance(svc)) continue;
                return (T)svc;
            }
        }
        return null;
    }

    public void startAll() throws Service.FailedToStart {
        try {
            for (Map.Entry svcEntry : this.fServiceByName.getValues().entrySet()) {
                log.info("Starting service [{}]...", svcEntry.getKey());
                for (Service svc : (List)svcEntry.getValue()) {
                    svc.start();
                }
            }
        }
        catch (Service.FailedToStart e) {
            this.stopAll();
            throw e;
        }
    }

    public void stopAll() {
        for (Service svc : this.getServices()) {
            svc.requestFinish();
        }
    }

    public void awaitTermination() throws InterruptedException {
        int runCount = Integer.MAX_VALUE;
        while (runCount > 0) {
            Thread.sleep(250L);
            runCount = 0;
            for (Service s : this.getServices()) {
                if (!s.isRunning()) continue;
                ++runCount;
            }
        }
    }

    public ExpressionEvaluator getExprEval() {
        return this.getExprEval(null);
    }

    public ExpressionEvaluator getExprEval(JSONObject data) {
        ExprDataSourceStack stack = new ExprDataSourceStack(new ExprDataSource[]{new JsonDataSource(data), new EnvDataSource(), new SpecialFnsDataSource()});
        return new ExpressionEvaluator(new ExprDataSource[]{stack});
    }
}

