/*
 * Decompiled with CFR 0.152.
 */
package io.continual.email;

import io.continual.services.Service;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import javax.mail.MessagingException;
import javax.mail.internet.MimeBodyPart;

public interface EmailService
extends Service {
    public MailBuilder createMessage();

    public Future<MailStatus> mail(MailBuilder var1);

    default public Future<MailStatus> mail(String to, String subject, String msg) {
        try {
            return this.mail(this.createMessage().to(to).withSubject(subject).withBodyPart("text/plain", msg));
        }
        catch (MessagingException e) {
            return new InterfaceSendFailure(e.getMessage());
        }
    }

    default public Future<MailStatus> mail(String[] toAddrs, String subject, String msgBody) {
        return this.mail(Arrays.asList(toAddrs), subject, msgBody);
    }

    default public Future<MailStatus> mail(Collection<String> toAddrs, String subject, String msgBody) {
        try {
            MailBuilder mb = this.createMessage().withSubject(subject).withBodyPart("text/plain", msgBody);
            for (String to : toAddrs) {
                mb = mb.to(to);
            }
            return this.mail(mb);
        }
        catch (MessagingException e) {
            return new InterfaceSendFailure(e.getMessage());
        }
    }

    public void close();

    public static class InterfaceSendFailure
    implements Future<MailStatus> {
        private final String fMsg;

        public InterfaceSendFailure(String msg) {
            this.fMsg = msg;
        }

        @Override
        public boolean cancel(boolean mayInterruptIfRunning) {
            return false;
        }

        @Override
        public boolean isCancelled() {
            return false;
        }

        @Override
        public boolean isDone() {
            return true;
        }

        @Override
        public MailStatus get() {
            return new MailStatus(){

                @Override
                public boolean didSend() {
                    return false;
                }

                @Override
                public boolean didFail() {
                    return true;
                }

                @Override
                public String getErrorMsg() {
                    return fMsg;
                }
            };
        }

        @Override
        public MailStatus get(long timeout, TimeUnit unit) {
            return this.get();
        }
    }

    public static interface MailBuilder {
        default public MailBuilder to(List<String> toAddrs) {
            for (String to : toAddrs) {
                this.to(to);
            }
            return this;
        }

        default public MailBuilder to(String ... toAddrs) {
            for (String to : toAddrs) {
                this.to(to);
            }
            return this;
        }

        public MailBuilder to(String var1);

        public MailBuilder withSubject(String var1);

        default public MailBuilder withBodyPart(String mimeType, String bodyText) throws MessagingException {
            MimeBodyPart part = new MimeBodyPart();
            part.setContent((Object)bodyText, mimeType);
            return this.withBodyPart(part);
        }

        default public MailBuilder withBodyParts(Map<String, String> render) throws MessagingException {
            for (Map.Entry<String, String> e : render.entrySet()) {
                this.withBodyPart(e.getKey(), e.getValue());
            }
            return this;
        }

        public MailBuilder withBodyPart(MimeBodyPart var1) throws MessagingException;

        public MailBuilder withSimpleText(String var1) throws MessagingException;
    }

    public static interface MailStatus {
        public boolean didSend();

        public boolean didFail();

        public String getErrorMsg();
    }
}

