/*
 * Decompiled with CFR 0.152.
 */
package io.continual.email.impl;

import io.continual.email.EmailService;
import io.continual.services.ServiceContainer;
import io.continual.services.SimpleService;
import io.continual.util.data.exprEval.ExpressionEvaluator;
import java.io.UnsupportedEncodingException;
import java.util.LinkedList;
import java.util.Properties;
import java.util.TreeSet;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import javax.mail.Address;
import javax.mail.BodyPart;
import javax.mail.Message;
import javax.mail.MessagingException;
import javax.mail.Multipart;
import javax.mail.Session;
import javax.mail.Transport;
import javax.mail.internet.InternetAddress;
import javax.mail.internet.MimeBodyPart;
import javax.mail.internet.MimeMessage;
import javax.mail.internet.MimeMultipart;
import org.json.JSONObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SimpleEmailService
extends SimpleService
implements EmailService {
    private final Properties fMailProps;
    private final String fUser;
    private final String fPassword;
    private final String fFromAddr;
    private final String fFromName;
    public static final String kSetting_MailLogin = "mailLogin";
    public static final String kSetting_MailPassword = "mailPassword";
    public static final String kSetting_MailFromEmail = "mailFromEmail";
    public static final String kSetting_MailFromName = "mailFromName";
    public static final String kSetting_SmtpServer = "mailSmtpServer";
    public static final String kSetting_SmtpServerPort = "mailSmtpServerPort";
    public static final String kSetting_SmtpServerSsl = "mailSmtpServerSsl";
    public static final String kSetting_SmtpServerUseAuth = "mailSmtpServerUseAuth";
    private final ExecutorService fSenders;
    private static final Logger log = LoggerFactory.getLogger(SimpleEmailService.class);
    private static final Future<EmailService.MailStatus> kNoopStatus = new Future<EmailService.MailStatus>(){

        @Override
        public boolean cancel(boolean mayInterruptIfRunning) {
            return true;
        }

        @Override
        public boolean isCancelled() {
            return false;
        }

        @Override
        public boolean isDone() {
            return true;
        }

        @Override
        public EmailService.MailStatus get() {
            return new SimpleMailStatus();
        }

        @Override
        public EmailService.MailStatus get(long timeout, TimeUnit unit) {
            return this.get();
        }
    };

    public SimpleEmailService(ServiceContainer sc, JSONObject config) {
        this.fSenders = Executors.newFixedThreadPool(config.optInt("threadCount", 1));
        ExpressionEvaluator ee = sc.getExprEval(config);
        this.fMailProps = new Properties();
        this.fMailProps.put("mail.smtp.port", "" + ee.evaluateTextToInt(config.opt(kSetting_MailFromEmail), 587));
        this.fMailProps.put("mail.smtp.socketFactory.fallback", "false");
        this.fMailProps.put("mail.smtp.quitwait", "false");
        this.fMailProps.put("mail.smtp.host", ee.evaluateText(config.optString(kSetting_SmtpServer, "smtp.gmail.com")));
        this.fMailProps.put("mail.smtp.auth", "" + ee.evaluateTextToBoolean(config.opt(kSetting_SmtpServerUseAuth), true));
        this.fMailProps.put("mail.smtp.starttls.enable", "" + ee.evaluateTextToBoolean(config.opt(kSetting_SmtpServerSsl), true));
        this.fUser = ee.evaluateText(config.optString(kSetting_MailLogin, null));
        this.fPassword = ee.evaluateText(config.optString(kSetting_MailPassword, null));
        this.fFromAddr = ee.evaluateText(config.optString(kSetting_MailFromEmail, "hello@continual.io"));
        this.fFromName = ee.evaluateText(config.optString(kSetting_MailFromName, "Continual.io"));
    }

    @Override
    public EmailService.MailBuilder createMessage() {
        return new MailBuilderImpl();
    }

    @Override
    public Future<EmailService.MailStatus> mail(EmailService.MailBuilder b) {
        MailBuilderImpl builder = (MailBuilderImpl)b;
        if (builder.fTos.size() == 0) {
            return kNoopStatus;
        }
        return this.fSenders.submit(new MailTask(builder));
    }

    @Override
    public void close() {
        try {
            this.fSenders.shutdown();
            this.fSenders.awaitTermination(30L, TimeUnit.SECONDS);
        }
        catch (InterruptedException x) {
            log.warn("SimpleEmailService shutdown took too long.");
            Thread.currentThread().interrupt();
        }
    }

    private static class SimpleMailStatus
    implements EmailService.MailStatus {
        private final String fErr;

        public SimpleMailStatus() {
            this(null);
        }

        public SimpleMailStatus(String err) {
            this.fErr = err;
        }

        @Override
        public boolean didSend() {
            return !this.didFail();
        }

        @Override
        public boolean didFail() {
            return this.fErr != null;
        }

        @Override
        public String getErrorMsg() {
            return this.fErr;
        }
    }

    private class MailTask
    implements Callable<EmailService.MailStatus> {
        private final MailBuilderImpl fBuilder;

        public MailTask(MailBuilderImpl builder) {
            this.fBuilder = builder;
        }

        @Override
        public EmailService.MailStatus call() {
            StringBuffer sbLog = new StringBuffer();
            sbLog.append("sending mail to (");
            StringBuffer addrList = new StringBuffer();
            for (String to : this.fBuilder.fTos) {
                if (addrList.length() > 0) {
                    addrList.append(", ");
                }
                addrList.append(to);
            }
            sbLog.append(addrList.toString());
            sbLog.append(") \"");
            sbLog.append(this.fBuilder.fSubj);
            sbLog.append("\"");
            log.info(sbLog.toString());
            try {
                Session session = Session.getDefaultInstance((Properties)SimpleEmailService.this.fMailProps);
                MimeMessage msg = new MimeMessage(session);
                msg.setSubject(this.fBuilder.fSubj);
                InternetAddress from = new InternetAddress(SimpleEmailService.this.fFromAddr, SimpleEmailService.this.fFromName);
                msg.setFrom((Address)from);
                msg.setReplyTo((Address[])new InternetAddress[]{from});
                for (Object toAddr : this.fBuilder.fTos) {
                    InternetAddress to = new InternetAddress((String)toAddr);
                    msg.addRecipient(Message.RecipientType.TO, (Address)to);
                }
                if (this.fBuilder.isMultipart()) {
                    MimeMultipart contentAlternatives = new MimeMultipart("alternative");
                    for (MimeBodyPart bodyPart : this.fBuilder.fParts) {
                        contentAlternatives.addBodyPart((BodyPart)bodyPart);
                    }
                    MimeBodyPart altsBodyPart = new MimeBodyPart();
                    altsBodyPart.setContent((Multipart)contentAlternatives);
                    MimeMultipart mixedMultipart = new MimeMultipart("mixed");
                    mixedMultipart.addBodyPart((BodyPart)altsBodyPart);
                    msg.setContent((Multipart)mixedMultipart);
                } else {
                    msg.setText(this.fBuilder.getText());
                }
                Transport transport = session.getTransport("smtp");
                transport.connect(SimpleEmailService.this.fUser, SimpleEmailService.this.fPassword);
                transport.sendMessage((Message)msg, msg.getAllRecipients());
                transport.close();
                log.info("Mail sent.");
                return new SimpleMailStatus();
            }
            catch (UnsupportedEncodingException | MessagingException e) {
                log.warn("Error sending email: {}", (Object)e.getMessage(), (Object)e);
                return new SimpleMailStatus(e.getMessage());
            }
        }
    }

    private class MailBuilderImpl
    implements EmailService.MailBuilder {
        private final TreeSet<String> fTos = new TreeSet();
        private String fSubj = "";
        private final LinkedList<MimeBodyPart> fParts = new LinkedList();
        private String fText = "";

        private MailBuilderImpl() {
        }

        @Override
        public EmailService.MailBuilder to(String to) {
            this.fTos.add(to);
            return this;
        }

        @Override
        public EmailService.MailBuilder withSubject(String subj) {
            this.fSubj = subj;
            return this;
        }

        public boolean isMultipart() {
            return this.fParts.size() > 0;
        }

        @Override
        public EmailService.MailBuilder withBodyPart(MimeBodyPart part) {
            this.fParts.add(part);
            return this;
        }

        @Override
        public EmailService.MailBuilder withSimpleText(String text) {
            this.fText = text;
            return this;
        }

        public String getText() {
            return this.fText;
        }
    }
}

