/*
 * Decompiled with CFR 0.152.
 */
package io.continual.onap.services.mrCommon;

import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.TreeSet;

public class HostSelector {
    private final LinkedList<String> fHosts = new LinkedList();

    public static Builder builder() {
        return new Builder();
    }

    public void copyInto(List<String> hosts) {
        hosts.clear();
        hosts.addAll(this.fHosts);
    }

    public synchronized String selectHost() {
        return this.fHosts.getFirst();
    }

    public synchronized void demote(String host) {
        this.fHosts.remove(host);
        this.fHosts.addLast(host);
    }

    private HostSelector(Builder b) {
        this.fHosts.addAll(b.fHostSet);
        if (b.fRandomOrder) {
            Collections.shuffle(this.fHosts);
        }
    }

    public static class Builder {
        private final TreeSet<String> fHostSet = new TreeSet();
        public boolean fRandomOrder = true;

        public HostSelector build() {
            return new HostSelector(this);
        }

        public Builder withHost(String host) {
            this.fHostSet.add(host);
            return this;
        }

        public Builder withHosts(List<String> hosts) {
            this.fHostSet.addAll(hosts);
            return this;
        }

        public Builder useInGivenOrder() {
            this.fRandomOrder = false;
            return this;
        }

        public Builder useInRandomOrder() {
            this.fRandomOrder = true;
            return this;
        }
    }
}

