/*
 * Decompiled with CFR 0.152.
 */
package io.continual.util.data;

import io.continual.util.data.TypeConvertor;
import java.security.NoSuchAlgorithmException;
import java.security.spec.InvalidKeySpecException;
import javax.crypto.SecretKeyFactory;
import javax.crypto.spec.PBEKeySpec;

public class OneWayHasher {
    public static String digest(String input) {
        return OneWayHasher.pbkdf2HashToString(input, "(non-empty salt)");
    }

    public static String hash(String input, String salt) {
        return OneWayHasher.pbkdf2HashToString(input, salt);
    }

    public static String pbkdf2HashToString(String input, String salt) {
        byte[] bytes = OneWayHasher.pbkdf2Hash(input, salt);
        return TypeConvertor.bytesToHexString(bytes);
    }

    public static byte[] pbkdf2Hash(String input, String salt) {
        try {
            String algorithm = "PBKDF2WithHmacSHA1";
            int derivedKeyLength = 160;
            int iterations = 20000;
            PBEKeySpec spec = new PBEKeySpec(input.toCharArray(), salt.getBytes(), 20000, 160);
            SecretKeyFactory f = SecretKeyFactory.getInstance("PBKDF2WithHmacSHA1");
            return f.generateSecret(spec).getEncoded();
        }
        catch (NoSuchAlgorithmException e) {
            throw new RuntimeException(e);
        }
        catch (InvalidKeySpecException e) {
            throw new RuntimeException(e);
        }
    }

    public static void main(String[] args) {
        if (args.length != 1 && args.length != 2) {
            System.err.println("usage: OneWayHasher <input> [<extraSalt>]");
        } else if (args.length == 1) {
            System.out.println(OneWayHasher.pbkdf2HashToString(args[0], ""));
        } else if (args.length == 2) {
            System.out.println(OneWayHasher.pbkdf2HashToString(args[0], args[1]));
        }
    }
}

