/*
 * Decompiled with CFR 0.152.
 */
package io.continual.shaded.com.rabbitmq.client;

import io.continual.shaded.com.rabbitmq.client.SaslConfig;
import io.continual.shaded.com.rabbitmq.client.SaslMechanism;
import io.continual.shaded.com.rabbitmq.client.impl.ExternalMechanism;
import io.continual.shaded.com.rabbitmq.client.impl.PlainMechanism;
import java.util.Arrays;
import java.util.HashSet;

public class DefaultSaslConfig
implements SaslConfig {
    private final String mechanism;
    public static final DefaultSaslConfig PLAIN = new DefaultSaslConfig("PLAIN");
    public static final DefaultSaslConfig EXTERNAL = new DefaultSaslConfig("EXTERNAL");

    private DefaultSaslConfig(String mechanism) {
        this.mechanism = mechanism;
    }

    @Override
    public SaslMechanism getSaslMechanism(String[] serverMechanisms) {
        HashSet<String> server = new HashSet<String>(Arrays.asList(serverMechanisms));
        if (server.contains(this.mechanism)) {
            if (this.mechanism.equals("PLAIN")) {
                return new PlainMechanism();
            }
            if (this.mechanism.equals("EXTERNAL")) {
                return new ExternalMechanism();
            }
        }
        return null;
    }
}

