/*
 * Decompiled with CFR 0.152.
 */
package io.continual.http.service.framework.routing;

import io.continual.http.service.framework.CHttpConnection;
import io.continual.http.service.framework.CHttpErrorHandler;
import io.continual.http.service.framework.context.CHttpRequest;
import io.continual.http.service.framework.context.CHttpRequestContext;
import io.continual.http.service.framework.routing.CHttpRouteInvocation;
import io.continual.http.service.framework.routing.CHttpRouteSource;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CHttpRequestRouter {
    private final LinkedList<CHttpRouteSource> fSources = new LinkedList();
    private final HashMap<Class<?>, CHttpErrorHandler> fErrorHandlers = new HashMap();
    private static final Logger log = LoggerFactory.getLogger(CHttpRequestRouter.class);

    public synchronized void addRouteSource(CHttpRouteSource src) {
        this.addRouteSource(src, false);
    }

    public synchronized void addRouteSource(CHttpRouteSource src, boolean withPriority) {
        if (withPriority) {
            this.fSources.addFirst(src);
        } else {
            this.fSources.addLast(src);
        }
    }

    public synchronized void setGeneralErrorRedirectUrl(final String url) {
        this.fErrorHandlers.put(Throwable.class, new CHttpErrorHandler(){

            @Override
            public void handle(CHttpRequestContext ctx, Throwable cause) {
                log.info("General error handler invoked, redirect to " + url);
                ctx.response().redirect(url);
            }
        });
    }

    public synchronized void setHandlerForException(Class<? extends Throwable> x, CHttpErrorHandler eh) {
        this.fErrorHandlers.put(x, eh);
    }

    public synchronized CHttpRouteInvocation route(CHttpRequest req, CHttpConnection forSession) throws noMatchingRoute {
        CHttpRouteSource src;
        String verbIn = req.getMethod();
        String verb = verbIn.equalsIgnoreCase("HEAD") ? "GET" : verbIn;
        String path = req.getPathInContext();
        CHttpRouteInvocation route = null;
        Iterator iterator = this.fSources.iterator();
        while (iterator.hasNext() && (route = (src = (CHttpRouteSource)iterator.next()).getRouteFor(verb, path, forSession)) == null) {
        }
        if (route == null) {
            log.info("No match for " + verb + " " + path);
            throw new noMatchingRoute(path);
        }
        return route;
    }

    public synchronized CHttpErrorHandler route(Throwable cause) {
        CHttpErrorHandler h = null;
        Class<?> c = cause.getClass();
        while (h == null && c != null) {
            h = this.fErrorHandlers.get(c);
            if (h != null) continue;
            c = c.getSuperclass();
        }
        return h;
    }

    public synchronized String reverseRoute(Class<?> c, String staticMethodName) {
        return this.reverseRoute(c, staticMethodName, null);
    }

    public synchronized String reverseRoute(Class<?> c, String staticMethodName, CHttpConnection forSession) {
        return this.reverseRoute(c, staticMethodName, new HashMap<String, Object>(), forSession);
    }

    public synchronized String reverseRoute(Class<?> c, String staticMethodName, Map<String, Object> args, CHttpConnection forSession) {
        CHttpRouteSource src;
        String route = null;
        Iterator iterator = this.fSources.iterator();
        while (iterator.hasNext() && (route = (src = (CHttpRouteSource)iterator.next()).getRouteTo(c, staticMethodName, args, forSession)) == null) {
        }
        return route;
    }

    public static class noMatchingRoute
    extends Exception {
        private static final long serialVersionUID = 1L;

        public noMatchingRoute(String route) {
            super("No route for '" + route + "'");
        }
    }
}

