/*
 * Decompiled with CFR 0.152.
 */
package io.continual.util.nv.impl;

import io.continual.util.nv.NvReadable;
import io.continual.util.nv.impl.nvBaseReadable;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import java.util.TreeSet;
import java.util.logging.Logger;

public class nvPropertiesFile
extends nvBaseReadable
implements NvReadable {
    private final StreamFetcher fFetcher;
    private final Properties fPrefs;
    private static final Logger log = Logger.getLogger(nvPropertiesFile.class.getName());

    public nvPropertiesFile(final File f) throws NvReadable.LoadException {
        this(new StreamFetcher(){

            public String toString() {
                return f.toString();
            }

            @Override
            public InputStream getStream() throws NvReadable.LoadException {
                try {
                    return new FileInputStream(f);
                }
                catch (FileNotFoundException e) {
                    throw new NvReadable.LoadException(e);
                }
            }
        });
    }

    public nvPropertiesFile(final InputStream is) throws NvReadable.LoadException {
        this(new StreamFetcher(){

            public String toString() {
                return "input stream";
            }

            @Override
            public InputStream getStream() throws NvReadable.LoadException {
                return is;
            }
        });
    }

    public nvPropertiesFile(final URL u) throws NvReadable.LoadException {
        this(new StreamFetcher(){

            public String toString() {
                return u.toString();
            }

            @Override
            public InputStream getStream() throws NvReadable.LoadException {
                try {
                    return u.openStream();
                }
                catch (IOException e) {
                    throw new NvReadable.LoadException(e);
                }
            }
        });
    }

    public nvPropertiesFile(StreamFetcher sf) throws NvReadable.LoadException {
        this.fFetcher = sf;
        this.fPrefs = new Properties();
        this.rescan();
    }

    @Override
    public String getString(String key) throws NvReadable.MissingReqdSettingException {
        String result = this.fPrefs.getProperty(key);
        if (result == null) {
            throw new NvReadable.MissingReqdSettingException(key);
        }
        return result;
    }

    @Override
    public String[] getStrings(String key) throws NvReadable.MissingReqdSettingException {
        String fullset = this.getString(key);
        return fullset.split(",", -1);
    }

    @Override
    public boolean hasValueFor(String key) {
        return this.fPrefs.containsKey(key);
    }

    @Override
    public void rescan() throws NvReadable.LoadException {
        log.info("Rescanning settings " + this.fFetcher.toString());
        this.fPrefs.clear();
        this.read(this.fFetcher.getStream());
    }

    @Override
    public int size() {
        return this.fPrefs.size();
    }

    @Override
    public Collection<String> getAllKeys() {
        TreeSet<String> list = new TreeSet<String>();
        for (Object o : this.fPrefs.keySet()) {
            list.add(o.toString());
        }
        return list;
    }

    @Override
    public Map<String, String> getCopyAsMap() {
        HashMap<String, String> map = new HashMap<String, String>();
        for (Map.Entry<Object, Object> e : this.fPrefs.entrySet()) {
            map.put(e.getKey().toString(), e.getValue().toString());
        }
        return map;
    }

    private void read(InputStream is) throws NvReadable.LoadException {
        if (is == null) {
            throw new NvReadable.LoadException("No stream provided to nvPropertiesFile.read()");
        }
        try {
            this.fPrefs.load(is);
        }
        catch (IOException e) {
            throw new NvReadable.LoadException(e);
        }
    }

    public static interface StreamFetcher {
        public InputStream getStream() throws NvReadable.LoadException;
    }
}

