/*
 * Decompiled with CFR 0.152.
 */
package io.continual.restHttp;

import io.continual.http.service.framework.context.CHttpRequestContext;
import io.continual.http.service.framework.context.CHttpResponse;
import io.continual.iam.IamAuthLog;
import io.continual.iam.IamServiceManager;
import io.continual.iam.access.AccessDb;
import io.continual.iam.access.Resource;
import io.continual.iam.credentials.ApiKeyCredential;
import io.continual.iam.credentials.JwtCredential;
import io.continual.iam.credentials.UsernamePasswordCredential;
import io.continual.iam.exceptions.IamSvcException;
import io.continual.iam.identity.Identity;
import io.continual.iam.identity.UserContext;
import io.continual.iam.impl.common.ApiKeyAuthHelper;
import io.continual.iam.impl.common.BasicAuthHelper;
import io.continual.iam.impl.common.HeaderReader;
import io.continual.restHttp.HttpServlet;
import io.continual.util.data.TypeConvertor;
import io.continual.util.data.json.CommentedJsonTokener;
import io.continual.util.data.json.JsonUtil;
import io.continual.util.nv.NvReadable;
import java.io.IOException;
import java.util.LinkedList;
import org.json.JSONException;
import org.json.JSONObject;
import org.json.JSONTokener;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ApiContextHelper<I extends Identity> {
    public static final String kSetting_ContinualProductTag = "apiKeyProductTag";
    public static final String kContinualProductTag = "continual";
    public static final String kContinualSystemsGroup = "continualSystems";
    public static final String kSetting_AuthLineHeader = "http.auth.header";
    public static final String kSetting_DateLineHeader = "http.date.header";
    public static final String kSetting_MagicLineHeader = "http.magic.header";
    public static final String kDefault_AuthLineHeader = "X-Continual-Auth";
    public static final String kDefault_DateLineHeader = "X-Continual-Date";
    public static final String kDefault_MagicLineHeader = "X-Continual-Magic";
    private final IamServiceManager<I, ?> fAccts;
    private static final Logger log = LoggerFactory.getLogger(ApiContextHelper.class);

    public ApiContextHelper() {
        this(null);
    }

    public ApiContextHelper(IamServiceManager<I, ?> accts) {
        this.fAccts = accts;
    }

    protected static void sendStatusCodeAndMessage(CHttpRequestContext context, int statusCode, String msg) {
        ApiContextHelper.sendJson(context, statusCode, new JSONObject().put("statusCode", statusCode).put("message", (Object)msg));
    }

    protected static void sendStatusOk(CHttpRequestContext context, String msg) {
        ApiContextHelper.sendJson(context, 200, new JSONObject().put("statusCode", 200).put("message", (Object)msg));
    }

    protected static void sendStatusOk(CHttpRequestContext context, JSONObject msg) {
        ApiContextHelper.sendJson(context, 200, JsonUtil.clone((JSONObject)msg).put("statusCode", 200));
    }

    protected static void sendStatusOkNoContent(CHttpRequestContext context) {
        context.response().setStatus(204);
    }

    protected static void sendNotAuth(CHttpRequestContext context) {
        ApiContextHelper.sendStatusCodeAndMessage(context, 401, "Unauthorized. Check your API credentials.");
    }

    protected static void sendJson(CHttpRequestContext context, JSONObject data) {
        ApiContextHelper.sendJson(context, 200, data);
    }

    protected static void sendJson(CHttpRequestContext context, int statusCode, JSONObject data) {
        boolean pretty = TypeConvertor.convertToBooleanBroad((String)context.request().getFirstHeader("X-CioPrettyJson"));
        context.response().sendErrorAndBody(statusCode, pretty ? data.toString(4) : data.toString(), "application/json");
    }

    public void handleWithApiAuth(CHttpRequestContext context, ApiHandler<I> h) {
        ApiContextHelper.handleWithApiAuth(context, this.getInternalAccts(context), h);
    }

    public void handleWithApiAuthAndAccess(CHttpRequestContext context, ApiHandler<I> am, ResourceAccess ... accessReqd) {
        ApiContextHelper.handleWithApiAuthAndAccess(context, this.getInternalAccts(context), am, new ResourceAccess[0]);
    }

    public static <I extends Identity> void handleWithApiAuth(CHttpRequestContext context, IamServiceManager<I, ?> am, ApiHandler<I> h) {
        ApiContextHelper.handleWithApiAuthAndAccess(context, am, h, new ResourceAccess[0]);
    }

    public static <I extends Identity> void handleWithApiAuthAndAccess(CHttpRequestContext context, IamServiceManager<I, ?> am, ApiHandler<I> h, ResourceAccess ... accessReqd) {
        try {
            ApiContextHelper.setupCorsHeaders(context);
            UserContext<I> user = ApiContextHelper.getUser(am, context);
            if (user == null) {
                ApiContextHelper.sendNotAuth(context);
                return;
            }
            String uid = user.getEffectiveUserId();
            AccessDb adb = am.getAccessDb();
            for (ResourceAccess ra : accessReqd) {
                if (adb.canUser(uid, ApiContextHelper.makeResource(ra.fResId), ra.fOp)) continue;
                ApiContextHelper.sendNotAuth(context);
                return;
            }
            h.handle(context, (HttpServlet)context.getServlet(), user);
        }
        catch (IOException e) {
            log.warn(e.getMessage());
            ApiContextHelper.sendStatusCodeAndMessage(context, 500, "I/O problem writing the response, but... you got it???");
        }
        catch (IamSvcException | JSONException e) {
            log.warn(e.getMessage(), e);
            ApiContextHelper.sendStatusCodeAndMessage(context, 500, "There was a problem handling your API request.");
        }
    }

    public static <I extends Identity> UserContext<I> getUser(CHttpRequestContext context) throws IamSvcException {
        return ApiContextHelper.getUser(ApiContextHelper.getAccountsSvc(context), context);
    }

    public boolean canUser(CHttpRequestContext context, UserContext<Identity> user, String resId, String operation) throws IamSvcException {
        boolean result = this.fAccts.getAccessDb().canUser(user.getEffectiveUserId(), ApiContextHelper.makeResource(resId), operation);
        if (!result) {
            log.info(user.toString() + " cannot " + operation + " object " + resId);
        }
        return result;
    }

    public static Resource makeResource(final String named) {
        return new Resource(){

            public String getId() {
                return named;
            }
        };
    }

    public static <I extends Identity> UserContext<I> getUser(IamServiceManager<I, ?> am, CHttpRequestContext context) throws IamSvcException {
        UserContext result = null;
        Identity authUser = null;
        try {
            authUser = (Identity)new AuthList<I>().authenticate(am, context);
            if (authUser != null) {
                String authFor = new LocalHeaderReader(context).getFirstHeader("X-AuthFor");
                if (authFor != null && authFor.length() > 0 && !authFor.equals(authUser.getId())) {
                    Identity authForUser = am.getIdentityManager().loadUser(authFor);
                    if (authForUser != null && authUser.getGroup(kContinualSystemsGroup) != null) {
                        result = new UserContext.Builder().forUser(authForUser).sponsoredByUser(authUser).build();
                    }
                } else {
                    result = new UserContext.Builder().forUser(authUser).build();
                }
            }
            return result;
        }
        catch (IamSvcException x) {
            log.warn("Error processing authentication: " + x.getMessage());
            throw x;
        }
    }

    protected IamServiceManager<I, ?> getInternalAccts(CHttpRequestContext context) {
        if (this.fAccts != null) {
            return this.fAccts;
        }
        return ApiContextHelper.getAccountsSvc(context);
    }

    protected static <I extends Identity> IamServiceManager<I, ?> getAccountsSvc(CHttpRequestContext context) {
        return (IamServiceManager)HttpServlet.getServices(context).get("accounts", IamServiceManager.class);
    }

    protected static void setupCorsHeaders(CHttpRequestContext context) {
        CHttpResponse reply = context.response();
        reply.writeHeader("Access-Control-Allow-Origin", "*");
        reply.writeHeader("Access-Control-Allow-Methods", "DELETE, GET, OPTIONS, PATCH, POST, PUT");
        reply.writeHeader("Access-Control-Max-Age", "3600");
        reply.writeHeader("Access-Control-Allow-Headers", "Content-Type, Authorization, X-Continual-Auth, X-Continual-Date, X-Continual-Magic");
    }

    protected static JSONObject readBody(CHttpRequestContext context) throws JSONException, IOException {
        return new JSONObject((JSONTokener)new CommentedJsonTokener(context.request().getBodyStream()));
    }

    public static JSONObject readJsonBody(CHttpRequestContext ctx) throws JSONException, IOException {
        return ApiContextHelper.readBody(ctx);
    }

    public static String readJsonString(JSONObject from, String label) throws MissingInputException {
        try {
            return from.getString(label);
        }
        catch (JSONException x) {
            throw new MissingInputException("Missing required field '" + label + "' in input.");
        }
    }

    public static JSONObject readJsonObject(JSONObject from, String label) throws MissingInputException {
        try {
            return from.getJSONObject(label);
        }
        catch (JSONException x) {
            throw new MissingInputException("Missing required field '" + label + "' in input.");
        }
    }

    public static class MissingInputException
    extends Exception {
        private static final long serialVersionUID = 1L;

        public MissingInputException(String msg) {
            super(msg);
        }
    }

    private static class AuthList<I extends Identity>
    implements Authenticator<I> {
        private final LinkedList<Authenticator<I>> fAuthenticators = new LinkedList();

        public AuthList() {
            this.fAuthenticators.add(new Authenticator<I>(){

                @Override
                public I authenticate(IamServiceManager<I, ?> am, CHttpRequestContext context) throws IamSvcException {
                    NvReadable ds = context.systemSettings();
                    String systag = ds.getString(ApiContextHelper.kSetting_ContinualProductTag, ApiContextHelper.kContinualProductTag);
                    Identity authUser = null;
                    ApiKeyCredential creds = ApiKeyAuthHelper.readApiKeyCredential((NvReadable)ds, (HeaderReader)new LocalHeaderReader(context), (String)systag);
                    if (creds != null && (authUser = am.getIdentityDb().authenticate(creds)) != null) {
                        IamAuthLog.authenticationEvent((String)authUser.getId(), (String)"API Key", (String)context.request().getBestRemoteAddress());
                    }
                    return authUser;
                }
            });
            this.fAuthenticators.add(new Authenticator<I>(){

                @Override
                public I authenticate(IamServiceManager<I, ?> am, CHttpRequestContext context) throws IamSvcException {
                    Identity authUser = null;
                    try {
                        String queryParam;
                        String[] parts;
                        JwtCredential cred = null;
                        String authHeader = context.request().getFirstHeader("Authorization");
                        if (authHeader != null && authHeader.startsWith("Bearer ") && (parts = authHeader.split(" ")).length == 2) {
                            cred = JwtCredential.fromHeader((String)authHeader);
                        }
                        if (cred == null && (queryParam = context.request().getParameter("jwt", null)) != null) {
                            cred = new JwtCredential(queryParam);
                        }
                        if (cred != null && (authUser = am.getIdentityDb().authenticate(cred)) != null) {
                            IamAuthLog.authenticationEvent((String)authUser.getId(), (String)"JWT", (String)context.request().getBestRemoteAddress());
                        }
                    }
                    catch (JwtCredential.InvalidJwtToken invalidJwtToken) {
                        // empty catch block
                    }
                    return authUser;
                }
            });
            this.fAuthenticators.add(new Authenticator<I>(){

                @Override
                public I authenticate(IamServiceManager<I, ?> am, CHttpRequestContext context) throws IamSvcException {
                    NvReadable ds = context.systemSettings();
                    Identity authUser = null;
                    UsernamePasswordCredential upc = BasicAuthHelper.readUsernamePasswordCredential((NvReadable)ds, (HeaderReader)new LocalHeaderReader(context));
                    if (upc != null && (authUser = am.getIdentityDb().authenticate(upc)) != null) {
                        IamAuthLog.authenticationEvent((String)authUser.getId(), (String)"Username/Password", (String)context.request().getBestRemoteAddress());
                    }
                    return authUser;
                }
            });
        }

        @Override
        public I authenticate(IamServiceManager<I, ?> am, CHttpRequestContext context) throws IamSvcException {
            for (Authenticator authenticator : this.fAuthenticators) {
                I result = authenticator.authenticate(am, context);
                if (result == null) continue;
                return result;
            }
            return null;
        }
    }

    private static class LocalHeaderReader
    implements HeaderReader {
        private final CHttpRequestContext fContext;

        public LocalHeaderReader(CHttpRequestContext context) {
            this.fContext = context;
        }

        public String getFirstHeader(String header) {
            return this.fContext.request().getFirstHeader(header);
        }
    }

    private static interface Authenticator<I extends Identity> {
        public I authenticate(IamServiceManager<I, ?> var1, CHttpRequestContext var2) throws IamSvcException;
    }

    public static class ResourceAccess {
        public final String fResId;
        public final String fOp;

        public ResourceAccess(String resourceId, String operation) {
            this.fResId = resourceId;
            this.fOp = operation;
        }
    }

    public static interface ApiHandler<I extends Identity> {
        public void handle(CHttpRequestContext var1, HttpServlet var2, UserContext<I> var3) throws IOException;
    }
}

