/*
 * Decompiled with CFR 0.152.
 */
package io.continual.restHttp;

import io.continual.http.service.framework.context.CHttpRequestContext;
import io.continual.iam.IamServiceManager;
import io.continual.iam.exceptions.IamSvcException;
import io.continual.iam.identity.Identity;
import io.continual.iam.identity.UserContext;
import io.continual.restHttp.ApiContextHelper;
import io.continual.restHttp.HttpServlet;
import io.continual.restHttp.HttpUserSession;
import java.io.IOException;
import org.json.JSONObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HttpSessionContextHelper {
    private static final Logger log = LoggerFactory.getLogger(HttpSessionContextHelper.class);

    public static void handleWithUserSession(CHttpRequestContext context, SessionHandler h) throws NoLoginException, IamSvcException {
        try {
            HttpServlet servlet = (HttpServlet)context.getServlet();
            UserContext<?> user = HttpSessionContextHelper.getUser(context);
            if (user == null) {
                throw new NoLoginException();
            }
            h.handle(context, servlet, user.getUser());
        }
        catch (IOException e) {
            log.warn(e.getMessage());
            context.response().sendError(500, "I/O problem writing the response, but... you got it???");
        }
    }

    public static UserContext<?> getUserNoThrow(CHttpRequestContext context) {
        return HttpUserSession.getSession(context).getUser();
    }

    public static UserContext<?> getUser(CHttpRequestContext context) throws NoLoginException, IamSvcException {
        UserContext<?> ii;
        if (context.session() != null && (ii = HttpUserSession.getSession(context).getUser()) != null) {
            return ii;
        }
        ii = ApiContextHelper.getUser(HttpSessionContextHelper.getAccountsSvc(context), context);
        if (ii == null) {
            throw new NoLoginException();
        }
        return ii;
    }

    protected static void sendJson(CHttpRequestContext context, JSONObject data) {
        HttpSessionContextHelper.sendJson(context, 200, data);
    }

    protected static void sendJson(CHttpRequestContext context, int statusCode, JSONObject data) {
        context.response().sendErrorAndBody(statusCode, data.toString(), "application/json");
    }

    protected static IamServiceManager<?, ?> getAccountsSvc(CHttpRequestContext context) {
        return (IamServiceManager)HttpServlet.getServices(context).get("accounts", IamServiceManager.class);
    }

    public static interface SessionHandler {
        public void handle(CHttpRequestContext var1, HttpServlet var2, Identity var3) throws IOException;
    }

    public static class NoLoginException
    extends Exception {
        private static final long serialVersionUID = 1L;
    }
}

