/*
 * Decompiled with CFR 0.152.
 */
package io.continual.iam.apiserver;

import io.continual.builder.Builder;
import io.continual.http.service.framework.CHttpConnection;
import io.continual.http.service.framework.CHttpErrorHandler;
import io.continual.http.service.framework.context.CHttpRequestContext;
import io.continual.http.service.framework.context.CHttpResponse;
import io.continual.http.service.framework.routing.CHttpRequestRouter;
import io.continual.http.service.framework.routing.CHttpRouteInvocation;
import io.continual.http.service.framework.routing.CHttpRouteSource;
import io.continual.http.service.framework.routing.playish.CHttpPlayishInstanceCallRoutingSource;
import io.continual.http.service.framework.routing.playish.CHttpPlayishStaticEntryPointRoutingSource;
import io.continual.iam.IamServiceManager;
import io.continual.iam.apiserver.endpoints.AuthApiHandler;
import io.continual.iam.apiserver.endpoints.IamApiHandler;
import io.continual.iam.exceptions.IamSvcException;
import io.continual.restHttp.BaseApiServiceRouter;
import io.continual.restHttp.HttpRouter;
import io.continual.restHttp.HttpService;
import io.continual.restHttp.HttpServlet;
import io.continual.services.ServiceContainer;
import io.continual.services.SimpleService;
import io.continual.util.naming.Name;
import io.continual.util.naming.Path;
import io.continual.util.nv.NvReadable;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.net.URL;
import java.util.Map;
import org.json.JSONObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class IamHttpApiService
extends SimpleService {
    private static final Logger log = LoggerFactory.getLogger(IamHttpApiService.class);
    private static final String skAllowHeadersValue = "Content-Type, Authorization";

    public IamHttpApiService(ServiceContainer sc, final JSONObject config) throws Builder.BuildFailure {
        HttpService http = (HttpService)sc.get(config.getString("httpService"), HttpService.class);
        if (http == null) {
            throw new Builder.BuildFailure("An HTTP service (\"httpService\") is required in the API service configuration.");
        }
        final IamServiceManager accts = (IamServiceManager)sc.get(config.getString("accounts"), IamServiceManager.class);
        if (accts == null) {
            throw new Builder.BuildFailure("An HTTP service (\"accounts\") is required in the configuration.");
        }
        http.addRouter("httpApi", (HttpRouter)new BaseApiServiceRouter(){

            public void setupRouter(HttpServlet servlet, CHttpRequestRouter rr, NvReadable p) throws IOException {
                super.setupExceptionHandlers(servlet, rr, p);
                rr.addRouteSource((CHttpRouteSource)new CorsOptionsRouter());
                CHttpPlayishStaticEntryPointRoutingSource guideSrc = new CHttpPlayishStaticEntryPointRoutingSource();
                guideSrc.addRoute("GET", "/guide", "staticDir:com/rathravane/labels/guide;index.html");
                rr.addRouteSource((CHttpRouteSource)guideSrc);
                IamHttpApiService.this.addRoutes(rr, "authRoutes.conf", (Object)new AuthApiHandler());
                IamHttpApiService.this.addRoutes(rr, "iamRoutes.conf", (Object)new IamApiHandler(accts, config.getString("accessRequired")));
                rr.setHandlerForException(IamSvcException.class, new CHttpErrorHandler(){

                    public void handle(CHttpRequestContext ctx, Throwable cause) {
                        ctx.response().sendErrorAndBody(503, new JSONObject().put("error", 503).put("message", (Object)cause.getMessage()).toString(), "application/json");
                    }
                });
            }
        });
    }

    private void addRoutes(CHttpRequestRouter rr, String routeFile, Object handler) throws IOException {
        log.debug("Loading routes from " + routeFile);
        URL url = ((Object)((Object)this)).getClass().getResource(routeFile);
        rr.addRouteSource((CHttpRouteSource)new CHttpPlayishInstanceCallRoutingSource(handler, url));
    }

    private static class CorsOptionsRouter
    implements CHttpRouteSource {
        private CorsOptionsRouter() {
        }

        public CHttpRouteInvocation getRouteFor(String verb, String path, CHttpConnection forSession) {
            if (verb != null && verb.equalsIgnoreCase("OPTIONS")) {
                return new CHttpRouteInvocation(){

                    public void run(CHttpRequestContext context) throws IOException, IllegalArgumentException, IllegalAccessException, InvocationTargetException {
                        CHttpResponse reply = context.response();
                        reply.writeHeader("Access-Control-Allow-Origin", "*");
                        reply.writeHeader("Access-Control-Allow-Methods", "DELETE, GET, OPTIONS, PATCH, POST, PUT");
                        reply.writeHeader("Access-Control-Max-Age", "3600");
                        reply.writeHeader("Access-Control-Allow-Headers", IamHttpApiService.skAllowHeadersValue);
                        reply.setStatus(204);
                    }

                    public Path getRouteNameForMetrics() {
                        return Path.getRootPath().makeChildItem(Name.fromString((String)"options"));
                    }
                };
            }
            return null;
        }

        public String getRouteTo(Class<?> c, String staticMethodName, Map<String, Object> args, CHttpConnection forSession) {
            return null;
        }
    }
}

