/*
 * Decompiled with CFR 0.152.
 */
package io.continual.iam.apiserver.endpoints;

import io.continual.http.service.framework.context.CHttpRequestContext;
import io.continual.iam.IamServiceManager;
import io.continual.iam.credentials.UsernamePasswordCredential;
import io.continual.iam.exceptions.IamSvcException;
import io.continual.iam.identity.Identity;
import io.continual.iam.identity.UserContext;
import io.continual.restHttp.ApiContextHelper;
import io.continual.restHttp.HttpServlet;
import java.io.IOException;
import org.json.JSONException;
import org.json.JSONObject;

public class AuthApiHandler
extends ApiContextHelper<Identity> {
    public void login(CHttpRequestContext context) throws IamSvcException, IOException {
        try {
            AuthApiHandler.setupCorsHeaders((CHttpRequestContext)context);
            JSONObject body = AuthApiHandler.readBody((CHttpRequestContext)context);
            String username = AuthApiHandler.readJsonString((JSONObject)body, (String)"username");
            String password = AuthApiHandler.readJsonString((JSONObject)body, (String)"password");
            IamServiceManager am = (IamServiceManager)HttpServlet.getServices((CHttpRequestContext)context).get("accounts", IamServiceManager.class);
            Identity ii = am.getIdentityDb().authenticate(new UsernamePasswordCredential(username, password));
            if (ii != null) {
                String token = am.getIdentityDb().createJwtToken(ii);
                AuthApiHandler.sendJson((CHttpRequestContext)context, (JSONObject)new JSONObject().put("status", (Object)"ok").put("token", (Object)token));
            } else {
                AuthApiHandler.sendStatusCodeAndMessage((CHttpRequestContext)context, (int)401, (String)"Unable to sign in.");
            }
        }
        catch (ApiContextHelper.MissingInputException x) {
            AuthApiHandler.sendStatusCodeAndMessage((CHttpRequestContext)context, (int)400, (String)x.getMessage());
        }
        catch (JSONException x) {
            AuthApiHandler.sendStatusCodeAndMessage((CHttpRequestContext)context, (int)400, (String)"There's a problem with your JSON.");
        }
    }

    public void logout(CHttpRequestContext context) throws IamSvcException, IOException {
        AuthApiHandler.setupCorsHeaders((CHttpRequestContext)context);
        UserContext user = AuthApiHandler.getUser((CHttpRequestContext)context);
        if (user != null) {
            String[] parts;
            IamServiceManager am = (IamServiceManager)HttpServlet.getServices((CHttpRequestContext)context).get("accounts", IamServiceManager.class);
            String authHeader = context.request().getFirstHeader("Authorization");
            if (authHeader != null && authHeader.startsWith("Bearer ") && (parts = authHeader.split(" ")).length == 2) {
                am.getIdentityDb().invalidateJwtToken(parts[1]);
            }
        }
    }

    public void changePassword(CHttpRequestContext context) throws IamSvcException, IOException {
        AuthApiHandler.setupCorsHeaders((CHttpRequestContext)context);
        UserContext user = AuthApiHandler.getUser((CHttpRequestContext)context);
        if (user == null) {
            AuthApiHandler.sendNotAuth((CHttpRequestContext)context);
            return;
        }
        JSONObject body = AuthApiHandler.readBody((CHttpRequestContext)context);
        String username = user.getEffectiveUserId();
        String password = body.getString("currentPassword");
        String newPassword = body.getString("newPassword");
        IamServiceManager am = (IamServiceManager)HttpServlet.getServices((CHttpRequestContext)context).get("accounts", IamServiceManager.class);
        Identity ii = am.getIdentityDb().authenticate(new UsernamePasswordCredential(username, password));
        if (ii == null) {
            AuthApiHandler.sendNotAuth((CHttpRequestContext)context);
            return;
        }
        ii.setPassword(newPassword);
        AuthApiHandler.sendStatusOk((CHttpRequestContext)context, (String)"ok");
    }
}

