/*
 * Decompiled with CFR 0.152.
 */
package io.continual.iam.impl.file;

import io.continual.iam.exceptions.IamBadRequestException;
import io.continual.iam.exceptions.IamIdentityDoesNotExist;
import io.continual.iam.exceptions.IamSvcException;
import io.continual.iam.identity.ApiKey;
import io.continual.iam.impl.common.CommonJsonApiKey;
import io.continual.iam.impl.common.CommonJsonDb;
import io.continual.iam.impl.common.CommonJsonGroup;
import io.continual.iam.impl.common.CommonJsonIdentity;
import io.continual.iam.impl.common.jwt.JwtProducer;
import io.continual.util.data.json.JsonUtil;
import io.continual.util.data.json.JsonVisitor;
import io.continual.util.db.file.JsonObjectFile;
import io.continual.util.time.Clock;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.TreeSet;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class IamFileDb
extends CommonJsonDb<CommonJsonIdentity, CommonJsonGroup> {
    private final JSONObject fMainIndex;
    private final JsonObjectFile fDb;
    private static final long kEntryNotFound = -1L;
    private static final Logger log = LoggerFactory.getLogger(IamFileDb.class);

    protected IamFileDb(Builder b) throws IamSvcException {
        super(b.aclFactory, b.jwtProducer);
        try {
            JSONObject index;
            long mainIndex;
            boolean init;
            boolean bl = init = !b.file.exists() && b.file.getParentFile().isDirectory() || b.forceInit;
            if (init) {
                JsonObjectFile.initialize((File)b.file, (int)1024);
            }
            this.fDb = new JsonObjectFile(b.file, !b.readonly, b.password);
            if (init && (mainIndex = this.fDb.write(index = new JSONObject().put("users", (Object)new JSONObject()).put("groups", (Object)new JSONObject()))) != this.fDb.indexToAddress(0L)) {
                throw new IamSvcException("Couldn't initialize JSON DB file propertly.");
            }
            this.fMainIndex = this.fDb.read(this.fDb.indexToAddress(0L));
        }
        catch (IOException x) {
            throw new IamSvcException((Throwable)x);
        }
    }

    public void close() {
        try {
            this.fDb.close();
        }
        catch (IOException e) {
            log.warn("Couldn't close file db: {}", (Object)e.getMessage());
        }
    }

    public Map<String, CommonJsonIdentity> loadAllUsers() throws IamSvcException {
        HashMap<String, CommonJsonIdentity> result = new HashMap<String, CommonJsonIdentity>();
        for (String userId : this.getAllUsers()) {
            result.put(userId, this.loadUser(userId));
        }
        return result;
    }

    public Collection<String> getAllUsers() throws IamSvcException {
        TreeSet<String> result = new TreeSet<String>();
        JSONObject userIndex = this.fMainIndex.optJSONObject("users");
        if (userIndex != null) {
            result.addAll(userIndex.keySet());
        }
        return result;
    }

    public Collection<String> getAllGroups() throws IamSvcException {
        TreeSet<String> result = new TreeSet<String>();
        JSONObject groupIndex = this.fMainIndex.optJSONObject("groups");
        if (groupIndex != null) {
            result.addAll(groupIndex.keySet());
        }
        return result;
    }

    public List<String> findUsers(String startingWith) throws IamSvcException {
        ArrayList<String> result = new ArrayList<String>();
        JSONObject userIndex = this.fMainIndex.optJSONObject("users");
        if (userIndex != null) {
            for (String userId : userIndex.keySet()) {
                if (!userId.startsWith(startingWith)) continue;
                result.add(userId);
            }
        }
        return result;
    }

    public void sweepExpiredTags() throws IamSvcException {
        TreeSet result = new TreeSet();
        JSONObject tagIndex = this.fMainIndex.optJSONObject("tags");
        if (tagIndex != null) {
            result.addAll(tagIndex.keySet());
        }
        for (String key : result) {
            this.loadTagObject(key, false);
        }
    }

    private JSONObject loadObject(long addr) throws IamSvcException {
        try {
            return this.fDb.read(addr);
        }
        catch (IOException | JSONException e) {
            throw new IamSvcException(e);
        }
    }

    private JSONObject loadObject(String ... ids) throws IamSvcException {
        long addr = this.readIndex(ids);
        if (addr < 0L) {
            return null;
        }
        return this.loadObject(addr);
    }

    private void storeObject(long addr, JSONObject o) throws IamSvcException {
        try {
            this.fDb.overwrite(addr, o);
        }
        catch (IOException x) {
            throw new IamSvcException((Throwable)x);
        }
    }

    private long storeNewObject(JSONObject o) throws IamSvcException {
        try {
            return this.fDb.write(o);
        }
        catch (IOException x) {
            throw new IamSvcException((Throwable)x);
        }
    }

    private void storeObject(JSONObject data, String ... ids) throws IamSvcException {
        long addr = this.readIndex(ids);
        if (addr < 0L) {
            addr = this.storeNewObject(data);
            this.updateIndex(addr, ids);
        } else {
            this.storeObject(addr, data);
        }
    }

    private void deleteObject(String ... ids) throws IamSvcException {
        long addr = this.readIndex(ids);
        if (addr < 0L) {
            return;
        }
        try {
            this.deleteFromIndex(ids);
            this.fDb.delete(addr);
        }
        catch (IOException e) {
            throw new IamSvcException((Throwable)e);
        }
    }

    private long readIndex(String ... ids) {
        JSONObject current = this.fMainIndex;
        for (int i = 0; i < ids.length - 1; ++i) {
            if ((current = current.optJSONObject(ids[i])) != null) continue;
            return -1L;
        }
        return current.optLong(ids[ids.length - 1], -1L);
    }

    private void writeIndex() throws IamSvcException {
        try {
            this.fDb.overwrite(this.fDb.indexToAddress(0L), this.fMainIndex);
        }
        catch (IOException e) {
            throw new IamSvcException((Throwable)e);
        }
    }

    private void updateIndex(long addr, String ... ids) throws IamSvcException {
        JSONObject parent = null;
        JSONObject current = this.fMainIndex;
        for (int i = 0; i < ids.length - 1; ++i) {
            parent = current;
            if ((current = current.optJSONObject(ids[i])) != null) continue;
            current = new JSONObject();
            parent.put(ids[i], (Object)current);
        }
        current.put(ids[ids.length - 1], addr);
        this.writeIndex();
    }

    private void deleteFromIndex(String ... ids) throws IamSvcException {
        JSONObject current = this.fMainIndex;
        for (int i = 0; i < ids.length - 1; ++i) {
            if ((current = current.optJSONObject(ids[i])) != null) continue;
            return;
        }
        current.remove(ids[ids.length - 1]);
        this.writeIndex();
    }

    protected JSONObject createNewUser(String id) {
        return CommonJsonIdentity.initializeIdentity();
    }

    protected JSONObject loadUserObject(String id) throws IamSvcException {
        return this.loadObject("users", id);
    }

    protected void storeUserObject(String id, JSONObject data) throws IamSvcException {
        this.storeObject(data, "users", id);
    }

    protected void deleteUserObject(String id) throws IamSvcException {
        this.deleteObject("users", id);
    }

    protected CommonJsonIdentity instantiateIdentity(String id, JSONObject data) {
        return new CommonJsonIdentity(id, data, (CommonJsonDb)this);
    }

    protected JSONObject createNewGroup(String id, String groupDesc) {
        return CommonJsonGroup.initializeGroup((String)groupDesc);
    }

    protected JSONObject loadGroupObject(String id) throws IamSvcException {
        return this.loadObject("groups", id);
    }

    protected void storeGroupObject(String id, JSONObject data) throws IamSvcException {
        this.storeObject(data, "groups", id);
    }

    protected void deleteGroupObject(String id) throws IamSvcException {
        this.deleteObject("groups", id);
    }

    protected CommonJsonGroup instantiateGroup(String id, JSONObject data) {
        return new CommonJsonGroup(id, data, (CommonJsonDb)this);
    }

    protected JSONObject createApiKeyObject(String userId, String apiKey, String apiSecret) {
        return CommonJsonApiKey.initialize((String)apiSecret, (String)userId);
    }

    protected JSONObject loadApiKeyObject(String id) throws IamSvcException {
        return this.loadObject("apiKeys", id);
    }

    protected void storeApiKeyObject(String id, JSONObject apiKeyObject) throws IamSvcException, IamBadRequestException {
        TreeSet existing;
        String userId = apiKeyObject.optString("userId", null);
        if (userId == null) {
            throw new IamBadRequestException("no user specified for api key");
        }
        JSONObject user = this.loadUserObject(userId);
        if (user == null) {
            throw new IamIdentityDoesNotExist(userId);
        }
        this.storeObject(apiKeyObject, "apiKeys", id);
        JSONArray userApiKeys = user.optJSONArray("apiKeys");
        if (userApiKeys == null) {
            userApiKeys = new JSONArray();
            user.put("apiKeys", (Object)userApiKeys);
        }
        if (!(existing = new TreeSet(JsonVisitor.arrayToList((JSONArray)userApiKeys))).contains(id)) {
            userApiKeys.put((Object)id);
            this.storeUserObject(userId, user);
        }
    }

    protected void deleteApiKeyObject(String id) throws IamSvcException {
        String userId;
        JSONObject user;
        JSONArray userApiKeys;
        JSONObject apiKey = this.loadApiKeyObject(id);
        if (apiKey != null && (userApiKeys = (user = this.loadUserObject(userId = apiKey.getString("userId"))).optJSONArray("apiKeys")) != null && JsonUtil.removeStringFromArray((JSONArray)userApiKeys, (String)id)) {
            this.storeUserObject(userId, user);
        }
        this.deleteObject("apiKeys", id);
    }

    protected ApiKey instantiateApiKey(String id, JSONObject data) {
        return new CommonJsonApiKey(id, data);
    }

    protected Collection<String> loadApiKeysForUser(String userId) throws IamSvcException, IamIdentityDoesNotExist {
        JSONObject user = this.loadUserObject(userId);
        if (user == null) {
            throw new IamIdentityDoesNotExist(userId);
        }
        JSONArray userApiKeys = user.optJSONArray("apiKeys");
        if (userApiKeys != null) {
            return JsonVisitor.arrayToList((JSONArray)userApiKeys);
        }
        return new LinkedList<String>();
    }

    protected JSONObject loadAclObject(String id) throws IamSvcException {
        return this.loadObject("acls", id);
    }

    protected void storeAclObject(String id, JSONObject data) throws IamSvcException {
        this.storeObject(data, "acls", id);
    }

    protected void deleteAclObject(String id) throws IamSvcException {
        this.deleteObject("acls", id);
    }

    protected JSONObject loadTagObject(String id, boolean expiredOk) throws IamSvcException {
        JSONObject entry = this.loadObject("tags", id);
        if (entry == null) {
            return null;
        }
        long expireEpoch = entry.getLong("expireEpoch");
        if (expireEpoch < Clock.now() / 1000L && !expiredOk) {
            String userId = entry.optString("userId", null);
            String tagType = entry.optString("tagType", entry.optString("type", null));
            if (userId == null || tagType == null) {
                log.warn("Tag " + id + " is damaged.");
            } else {
                this.deleteTagObject(id, userId, tagType);
                log.info("Tag " + id + " (" + userId + "/" + tagType + ") deleted.");
            }
            return null;
        }
        return entry;
    }

    protected JSONObject loadTagObject(String userId, String appTagType, boolean expiredOk) throws IamSvcException {
        JSONObject entry = this.loadObject("tagsByUser", userId, appTagType);
        if (entry == null) {
            return null;
        }
        long expireEpoch = entry.getLong("expireEpoch");
        if (expireEpoch < Clock.now() / 1000L && !expiredOk) {
            this.removeMatchingTag(userId, appTagType);
            return null;
        }
        return entry;
    }

    protected void storeTagObject(String id, String userId, String appTagType, JSONObject data) throws IamSvcException {
        this.storeObject(data, "tags", id);
        this.storeObject(data, "tagsByUser", userId, appTagType);
    }

    protected void deleteTagObject(String id, String userId, String appTagType) throws IamSvcException {
        this.deleteObject("tags", id);
        this.deleteObject("tagsByUser", userId, appTagType);
    }

    protected JSONObject loadAliasObject(String id) throws IamSvcException {
        return this.loadObject("aliases", id);
    }

    protected void storeAliasObject(String id, JSONObject aliasObject) throws IamSvcException, IamBadRequestException {
        TreeSet existing;
        String userId = aliasObject.optString("userId", null);
        if (userId == null) {
            throw new IamBadRequestException("no user specified for alias");
        }
        JSONObject user = this.loadUserObject(userId);
        if (user == null) {
            throw new IamIdentityDoesNotExist(userId);
        }
        this.storeObject(aliasObject, "aliases", id);
        JSONArray userAliases = user.optJSONArray("aliases");
        if (userAliases == null) {
            userAliases = new JSONArray();
            user.put("aliases", (Object)userAliases);
        }
        if (!(existing = new TreeSet(JsonVisitor.arrayToList((JSONArray)userAliases))).contains(id)) {
            userAliases.put((Object)id);
            this.storeUserObject(userId, user);
        }
    }

    protected void deleteAliasObject(String id) throws IamSvcException {
        String userId;
        JSONObject user;
        JSONArray userAliases;
        JSONObject alias = this.loadAliasObject(id);
        if (alias != null && (userAliases = (user = this.loadUserObject(userId = alias.getString("userId"))).optJSONArray("aliases")) != null && JsonUtil.removeStringFromArray((JSONArray)userAliases, (String)id)) {
            this.storeUserObject(userId, user);
        }
        this.deleteObject("aliases", id);
    }

    protected Collection<String> loadAliasesForUser(String userId) throws IamSvcException, IamIdentityDoesNotExist {
        JSONObject user = this.loadUserObject(userId);
        if (user == null) {
            throw new IamIdentityDoesNotExist(userId);
        }
        JSONArray userAliases = user.optJSONArray("aliases");
        if (userAliases != null) {
            return JsonVisitor.arrayToList((JSONArray)userAliases);
        }
        return new LinkedList<String>();
    }

    protected void storeInvalidJwtToken(String token) throws IamSvcException {
        this.storeObject(new JSONObject(), "invalidJwts", token);
    }

    protected boolean isInvalidJwtToken(String token) throws IamSvcException {
        return null != this.loadObject("invalidJwts", token);
    }

    public static class Builder {
        private File file = null;
        private boolean forceInit = false;
        private boolean readonly = true;
        private String password = null;
        private CommonJsonDb.AclFactory aclFactory;
        private JwtProducer jwtProducer = null;

        public Builder usingFile(File f) {
            this.file = f;
            return this;
        }

        public Builder withPassword(String password) {
            this.password = password != null && password.length() > 0 ? password : null;
            return this;
        }

        public Builder readonly(boolean ro) {
            this.readonly = ro;
            return this;
        }

        public Builder readonly() {
            return this.readonly(true);
        }

        public Builder forWrites() {
            return this.readonly(false);
        }

        public Builder forceInit() {
            this.forceInit = true;
            return this;
        }

        public Builder usingAclFactory(CommonJsonDb.AclFactory af) {
            this.aclFactory = af;
            return this;
        }

        public Builder withJwtProducer(JwtProducer p) {
            this.jwtProducer = p;
            return this;
        }

        public IamFileDb build() throws IamSvcException {
            return new IamFileDb(this);
        }
    }
}

