/*
 * Decompiled with CFR 0.152.
 */
package io.continual.iam.impl.file;

import io.continual.builder.Builder;
import io.continual.iam.IamServiceManager;
import io.continual.iam.access.AccessControlList;
import io.continual.iam.access.AccessDb;
import io.continual.iam.access.AccessManager;
import io.continual.iam.access.AclUpdateListener;
import io.continual.iam.exceptions.IamSvcException;
import io.continual.iam.identity.IdentityDb;
import io.continual.iam.identity.IdentityManager;
import io.continual.iam.identity.JwtValidator;
import io.continual.iam.impl.common.CommonJsonDb;
import io.continual.iam.impl.common.CommonJsonGroup;
import io.continual.iam.impl.common.CommonJsonIdentity;
import io.continual.iam.impl.common.jwt.JwtProducer;
import io.continual.iam.impl.common.jwt.SimpleJwtValidator;
import io.continual.iam.impl.file.IamFileDb;
import io.continual.iam.tags.TagManager;
import io.continual.services.ServiceContainer;
import io.continual.services.SimpleService;
import io.continual.util.data.exprEval.ExpressionEvaluator;
import io.continual.util.data.json.JsonVisitor;
import java.io.File;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class IamFileDbServiceManager
extends SimpleService
implements IamServiceManager<CommonJsonIdentity, CommonJsonGroup> {
    private final IamFileDb fDb;

    public IamFileDbServiceManager(ServiceContainer sc, JSONObject settings) throws IamSvcException, Builder.BuildFailure {
        final String sysAdminGroup = settings.optString("sysAdminGroup", "sysadmin");
        JSONObject jwt = settings.optJSONObject("jwt");
        JwtProducer p = null;
        if (jwt != null) {
            String jwtIssuer = jwt.optString("issuer", null);
            String jwtSecret = jwt.optString("sha256Key", null);
            if (jwtIssuer != null && jwtSecret != null) {
                p = new JwtProducer.Builder().withIssuerName(jwtIssuer).usingSigningKey(jwtSecret).build();
            }
        }
        ExpressionEvaluator evaluator = sc.getExprEval(settings);
        this.fDb = new IamFileDb.Builder().usingFile(new File(evaluator.evaluateText(settings.getString("file")))).withPassword(evaluator.evaluateText(settings.optString("password", ""))).readonly(settings.optBoolean("readonly", false)).usingAclFactory(new CommonJsonDb.AclFactory(){

            public AccessControlList createDefaultAcl(AclUpdateListener acll) {
                AccessControlList acl = new AccessControlList(acll);
                acl.permit(sysAdminGroup, new String[]{"read"}).permit(sysAdminGroup, new String[]{"update"}).permit(sysAdminGroup, new String[]{"create"}).permit(sysAdminGroup, new String[]{"delete"});
                return acl;
            }
        }).withJwtProducer(p).build();
        if (jwt != null) {
            JSONArray auths = jwt.optJSONArray("thirdPartyAuth");
            JsonVisitor.forEachElement((JSONArray)auths, (JsonVisitor.ArrayVisitor)new JsonVisitor.ArrayVisitor<JSONObject, Builder.BuildFailure>(){

                public boolean visit(JSONObject authEntry) throws JSONException, Builder.BuildFailure {
                    String keys = authEntry.optString("keys");
                    SimpleJwtValidator v = new SimpleJwtValidator.Builder().named(authEntry.optString("name", "(anonymous)")).forIssuer(authEntry.getString("issuer")).forAudience(authEntry.getString("audience")).getPublicKeysFrom(keys).build();
                    IamFileDbServiceManager.this.fDb.addJwtValidator((JwtValidator)v);
                    return true;
                }
            });
        }
    }

    public IdentityDb<CommonJsonIdentity> getIdentityDb() throws IamSvcException {
        return this.fDb;
    }

    public AccessDb<CommonJsonGroup> getAccessDb() throws IamSvcException {
        return this.fDb;
    }

    public IdentityManager<CommonJsonIdentity> getIdentityManager() throws IamSvcException {
        return this.fDb;
    }

    public AccessManager<CommonJsonGroup> getAccessManager() throws IamSvcException {
        return this.fDb;
    }

    public TagManager getTagManager() throws IamSvcException {
        return this.fDb;
    }
}

