/*
 * Decompiled with CFR 0.152.
 */
package io.continual.messaging;

import io.continual.iam.identity.Identity;
import io.continual.util.data.json.CommentedJsonTokener;
import io.continual.util.data.json.JsonSerialized;
import io.continual.util.data.json.JsonUtil;
import org.json.JSONException;
import org.json.JSONObject;
import org.json.JSONTokener;

public class ContinualMessage
implements JsonSerialized {
    private final JSONObject fMessageData;
    private static final String kMetadataKey = "\u221e\u24dc\u24d4\u24e3\u24d0\u221e";
    private static final String kStdMetadata = "standard";
    private static final String kStdMetata_CreateTime = "createTimeMs";
    private static final String kStdMetata_CreatedBy = "createdBy";

    public static Builder builder() {
        return new Builder();
    }

    public static ContinualMessage fromSerializedString(String jsonString) {
        JSONObject top = new JSONObject((JSONTokener)new CommentedJsonTokener(jsonString));
        JSONObject meta = top.optJSONObject(kMetadataKey);
        top.remove(kMetadataKey);
        return new ContinualMessage(top, meta);
    }

    public ContinualMessage(JSONObject data) {
        this(data, null);
    }

    public ContinualMessage(JSONObject data, JSONObject meta) {
        this.fMessageData = data == null ? new JSONObject() : JsonUtil.clone((JSONObject)data);
        this.fMessageData.put(kMetadataKey, (Object)(meta == null ? new JSONObject() : JsonUtil.clone((JSONObject)meta)));
    }

    public String toString() {
        return this.fMessageData.toString();
    }

    public JSONObject toJson() {
        return JsonUtil.clone((JSONObject)this.fMessageData);
    }

    public JSONObject getMessagePayload() {
        JSONObject result = this.toJson();
        result.remove(kMetadataKey);
        return result;
    }

    public int hashCode() {
        return JsonUtil.hash((JSONObject)this.fMessageData);
    }

    public boolean equals(Object that) {
        if (this == that) {
            return true;
        }
        if (that == null) {
            return false;
        }
        if (this.getClass() != that.getClass()) {
            return false;
        }
        String thisStr = JsonUtil.writeConsistently((JSONObject)this.fMessageData);
        String thatStr = JsonUtil.writeConsistently((JSONObject)((ContinualMessage)that).fMessageData);
        return thisStr.equals(thatStr);
    }

    public static class Builder {
        private JSONObject fPayload = new JSONObject();
        private JSONObject fMetadata = new JSONObject();

        public Builder createdAt(long timeMs) {
            return this.withMetaDataSection(ContinualMessage.kStdMetadata).set(ContinualMessage.kStdMetata_CreateTime, timeMs).close();
        }

        public Builder createdBy(Identity user) {
            return this.withMetaDataSection(ContinualMessage.kStdMetadata).set(ContinualMessage.kStdMetata_CreatedBy, user.getId()).close();
        }

        public Builder withMessageData(JSONObject data) {
            this.fPayload = JsonUtil.clone((JSONObject)data);
            return this;
        }

        public Builder withMessageData(String data) {
            this.fPayload = new JSONObject().put("data", (Object)data);
            return this;
        }

        public MetadataSectionBuilder withMetaDataSection(String sectionName) {
            JSONObject data = this.fMetadata.optJSONObject(sectionName);
            if (data == null) {
                data = new JSONObject();
                this.fMetadata.put(sectionName, (Object)data);
            }
            return new MetadataSectionBuilder(this, data);
        }

        public ContinualMessage build() {
            return new ContinualMessage(this.fPayload, this.fMetadata);
        }
    }

    public static class MetadataSectionBuilder {
        private final Builder fBuilder;
        private final JSONObject fData;

        public MetadataSectionBuilder(Builder b, JSONObject data) {
            this.fBuilder = b;
            this.fData = data;
        }

        public MetadataSectionBuilder set(String key, Object val) {
            try {
                this.fData.put(key, val);
            }
            catch (JSONException x) {
                throw new IllegalArgumentException(x);
            }
            return this;
        }

        public Builder close() {
            return this.fBuilder;
        }
    }
}

