/*
 * Decompiled with CFR 0.152.
 */
package io.continual.services.model.impl.client;

import io.continual.builder.Builder;
import io.continual.iam.access.AccessControlList;
import io.continual.iam.identity.Identity;
import io.continual.jsonHttpClient.HttpUsernamePasswordCredentials;
import io.continual.jsonHttpClient.JsonOverHttpClient;
import io.continual.jsonHttpClient.impl.ok.OkHttp;
import io.continual.services.ServiceContainer;
import io.continual.services.SimpleService;
import io.continual.services.model.core.Model;
import io.continual.services.model.core.ModelObjectAndPath;
import io.continual.services.model.core.ModelObjectFactory;
import io.continual.services.model.core.ModelObjectList;
import io.continual.services.model.core.ModelObjectMetadata;
import io.continual.services.model.core.ModelPathListPage;
import io.continual.services.model.core.ModelQuery;
import io.continual.services.model.core.ModelRelation;
import io.continual.services.model.core.ModelRelationInstance;
import io.continual.services.model.core.ModelRequestContext;
import io.continual.services.model.core.ModelTraversal;
import io.continual.services.model.core.PageRequest;
import io.continual.services.model.core.data.JsonModelObject;
import io.continual.services.model.core.data.ModelObject;
import io.continual.services.model.core.exceptions.ModelItemDoesNotExistException;
import io.continual.services.model.core.exceptions.ModelRequestException;
import io.continual.services.model.core.exceptions.ModelSchemaViolationException;
import io.continual.services.model.core.exceptions.ModelServiceException;
import io.continual.services.model.impl.client.LocalIdentity;
import io.continual.services.model.impl.client.LocalRelationSelector;
import io.continual.services.model.impl.common.BasicModelRequestContextBuilder;
import io.continual.services.model.impl.common.SimpleModelQuery;
import io.continual.services.model.impl.common.SimpleTraversal;
import io.continual.services.model.impl.json.CommonDataTransfer;
import io.continual.services.model.impl.json.CommonJsonDbModel;
import io.continual.util.data.TypeConvertor;
import io.continual.util.data.exprEval.ExpressionEvaluator;
import io.continual.util.data.json.JsonVisitor;
import io.continual.util.naming.Path;
import java.io.IOException;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ModelClient
extends SimpleService
implements Model {
    private final String fAcctId;
    private final String fModelId;
    private final JsonOverHttpClient fClient;
    private final HttpUsernamePasswordCredentials fCreds;
    private final String fBaseUrl;
    private final Path fPathPrefix;
    private static final Logger log = LoggerFactory.getLogger(CommonJsonDbModel.class);

    public ModelClient(String acctId, String modelId, String baseUrl, Path pathPrefix, String username, String password) {
        this.fAcctId = acctId;
        this.fModelId = modelId;
        this.fClient = new OkHttp();
        this.fBaseUrl = baseUrl;
        this.fPathPrefix = pathPrefix;
        this.fCreds = new HttpUsernamePasswordCredentials(username, password);
    }

    public ModelClient(ServiceContainer sc, JSONObject config) throws Builder.BuildFailure {
        try {
            ExpressionEvaluator ee = sc.getExprEval();
            this.fAcctId = config.getString("acctId");
            this.fModelId = config.getString("modelId");
            this.fClient = new OkHttp();
            this.fBaseUrl = config.optString("baseUrl", "https://model.continual.io");
            this.fPathPrefix = Path.fromString((String)config.optString("pathPrefix", "/"));
            this.fCreds = new HttpUsernamePasswordCredentials(ee.evaluateText(config.getString("username")), ee.evaluateText(config.getString("password")));
        }
        catch (JSONException e) {
            throw new Builder.BuildFailure((Throwable)e);
        }
    }

    public String getAcctId() {
        return this.fAcctId;
    }

    public String getId() {
        return this.fModelId;
    }

    public long getMaxSerializedObjectLength() {
        return 0x40000000L;
    }

    public long getMaxPathLength() {
        return 1024L;
    }

    public long getMaxRelnNameLength() {
        return 1024L;
    }

    public void close() throws IOException {
        this.fClient.close();
    }

    public Model.ModelRequestContextBuilder getRequestContextBuilder() {
        return new BasicModelRequestContextBuilder().forUser((Identity)new LocalIdentity(this.fCreds.getUser()));
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public ModelPathListPage listChildrenOfPath(ModelRequestContext context, Path prefix, PageRequest pr) throws ModelServiceException, ModelRequestException {
        try (JsonOverHttpClient.HttpResponse resp = this.fClient.newRequest().asUser(this.fCreds).onPath(this.pathToUrl(prefix)).addQueryParam("children", "1").addQueryParam("pg", pr.getRequestedPage()).addQueryParam("sz", pr.getRequestedPageSize()).get();){
            final LinkedList result = new LinkedList();
            JsonVisitor.forEachElement((JSONArray)resp.getBody().optJSONArray("children"), (JsonVisitor.ArrayVisitor)new JsonVisitor.ArrayVisitor<String, JSONException>(){

                public boolean visit(String path) throws JSONException {
                    result.add(ModelClient.this.modelPathToUserPath(Path.fromString((String)path)));
                    return true;
                }
            });
            ModelPathListPage modelPathListPage = ModelPathListPage.wrap(result, (PageRequest)pr);
            return modelPathListPage;
        }
        catch (JsonOverHttpClient.BodyFormatException | JsonOverHttpClient.HttpServiceException | JSONException e) {
            throw new ModelServiceException(e);
        }
    }

    public ModelQuery startQuery() {
        return new RemoteModelQuery();
    }

    public Model setRelationType(ModelRequestContext context, String relnName, Model.RelationType rt) throws ModelServiceException, ModelRequestException {
        throw new ModelRequestException("not yet implemented");
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public ModelRelationInstance relate(ModelRequestContext context, ModelRelation userReln) throws ModelServiceException, ModelRequestException {
        final ModelRelation reln = ModelRelation.from((Path)this.userPathToModelPath(userReln.getFrom()), (String)userReln.getName(), (Path)this.userPathToModelPath(userReln.getTo()));
        JSONObject relationPayload = new JSONObject().put("relations", (Object)new JSONArray().put((Object)new JSONObject().put("from", (Object)reln.getFrom().toString()).put("name", (Object)reln.getName()).put("to", (Object)reln.getTo().toString())));
        try (JsonOverHttpClient.HttpResponse resp = this.fClient.newRequest().asUser(this.fCreds).onPath(this.getBasePath("relations") + "?fail=any").post(relationPayload);){
            if (resp.isClientError()) {
                throw new ModelRequestException("server replied " + resp.getCode() + " " + resp.getMessage());
            }
            if (resp.isServerError()) {
                throw new ModelServiceException("server replied " + resp.getCode() + " " + resp.getMessage());
            }
            JSONObject data = resp.getBody();
            JSONArray relns = data.getJSONArray("relations");
            if (relns.length() != 1) {
                throw new JsonOverHttpClient.BodyFormatException("Received " + relns.length() + " relations in response to posting one.");
            }
            JSONObject newReln = relns.getJSONObject(0);
            final String id = newReln.getString("id");
            ModelRelationInstance modelRelationInstance = new ModelRelationInstance(){

                public String getId() {
                    return id;
                }

                public Path getFrom() {
                    return reln.getFrom();
                }

                public Path getTo() {
                    return reln.getTo();
                }

                public String getName() {
                    return reln.getName();
                }

                public int compareTo(ModelRelation that) {
                    return ModelRelation.compare((ModelRelation)this, (ModelRelation)that);
                }
            };
            return modelRelationInstance;
        }
        catch (JsonOverHttpClient.BodyFormatException | JsonOverHttpClient.HttpServiceException | JSONException e) {
            throw new ModelServiceException(e);
        }
    }

    public boolean unrelate(ModelRequestContext context, ModelRelation reln) throws ModelServiceException, ModelRequestException {
        throw new ModelServiceException("The model service doesn't currently have an API for removing a relation without its ID.");
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean unrelate(ModelRequestContext context, String relnId) throws ModelServiceException, ModelRequestException {
        try (JsonOverHttpClient.HttpResponse resp = this.fClient.newRequest().asUser(this.fCreds).onPath(this.getBasePath("relations") + "/" + this.encodeString(relnId)).delete();){
            if (resp.isSuccess()) {
                JSONObject respBody = resp.getBody();
                boolean bl = respBody.optBoolean("removal", false);
                return bl;
            }
            if (!resp.isClientError()) throw new ModelServiceException("server replied " + resp.getCode() + " " + resp.getMessage());
            throw new ModelRequestException("server replied " + resp.getCode() + " " + resp.getMessage());
        }
        catch (JsonOverHttpClient.BodyFormatException | JsonOverHttpClient.HttpServiceException e) {
            throw new ModelServiceException(e);
        }
    }

    public List<ModelRelationInstance> getInboundRelationsNamed(ModelRequestContext context, Path forObject, String named) throws ModelServiceException, ModelRequestException {
        return this.getRelns(forObject, true, named);
    }

    public List<ModelRelationInstance> getOutboundRelationsNamed(ModelRequestContext context, Path forObject, String named) throws ModelServiceException, ModelRequestException {
        return this.getRelns(forObject, false, named);
    }

    public boolean exists(ModelRequestContext context, Path objectPath) throws ModelServiceException, ModelRequestException {
        if (context.knownToNotExist(objectPath)) {
            return false;
        }
        try {
            this.load(context, objectPath);
            return true;
        }
        catch (ModelItemDoesNotExistException e) {
            context.doesNotExist(objectPath);
            return false;
        }
    }

    public <T, K> T load(ModelRequestContext context, Path objectPath, ModelObjectFactory<T, K> factory, final K userContext) throws ModelItemDoesNotExistException, ModelServiceException, ModelRequestException {
        CommonDataTransfer ld;
        block19: {
            if (context.knownToNotExist(objectPath)) {
                throw new ModelItemDoesNotExistException(objectPath);
            }
            ld = (CommonDataTransfer)context.get(objectPath, CommonDataTransfer.class);
            if (ld == null) {
                String path = this.pathToUrl(objectPath);
                try (JsonOverHttpClient.HttpResponse resp = this.fClient.newRequest().asUser(this.fCreds).onPath(path).get();){
                    if (resp.isSuccess()) {
                        JSONObject respBody = resp.getBody();
                        JSONObject obj = respBody.optJSONObject("object");
                        if (obj == null) {
                            throw new ModelServiceException("Expected 'object' in response payload.");
                        }
                        ld = new CommonDataTransfer(objectPath, obj);
                        context.put(objectPath, (Object)ld);
                        break block19;
                    }
                    if (resp.isNotFound()) {
                        context.doesNotExist(objectPath);
                        throw new ModelItemDoesNotExistException(objectPath);
                    }
                    throw new ModelServiceException("server replied " + resp.getCode() + " " + resp.getMessage());
                }
                catch (JsonOverHttpClient.BodyFormatException | JsonOverHttpClient.HttpServiceException e) {
                    throw new ModelServiceException(e);
                }
            }
        }
        final CommonDataTransfer ldf = ld;
        return (T)factory.create(new ModelObjectFactory.ObjectCreateContext<K>(){

            public ModelObjectMetadata getMetadata() {
                return ldf.getMetadata();
            }

            public ModelObject getData() {
                return ldf.getObjectData();
            }

            public K getUserContext() {
                return userContext;
            }
        });
    }

    public Model.ObjectUpdater createUpdate(final ModelRequestContext context, final Path objectPath) throws ModelRequestException, ModelServiceException {
        return new Model.ObjectUpdater(){
            private final LinkedList<Update> fUpdates = new LinkedList();

            public Model.ObjectUpdater overwrite(ModelObject withData) {
                this.fUpdates.add(new Update(objectPath, UpdateType.OVERWRITE, withData));
                return this;
            }

            public Model.ObjectUpdater merge(ModelObject withData) {
                this.fUpdates.add(new Update(objectPath, UpdateType.MERGE, withData));
                return this;
            }

            public Model.ObjectUpdater replaceAcl(AccessControlList acl) {
                this.fUpdates.add(new Update(objectPath, acl));
                return this;
            }

            public void execute() throws ModelRequestException, ModelSchemaViolationException, ModelServiceException {
                for (Update mu : this.fUpdates) {
                    mu.update(context);
                }
                log.info("wrote {}", (Object)objectPath);
                context.remove(objectPath);
            }
        };
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean remove(ModelRequestContext context, Path objectPath) throws ModelServiceException, ModelRequestException {
        context.remove(objectPath);
        String path = this.pathToUrl(objectPath);
        try (JsonOverHttpClient.HttpResponse resp = this.fClient.newRequest().asUser(this.fCreds).onPath(path).delete();){
            if (resp.isSuccess()) {
                JSONObject respBody = resp.getBody();
                boolean bl = respBody.optBoolean("removal", false);
                return bl;
            }
            if (!resp.isClientError()) throw new ModelServiceException("server replied " + resp.getCode() + " " + resp.getMessage());
            throw new ModelRequestException("server replied " + resp.getCode() + " " + resp.getMessage());
        }
        catch (JsonOverHttpClient.BodyFormatException | JsonOverHttpClient.HttpServiceException e) {
            throw new ModelServiceException(e);
        }
    }

    public Model createIndex(String field) throws ModelRequestException, ModelServiceException {
        return this;
    }

    public ModelTraversal startTraversal() throws ModelRequestException {
        return new SimpleTraversal((Model)this);
    }

    public Model.RelationSelector selectRelations(Path objectPath) {
        return new LocalRelationSelector(this, objectPath);
    }

    private String getBasePath(String section) {
        return this.fBaseUrl + "/v1/" + section;
    }

    private String encodeString(String text) {
        return TypeConvertor.urlEncode((String)text);
    }

    private String encodePath(Path p) {
        return this.encodeString(this.fPathPrefix.makeChildPath(p).toString().substring(1));
    }

    private String pathToUrl(Path objectPath) {
        return this.getBasePath("model") + "/" + this.encodePath(objectPath);
    }

    private Path userPathToModelPath(Path p) {
        return this.fPathPrefix.makeChildPath(p);
    }

    private Path modelPathToUserPath(Path p) {
        return p.makePathWithinParent(this.fPathPrefix);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private List<ModelRelationInstance> getRelns(final Path forObject, final boolean inbound, String relnName) throws ModelItemDoesNotExistException, ModelRequestException, ModelServiceException {
        final LinkedList<ModelRelationInstance> result = new LinkedList<ModelRelationInstance>();
        String path = this.getBasePath("relations") + (inbound ? "/in/" : "/out/") + this.encodePath(forObject);
        try (JsonOverHttpClient.HttpResponse resp = this.fClient.newRequest().asUser(this.fCreds).onPath(path).get();){
            if (resp.isSuccess()) {
                JSONObject respBody = resp.getBody();
                JSONObject relns = respBody.getJSONObject("relations");
                JSONObject dir = relns.getJSONObject(inbound ? "in" : "out");
                JsonVisitor.forEachElement((JSONObject)dir, (JsonVisitor.ObjectVisitor)new JsonVisitor.ObjectVisitor<JSONArray, JSONException>(){

                    public boolean visit(final String relnName, JSONArray srcObjPath) throws JSONException {
                        JsonVisitor.forEachElement((JSONArray)srcObjPath, (JsonVisitor.ArrayVisitor)new JsonVisitor.ArrayVisitor<String, JSONException>(){

                            public boolean visit(String srcObj) throws JSONException {
                                Path srcPath = Path.fromString((String)srcObj);
                                result.add(ModelRelationInstance.from((ModelRelation)ModelRelation.from((Path)(inbound ? srcPath : forObject), (String)relnName, (Path)(inbound ? forObject : srcPath))));
                                return true;
                            }
                        });
                        return true;
                    }
                });
                LinkedList<ModelRelationInstance> linkedList = result;
                return linkedList;
            }
            if (resp.isNotFound()) {
                throw new ModelItemDoesNotExistException(forObject);
            }
            if (!resp.isClientError()) throw new ModelServiceException("server replied " + resp.getCode() + " " + resp.getMessage());
            throw new ModelRequestException("server replied " + resp.getCode() + " " + resp.getMessage());
        }
        catch (JsonOverHttpClient.BodyFormatException | JsonOverHttpClient.HttpServiceException e) {
            throw new ModelServiceException(e);
        }
    }

    protected void onStopRequested() {
        this.fClient.close();
    }

    private class RemoteModelQuery
    extends SimpleModelQuery {
        private RemoteModelQuery() {
        }

        public <T, K> ModelObjectList<T> execute(ModelRequestContext context, ModelObjectFactory<T, K> factory, final ModelQuery.DataAccessor<T> accessor, K userContext) throws ModelRequestException, ModelServiceException {
            final LinkedList<ModelObjectAndPath> result = new LinkedList<ModelObjectAndPath>();
            ModelPathListPage objectPaths = ModelClient.this.listChildrenOfPath(context, this.getPathPrefix());
            for (Path objectPath : objectPaths) {
                SimpleModelQuery.Filter f;
                T mo = ModelClient.this.load(context, objectPath, factory, userContext);
                boolean match = true;
                Iterator iterator = this.getFilters().iterator();
                while (iterator.hasNext() && (match = (f = (SimpleModelQuery.Filter)iterator.next()).matches((Object)accessor.getDataFrom(mo)))) {
                }
                if (!match) continue;
                result.add(ModelObjectAndPath.from((Path)objectPath, mo));
            }
            final Comparator orderBy = this.getOrdering();
            if (orderBy != null) {
                Collections.sort(result, new Comparator<ModelObjectAndPath<T>>(){

                    @Override
                    public int compare(ModelObjectAndPath<T> o1, ModelObjectAndPath<T> o2) {
                        return orderBy.compare(accessor.getDataFrom(o1.getObject()), accessor.getDataFrom(o2.getObject()));
                    }
                });
            }
            return new ModelObjectList<T>(){

                public Iterator<ModelObjectAndPath<T>> iterator() {
                    return result.iterator();
                }
            };
        }
    }

    private class Update {
        private final Path fPath;
        private final UpdateType fType;
        private final ModelObject fData;

        public Update(Path path, UpdateType ut, ModelObject data) {
            this.fPath = path;
            this.fType = ut;
            this.fData = data;
        }

        public void update(ModelRequestContext context) throws ModelRequestException, ModelServiceException {
            if (this.fType == UpdateType.ACL) {
                throw new ModelRequestException("This model does not currently support ACL updates.");
            }
            JsonOverHttpClient.HttpRequest req = ModelClient.this.fClient.newRequest().asUser(ModelClient.this.fCreds).onPath(ModelClient.this.pathToUrl(this.fPath));
            try (JsonOverHttpClient.HttpResponse resp = this.fType == UpdateType.OVERWRITE ? req.put(JsonModelObject.modelObjectToJson((ModelObject)this.fData)) : req.patch(JsonModelObject.modelObjectToJson((ModelObject)this.fData));){
                if (resp.isClientError()) {
                    throw new ModelRequestException("server replied " + resp.getCode() + " " + resp.getMessage());
                }
                if (resp.isServerError()) {
                    throw new ModelServiceException("server replied " + resp.getCode() + " " + resp.getMessage());
                }
            }
            catch (JsonOverHttpClient.HttpServiceException e) {
                throw new ModelServiceException((Throwable)e);
            }
        }

        public Update(Path path, AccessControlList acl) {
            this.fPath = path;
            this.fType = UpdateType.ACL;
            this.fData = null;
        }
    }

    private static enum UpdateType {
        OVERWRITE,
        MERGE,
        ACL;

    }
}

