/*
 * Decompiled with CFR 0.152.
 */
package io.continual.services.processor.library.modelio.processors;

import io.continual.builder.Builder;
import io.continual.services.model.core.Model;
import io.continual.services.model.core.ModelObject;
import io.continual.services.model.core.ModelRequestContext;
import io.continual.services.model.core.ModelUpdater;
import io.continual.services.model.core.exceptions.ModelRequestException;
import io.continual.services.model.core.exceptions.ModelServiceException;
import io.continual.services.model.core.updaters.DataMerge;
import io.continual.services.model.core.updaters.DataOverwrite;
import io.continual.services.processor.config.readers.ConfigLoadContext;
import io.continual.services.processor.engine.library.util.Setter;
import io.continual.services.processor.engine.model.Message;
import io.continual.services.processor.engine.model.MessageProcessingContext;
import io.continual.services.processor.engine.model.Processor;
import io.continual.services.processor.engine.model.StreamProcessingContext;
import io.continual.services.processor.library.modelio.services.ModelService;
import io.continual.util.data.exprEval.ExprDataSource;
import io.continual.util.data.json.JsonEval;
import io.continual.util.data.json.JsonUtil;
import io.continual.util.naming.Path;
import java.util.List;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class ModelUpdate
implements Processor {
    private final JSONArray fUpdates;

    public ModelUpdate(ConfigLoadContext sc, JSONObject config) throws Builder.BuildFailure {
        this.fUpdates = JsonUtil.clone((JSONArray)config.getJSONArray("updates"));
    }

    public void process(MessageProcessingContext context) {
        try {
            ModelService modelSvc = (ModelService)((Object)context.getStreamProcessingContext().getReqdNamedObject("model", ModelService.class));
            Model model = modelSvc.getModel();
            ModelRequestContext mrc = model.getRequestContextBuilder().forUser(context.getStreamProcessingContext().getOperator()).build();
            for (int i = 0; i < this.fUpdates.length(); ++i) {
                JSONArray evaled;
                JSONArray data;
                JSONObject updateBlock = this.fUpdates.getJSONObject(i);
                String pathText = context.evalExpression(updateBlock.getString("path"));
                Path path = Path.fromString((String)pathText);
                if (updateBlock.has("delete")) {
                    model.remove(mrc, path);
                    continue;
                }
                if (updateBlock.has("deleteFields")) {
                    data = updateBlock.getJSONArray("deleteFields");
                    evaled = Setter.evaluate((MessageProcessingContext)context, (JSONArray)data, (Message)context.getMessage(), (ExprDataSource[])new ExprDataSource[0]);
                    ModelObject mo = model.load(mrc, path);
                    JSONObject modelData = mo.getData();
                    for (int j = 0; j < evaled.length(); ++j) {
                        String field = evaled.getString(j);
                        List parts = JsonEval.splitPath((String)field);
                        JSONObject container = JsonEval.getContainerOf((JSONObject)modelData, (String)field);
                        container.remove((String)parts.get(parts.size() - 1));
                    }
                    model.store(mrc, path, new ModelUpdater[]{new DataOverwrite(modelData)});
                    continue;
                }
                if (updateBlock.has("patch")) {
                    data = updateBlock.getJSONObject("patch");
                    evaled = Setter.evaluate((MessageProcessingContext)context, (JSONObject)data, (Message)context.getMessage(), (ExprDataSource[])new ExprDataSource[0]);
                    model.store(mrc, path, new ModelUpdater[]{new DataMerge((JSONObject)evaled)});
                    continue;
                }
                if (!updateBlock.has("put")) continue;
                data = updateBlock.getJSONObject("put");
                evaled = Setter.evaluate((MessageProcessingContext)context, (JSONObject)data, (Message)context.getMessage(), (ExprDataSource[])new ExprDataSource[0]);
                model.store(mrc, path, new ModelUpdater[]{new DataOverwrite((JSONObject)evaled)});
            }
        }
        catch (Builder.BuildFailure | ModelRequestException | ModelServiceException | StreamProcessingContext.NoSuitableObjectException | JSONException e) {
            context.warn(e.getMessage());
        }
    }
}

