/*
 * Decompiled with CFR 0.152.
 */
package io.continual.services.processor.library.modelio.sources;

import io.continual.builder.Builder;
import io.continual.services.model.core.Model;
import io.continual.services.model.core.ModelObject;
import io.continual.services.model.core.ModelObjectList;
import io.continual.services.model.core.ModelQuery;
import io.continual.services.model.core.ModelRequestContext;
import io.continual.services.model.core.exceptions.ModelRequestException;
import io.continual.services.model.core.exceptions.ModelServiceException;
import io.continual.services.processor.config.readers.ConfigLoadContext;
import io.continual.services.processor.engine.library.sources.BasicSource;
import io.continual.services.processor.engine.model.Message;
import io.continual.services.processor.engine.model.MessageAndRouting;
import io.continual.services.processor.engine.model.StreamProcessingContext;
import io.continual.services.processor.library.modelio.services.ModelService;
import io.continual.util.data.exprEval.ExpressionEvaluator;
import java.io.IOException;
import java.util.Iterator;
import org.json.JSONException;
import org.json.JSONObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ModelSource
extends BasicSource {
    private final String fModelSvcName;
    private Iterator<ModelObject> fResults;
    private static final Logger log = LoggerFactory.getLogger(ModelSource.class);

    public ModelSource(ConfigLoadContext clc, JSONObject config) throws Builder.BuildFailure {
        super(config);
        try {
            ExpressionEvaluator ee = clc.getServiceContainer().getExprEval(config);
            this.fModelSvcName = ee.evaluateText(config.getString("modelName"));
            this.fResults = null;
        }
        catch (JSONException e) {
            throw new Builder.BuildFailure((Throwable)e);
        }
    }

    protected synchronized MessageAndRouting internalGetNextMessage(StreamProcessingContext spc) throws IOException, InterruptedException {
        try {
            if (this.fResults == null) {
                log.info("Executing query...");
                ModelService ms = (ModelService)((Object)spc.getNamedObject(this.fModelSvcName, ModelService.class));
                if (ms == null) {
                    spc.fail("No model service named " + this.fModelSvcName + ".");
                    this.fResults = ModelObjectList.emptyList().iterator();
                    return null;
                }
                Model model = ms.getModel();
                ModelRequestContext mrc = model.getRequestContextBuilder().forUser(spc.getOperator()).build();
                ModelQuery fQuery = model.startQuery();
                ModelObjectList mol = fQuery.execute(mrc);
                this.fResults = mol.iterator();
            }
            if (this.fResults.hasNext()) {
                ModelObject mo = this.fResults.next();
                JSONObject asJson = mo.toJson().getJSONObject("data");
                asJson.put("modelPath", (Object)mo.getId());
                Message msg = Message.adoptJsonAsMessage((JSONObject)asJson);
                return this.makeDefRoutingMessage(msg);
            }
            this.noteEndOfStream();
        }
        catch (Builder.BuildFailure | ModelRequestException | ModelServiceException e) {
            spc.fail(e.getMessage());
        }
        return null;
    }
}

