/*
 * Decompiled with CFR 0.152.
 */
package io.continual.services.model.api;

import io.continual.builder.Builder;
import io.continual.http.service.framework.CHttpErrorHandler;
import io.continual.http.service.framework.context.CHttpRequestContext;
import io.continual.http.service.framework.routing.CHttpRequestRouter;
import io.continual.restHttp.HttpServlet;
import io.continual.restHttp.TypicalHttpRouter;
import io.continual.services.ServiceContainer;
import io.continual.services.model.api.endpoints.AuthApiHandler;
import io.continual.services.model.api.endpoints.ModelApi;
import io.continual.services.model.api.endpoints.ObjectApi;
import io.continual.services.model.core.exceptions.ModelAccessException;
import io.continual.services.model.core.exceptions.ModelItemDoesNotExistException;
import io.continual.services.model.core.exceptions.ModelRequestException;
import io.continual.services.model.service.ModelService;
import io.continual.util.nv.NvReadable;
import java.io.IOException;
import org.json.JSONException;
import org.json.JSONObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ModelApiRouter
extends TypicalHttpRouter {
    private final AuthApiHandler fAuthApi;
    private final ModelApi fModelApi;
    private final ObjectApi fObjectApi;
    private final ModelService fModelService;
    private static final Logger log = LoggerFactory.getLogger(ModelApiRouter.class);

    public ModelApiRouter(ServiceContainer sc, JSONObject config, ModelService ms) {
        this.fModelApi = new ModelApi(ms);
        this.fObjectApi = new ObjectApi(ms);
        this.fAuthApi = new AuthApiHandler(sc, config);
        this.fModelService = ms;
    }

    public ModelService getModelService() {
        return this.fModelService;
    }

    public void setupRouter(HttpServlet servlet, CHttpRequestRouter rr, NvReadable p) throws IOException, Builder.BuildFailure {
        rr.setHandlerForException(CHttpRequestRouter.noMatchingRoute.class, new CHttpErrorHandler(){

            public void handle(CHttpRequestContext ctx, Throwable cause) {
                ctx.response().sendErrorAndBody(404, new JSONObject().put("error", 404).put("message", (Object)"Not found. See the API docs.").toString(), "application/json");
            }
        });
        rr.setHandlerForException(ModelAccessException.class, new CHttpErrorHandler(){

            public void handle(CHttpRequestContext ctx, Throwable cause) {
                ctx.response().sendErrorAndBody(403, new JSONObject().put("error", 403).put("message", (Object)("Unauthorized: " + cause.getMessage())).toString(), "application/json");
            }
        });
        rr.setHandlerForException(ModelItemDoesNotExistException.class, new CHttpErrorHandler(){

            public void handle(CHttpRequestContext ctx, Throwable cause) {
                ctx.response().sendErrorAndBody(404, new JSONObject().put("error", 404).put("message", (Object)("Not found: " + cause.getMessage())).toString(), "application/json");
            }
        });
        rr.setHandlerForException(ModelRequestException.class, new CHttpErrorHandler(){

            public void handle(CHttpRequestContext ctx, Throwable cause) {
                ctx.response().sendErrorAndBody(400, new JSONObject().put("error", 400).put("message", (Object)cause.getMessage()).toString(), "application/json");
            }
        });
        rr.setHandlerForException(JSONException.class, new CHttpErrorHandler(){

            public void handle(CHttpRequestContext ctx, Throwable cause) {
                ctx.response().sendErrorAndBody(400, new JSONObject().put("error", 400).put("message", (Object)"Bad request. See the API docs.").toString(), "application/json");
            }
        });
        rr.setHandlerForException(Throwable.class, new CHttpErrorHandler(){

            public void handle(CHttpRequestContext ctx, Throwable cause) {
                ctx.response().sendErrorAndBody(500, new JSONObject().put("error", 500).put("message", (Object)"There was a problem at the server.").toString(), "application/json");
                log.warn(cause.getMessage(), cause);
            }
        });
        this.loadConfigs(rr, new TypicalHttpRouter.ConfigAndClass[]{new TypicalHttpRouter.ConfigAndClass((TypicalHttpRouter)this, "authRoutes.conf", (Object)this.fAuthApi), new TypicalHttpRouter.ConfigAndClass((TypicalHttpRouter)this, "modelApi.conf", (Object)this.fModelApi), new TypicalHttpRouter.ConfigAndClass((TypicalHttpRouter)this, "objectApi.conf", (Object)this.fObjectApi), new TypicalHttpRouter.ConfigAndClass((TypicalHttpRouter)this, "metrics.conf", null), new TypicalHttpRouter.ConfigAndClass((TypicalHttpRouter)this, "options.conf", null)});
    }
}

