/*
 * Decompiled with CFR 0.152.
 */
package io.continual.metrics.reporters;

import io.continual.metrics.MetricsService;
import io.continual.metrics.ReporterBuilder;
import io.continual.shaded.com.codahale.metrics.MetricFilter;
import io.continual.shaded.com.codahale.metrics.ScheduledReporter;
import io.continual.shaded.com.codahale.metrics.graphite.Graphite;
import io.continual.shaded.com.codahale.metrics.graphite.GraphiteReporter;
import java.net.InetSocketAddress;
import java.util.concurrent.TimeUnit;
import org.json.JSONObject;

public class GraphiteReporterBuilder
implements ReporterBuilder {
    private final ScheduledReporter fReporter;

    public GraphiteReporterBuilder(MetricsService svc, JSONObject graphiteConfig) {
        Graphite graphite = new Graphite(new InetSocketAddress(graphiteConfig.optString("hostname", "localhost"), graphiteConfig.optInt("port", 2003)));
        this.fReporter = GraphiteReporter.forRegistry(svc.getRegistry()).prefixedWith(graphiteConfig.getString("metricsNodeName")).convertRatesTo(TimeUnit.SECONDS).convertDurationsTo(TimeUnit.MILLISECONDS).filter(MetricFilter.ALL).build(graphite);
    }

    @Override
    public ScheduledReporter getReporter() {
        return this.fReporter;
    }
}

