/*
 * Decompiled with CFR 0.152.
 */
package io.continual.util.data;

import io.continual.util.data.TypeConvertor;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import javax.crypto.Mac;
import javax.crypto.spec.SecretKeySpec;

public class Sha1HmacSigner {
    private static final String kHmacSha1Algo = "HmacSHA1";

    public static String sign(String message, String key) {
        try {
            SecretKeySpec secretKey = new SecretKeySpec(key.getBytes(), kHmacSha1Algo);
            Mac mac = Mac.getInstance(kHmacSha1Algo);
            mac.init(secretKey);
            byte[] rawHmac = mac.doFinal(message.getBytes());
            return TypeConvertor.base64Encode(rawHmac);
        }
        catch (InvalidKeyException e) {
            throw new RuntimeException(e);
        }
        catch (NoSuchAlgorithmException e) {
            throw new RuntimeException(e);
        }
        catch (IllegalStateException e) {
            throw new RuntimeException(e);
        }
    }

    public static void main(String[] args) {
        if (args.length != 2) {
            System.err.println("usage: Sha1HmacSigner <message> <key>");
        } else if (args.length == 2) {
            System.out.println(Sha1HmacSigner.sign(args[0], args[1]));
        }
    }
}

