/*
 * Decompiled with CFR 0.152.
 */
package io.continual.util.data;

import io.continual.util.data.base64.Base64InputStream;
import io.continual.util.data.base64.Base64OutputStream;
import io.continual.util.data.csv.CsvEncoder;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.net.URLEncoder;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.time.Instant;
import java.util.Date;
import java.util.TimeZone;

public class TypeConvertor {
    private static final String[] parsers = new String[]{"MM/dd/yyyy H:mm:ss", "MM/dd/yyyy"};

    public static boolean convertToBoolean(String s) {
        return Boolean.parseBoolean(s);
    }

    public static boolean convertToBooleanBroad(String s) {
        if (s == null) {
            return false;
        }
        boolean result = TypeConvertor.convertToBoolean(s = s.trim()) || s.equalsIgnoreCase("true") || s.equalsIgnoreCase("yes") || s.equalsIgnoreCase("on") || s.equalsIgnoreCase("1") || s.equalsIgnoreCase("y") || s.equalsIgnoreCase("checked");
        return result;
    }

    public static boolean convertToBoolean(int i) {
        return i != 0;
    }

    public static boolean convertToBoolean(long i) {
        return i != 0L;
    }

    public static int convertToInt(String s) throws conversionError {
        int result = 0;
        if (s != null) {
            try {
                result = Integer.parseInt(s);
            }
            catch (NumberFormatException e) {
                throw new conversionError("couldn't convert '" + s + "' to an integer");
            }
        }
        return result;
    }

    public static int convertToInt(String s, int errval) {
        try {
            return TypeConvertor.convertToInt(s);
        }
        catch (conversionError e) {
            return errval;
        }
    }

    public static long convertToLong(String s) throws conversionError {
        long result = 0L;
        if (s != null) {
            try {
                result = Long.parseLong(s);
            }
            catch (NumberFormatException e) {
                throw new conversionError("couldn't convert " + s + " to a long");
            }
        }
        return result;
    }

    public static long convertToLong(String s, long errval) {
        try {
            return TypeConvertor.convertToLong(s);
        }
        catch (conversionError e) {
            return errval;
        }
    }

    public static short convertToShort(String s) throws conversionError {
        short result = 0;
        if (s != null) {
            try {
                result = Short.parseShort(s);
            }
            catch (NumberFormatException e) {
                throw new conversionError("couldn't convert " + s + " to a short");
            }
        }
        return result;
    }

    public static long convertToShort(String s, long errval) {
        try {
            return TypeConvertor.convertToShort(s);
        }
        catch (conversionError e) {
            return errval;
        }
    }

    public static double convertToDouble(String s) throws conversionError {
        double result = 0.0;
        if (s != null) {
            try {
                result = Double.parseDouble(s);
            }
            catch (NumberFormatException e) {
                throw new conversionError("couldn't convert " + s + " to a double");
            }
        }
        return result;
    }

    public static double convertToDouble(String s, double errval) {
        if (s == null) {
            return errval;
        }
        try {
            return TypeConvertor.convertToDouble(s);
        }
        catch (conversionError e) {
            return errval;
        }
    }

    public static float convertToFloat(String s) throws conversionError {
        float result = 0.0f;
        if (s != null) {
            try {
                result = Float.parseFloat(s);
            }
            catch (NumberFormatException e) {
                throw new conversionError("couldn't convert " + s + " to a double");
            }
        }
        return result;
    }

    public static float convertToFloat(String s, float errval) {
        try {
            return TypeConvertor.convertToFloat(s);
        }
        catch (conversionError e) {
            return errval;
        }
    }

    public static char convertToCharacter(String s) throws conversionError {
        if (s == null || s.length() != 1) {
            throw new conversionError("Expected a string with length 1.");
        }
        return s.charAt(0);
    }

    public static float convertToCharacter(String s, char errval) {
        try {
            return TypeConvertor.convertToCharacter(s);
        }
        catch (conversionError e) {
            return errval;
        }
    }

    public static Date convertToDate(String s) {
        for (String fmt : parsers) {
            SimpleDateFormat sdf = new SimpleDateFormat(fmt);
            try {
                return sdf.parse(s);
            }
            catch (ParseException parseException) {
            }
        }
        return null;
    }

    public static String dateToIso8601(Date d) {
        return TypeConvertor.dateToIso8601(d.getTime());
    }

    public static String dateToIso8601(long ms) {
        return Instant.ofEpochMilli(ms).toString();
    }

    public static long iso8601ToEpochMs(String dt) throws ParseException {
        TimeZone utc = TimeZone.getTimeZone("UTC");
        for (String format : new String[]{"yyyy-MM-dd'T'HH:mm:ss.SSS'Z'"}) {
            try {
                SimpleDateFormat sdf = new SimpleDateFormat(format);
                sdf.setTimeZone(utc);
                Date d = sdf.parse(dt);
                return d.getTime();
            }
            catch (ParseException parseException) {
            }
        }
        throw new ParseException("Unrecognized 8601 format.", 0);
    }

    public static byte[] convert(int[] bytes) throws conversionError {
        int index = 0;
        byte[] result = new byte[bytes.length];
        for (int i : bytes) {
            if (i < 0 || i > 255) {
                throw new conversionError("In conversion to byte[], int[] contains value " + i);
            }
            result[index++] = (byte)i;
        }
        return result;
    }

    public static int[] convert(byte[] bytes) {
        int index = 0;
        int[] result = new int[bytes.length];
        for (int n : bytes) {
            result[index++] = n < 0 ? n + 256 : n;
        }
        return result;
    }

    public static String convertToString(int[] bytes, int offset, int length) throws conversionError {
        StringBuffer sb = new StringBuffer();
        for (int i = offset; i < offset + length; ++i) {
            int c = bytes[i];
            if (c < 0 || c > 255) {
                throw new conversionError("Byte array encoded as int[] contains value " + c + ", which is out of range.");
            }
            int topNibble = c >>> 4;
            int bottomNibble = c & 0xF;
            sb.append(TypeConvertor.nibbleToChar(topNibble));
            sb.append(TypeConvertor.nibbleToChar(bottomNibble));
        }
        return sb.toString();
    }

    public static char nibbleToChar(int c) throws conversionError {
        if (c < 0 || c > 15) {
            throw new conversionError("Value " + c + " is not a valid nibble value.");
        }
        if (c < 10) {
            return (char)(48 + c);
        }
        return (char)(65 + c - 10);
    }

    public static int charToNibble(char c) throws conversionError {
        char d = Character.toLowerCase(c);
        if (d >= '0' && d <= '9') {
            return d - 48;
        }
        if (d >= 'a' && d <= 'f') {
            return d - 97 + 10;
        }
        throw new conversionError("Character [" + c + "] is not a valid nibble.");
    }

    public static int[] convertToByteArray(String s) throws conversionError {
        int len = s.length();
        if (len % 2 != 0) {
            throw new conversionError("When converting to byte[], input string must be even length.");
        }
        int[] buffer = new int[len / 2];
        int index = 0;
        for (int i = 0; i < len; i += 2) {
            char top = s.charAt(i);
            char bottom = s.charAt(i + 1);
            buffer[index++] = TypeConvertor.charToNibble(top) * 16 + TypeConvertor.charToNibble(bottom);
        }
        return buffer;
    }

    public static int[] convertToByteArray(String s, int[] errval) {
        try {
            return TypeConvertor.convertToByteArray(s);
        }
        catch (conversionError e) {
            return errval;
        }
    }

    public static byte[] hexToBytes(String s) throws conversionError {
        return TypeConvertor.convert(TypeConvertor.convertToByteArray(s));
    }

    public static String byteToHex(byte b) {
        StringBuffer sb = new StringBuffer();
        sb.append(TypeConvertor.nibbleToHex((b & 0xF0) >> 4));
        sb.append(TypeConvertor.nibbleToHex(b & 0xF));
        return sb.toString();
    }

    public static String byteToHex(int i) {
        return TypeConvertor.byteToHex((byte)(i & 0xFF));
    }

    public static String bytesToHex(byte[] bb) {
        return TypeConvertor.bytesToHex(bb, 0, bb.length);
    }

    public static String bytesToHex(byte[] bb, int offset, int length) {
        StringBuffer sb = new StringBuffer();
        int total = offset + length;
        for (int i = offset; i < total; ++i) {
            byte b = bb[i];
            sb.append(TypeConvertor.nibbleToHex((b & 0xF0) >> 4));
            sb.append(TypeConvertor.nibbleToHex(b & 0xF));
        }
        return sb.toString();
    }

    public static String stringToHex(String s) {
        return TypeConvertor.bytesToHex(s.getBytes());
    }

    public static String hexBytesToString(String s) throws conversionError {
        byte[] bytes = TypeConvertor.hexToBytes(s);
        return new String(bytes);
    }

    public static String urlEncode(String s) {
        if (s == null) {
            return null;
        }
        try {
            return URLEncoder.encode(s, "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException(e);
        }
    }

    public static String urlDecode(String s) {
        if (s == null) {
            return null;
        }
        try {
            return URLDecoder.decode(s, "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException(e);
        }
    }

    public static String requoteHtmlInputValue(String s) {
        return s.replaceAll("\"", "&quot;");
    }

    private static char nibbleToHex(int c) {
        int result = c + 48;
        if (c > 9) {
            result = c - 10 + 65;
        }
        return (char)result;
    }

    public static String encode(String source, char special) {
        return TypeConvertor.encode(source, special, new char[0], new char[0]);
    }

    public static String encode(String source, char special, char[] illegals, char[] replacements) {
        String illStr = new String(illegals);
        StringBuffer sb = new StringBuffer();
        for (char c : source.toCharArray()) {
            if (c == special) {
                sb.append(special);
                sb.append(special);
                continue;
            }
            int pos = illStr.indexOf(c);
            if (pos == -1) {
                sb.append(c);
                continue;
            }
            sb.append(special);
            sb.append(replacements[pos]);
        }
        return sb.toString();
    }

    public static String csvEncodeString(String value) {
        return TypeConvertor.csvEncodeString(value, false);
    }

    public static String csvEncodeString(String value, boolean forceQuote) {
        return CsvEncoder.encodeForCsv(value, forceQuote);
    }

    public static String decode(String encoded, char special) {
        return TypeConvertor.decode(encoded, special, new char[0], new char[0]);
    }

    public static String decode(String encoded, char special, char[] illegals, char[] replacements) {
        String repStr = new String(replacements);
        StringBuffer sb = new StringBuffer();
        char[] chars = encoded.toCharArray();
        for (int i = 0; i < chars.length; ++i) {
            if (chars[i] == special && i + 1 < chars.length) {
                if (chars[i + 1] == special) {
                    sb.append(special);
                    ++i;
                    continue;
                }
                int pos = repStr.indexOf(chars[i + 1]);
                if (pos == -1) continue;
                sb.append(illegals[pos]);
                ++i;
                continue;
            }
            sb.append(chars[i]);
        }
        return sb.toString();
    }

    public static String base64Encode(String in) {
        try {
            return TypeConvertor.base64Encode(in.getBytes("UTF-8"));
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException("Missing UTF-8 encoding in Java installation??");
        }
    }

    public static String base64Encode(byte[] in) {
        return TypeConvertor.base64Encode(in, -1);
    }

    public static String base64Encode(byte[] in, int maxPerLine) {
        try {
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            Base64OutputStream os = new Base64OutputStream(baos, maxPerLine);
            os.write(in);
            os.close();
            byte[] textBytes = baos.toByteArray();
            return new String(textBytes);
        }
        catch (IOException e) {
            throw new RuntimeException("Error writing bytes to byte stream. " + e.getMessage());
        }
    }

    public static String base64UrlEncode(String in) {
        try {
            return TypeConvertor.base64UrlEncode(in.getBytes("UTF-8"));
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException("Missing UTF-8 encoding in Java installation??");
        }
    }

    public static String base64UrlEncode(byte[] in) {
        String encoding = TypeConvertor.base64Encode(in, Integer.MAX_VALUE);
        encoding = encoding.split("=")[0];
        encoding = encoding.replace("+", "-");
        encoding = encoding.replace("/", "_");
        return encoding;
    }

    public static byte[] base64Decode(String in) {
        try {
            ByteArrayInputStream sis = new ByteArrayInputStream(in.getBytes("UTF-8"));
            Base64InputStream is = new Base64InputStream(sis);
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            byte[] bytes = new byte[1024];
            int len = 0;
            while (-1 != (len = is.read(bytes))) {
                baos.write(bytes, 0, len);
            }
            baos.close();
            is.close();
            return baos.toByteArray();
        }
        catch (IOException e) {
            throw new RuntimeException("Error writing bytes to byte stream. " + e.getMessage());
        }
    }

    public static byte[] base64UrlDecode(String in) {
        in = in.replace("_", "/");
        in = in.replace("-", "+");
        switch (in.length() % 4) {
            case 0: {
                break;
            }
            case 2: {
                in = in + "==";
                break;
            }
            case 3: {
                in = in + "=";
                break;
            }
            default: {
                throw new IllegalArgumentException("Illegal base64url string");
            }
        }
        return TypeConvertor.base64Decode(in);
    }

    public static String bytesToHexString(byte[] bytes) {
        StringBuffer sb = new StringBuffer();
        for (byte b : bytes) {
            String bstr = Integer.toHexString(b & 0xFF);
            if (bstr.length() < 2) {
                sb.append("0");
            }
            sb.append(bstr);
        }
        return sb.toString();
    }

    public static byte[] hexStringToBytes(String key) {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        while (key.length() > 0) {
            String part = key.substring(0, 2);
            key = key.substring(2);
            int partValue = Integer.parseInt(part, 16);
            baos.write(partValue);
        }
        return baos.toByteArray();
    }

    public static class conversionError
    extends Exception {
        private static final long serialVersionUID = 1L;

        public conversionError(String msg) {
            super(msg);
        }
    }
}

