/*
 * Decompiled with CFR 0.152.
 */
package io.continual.util.data.base64;

import io.continual.util.data.base64.Base64Constants;
import java.io.IOException;
import java.io.InputStream;
import java.util.LinkedList;

public class Base64InputStream
extends InputStream {
    private final LinkedList<Byte> fPendingOutput;
    private final InputStream fUpstream;
    private boolean fEndOfStream;

    public Base64InputStream(InputStream upstream) {
        this.fUpstream = upstream;
        this.fPendingOutput = new LinkedList();
        this.fEndOfStream = false;
    }

    @Override
    public int available() throws IOException {
        this.fillBuffer();
        return this.fPendingOutput.size();
    }

    @Override
    public int read() throws IOException {
        int result = -1;
        this.fillBuffer();
        if (this.fPendingOutput.size() > 0) {
            result = this.fPendingOutput.remove().byteValue();
            if (result < 0) {
                result += 256;
            }
        } else if (!this.fEndOfStream) {
            result = 0;
        }
        return result;
    }

    private byte[] decode(char[] in) {
        int iLen = in.length;
        if (iLen % 4 != 0) {
            throw new IllegalArgumentException("Length of Base64 encoded input string is not a multiple of 4.");
        }
        while (iLen > 0 && in[iLen - 1] == '=') {
            --iLen;
        }
        int oLen = iLen * 3 / 4;
        byte[] out = new byte[oLen];
        int ip = 0;
        int op = 0;
        while (ip < iLen) {
            int i3;
            char i0 = in[ip++];
            char i1 = in[ip++];
            int i2 = ip < iLen ? in[ip++] : 65;
            int n = i3 = ip < iLen ? in[ip++] : 65;
            if (i0 > '\u007f' || i1 > '\u007f' || i2 > 127 || i3 > 127) {
                throw new IllegalArgumentException("Illegal character in Base64 encoded data.");
            }
            byte b0 = Base64Constants.b64ToNibbles[i0];
            byte b1 = Base64Constants.b64ToNibbles[i1];
            byte b2 = Base64Constants.b64ToNibbles[i2];
            byte b3 = Base64Constants.b64ToNibbles[i3];
            if (b0 < 0 || b1 < 0 || b2 < 0 || b3 < 0) {
                throw new IllegalArgumentException("Illegal character in Base64 encoded data.");
            }
            int o0 = b0 << 2 | b1 >>> 4;
            int o1 = (b1 & 0xF) << 4 | b2 >>> 2;
            int o2 = (b2 & 3) << 6 | b3;
            out[op++] = (byte)o0;
            if (op < oLen) {
                out[op++] = (byte)o1;
            }
            if (op >= oLen) continue;
            out[op++] = (byte)o2;
        }
        return out;
    }

    private void fillBuffer() throws IOException {
        if (this.fPendingOutput.size() == 0) {
            int first = this.fUpstream.read();
            while (first == 10) {
                first = this.fUpstream.read();
            }
            if (first == -1) {
                this.fEndOfStream = true;
            } else {
                byte[] decoded;
                byte[] next3 = new byte[3];
                int readFromNext3 = this.fUpstream.read(next3);
                if (readFromNext3 != 3) {
                    throw new IOException("Base64InputStream expects 4 bytes from its underlying stream but got " + (1 + readFromNext3));
                }
                char[] block = new char[4];
                block[0] = (char)first;
                for (int i = 0; i < 3; ++i) {
                    block[i + 1] = (char)next3[i];
                }
                for (byte b : decoded = this.decode(block)) {
                    this.fPendingOutput.add(b);
                }
            }
        }
    }
}

