/*
 * Decompiled with CFR 0.152.
 */
package io.continual.services.model.core.updaters;

import io.continual.iam.access.AccessControlEntry;
import io.continual.iam.access.AccessControlList;
import io.continual.services.model.core.ModelObject;
import io.continual.services.model.core.ModelOperation;
import io.continual.services.model.core.ModelRequestContext;
import io.continual.services.model.core.ModelUpdater;

public class AclUpdate
implements ModelUpdater {
    private final AccessControlList fAcl;
    private final boolean fForce;

    public AclUpdate(AccessControlList acl) {
        this(acl, false);
    }

    public AclUpdate(AccessControlList acl, boolean force) {
        this.fAcl = acl;
        this.fForce = force;
    }

    @Override
    public ModelOperation[] getAccessRequired() {
        ModelOperation[] modelOperationArray;
        if (this.fForce) {
            modelOperationArray = new ModelOperation[]{};
        } else {
            ModelOperation[] modelOperationArray2 = new ModelOperation[1];
            modelOperationArray = modelOperationArray2;
            modelOperationArray2[0] = ModelOperation.ACL_UPDATE;
        }
        return modelOperationArray;
    }

    @Override
    public void update(ModelRequestContext context, ModelObject o) {
        if (this.fAcl != null) {
            AccessControlList targetAcl = o.getAccessControlList();
            targetAcl.clear();
            targetAcl.setOwner(this.fAcl.getOwner());
            for (AccessControlEntry e : this.fAcl.getEntries()) {
                targetAcl.addAclEntry(e);
            }
        }
    }
}

