/*
 * Decompiled with CFR 0.152.
 */
package io.continual.services.model.impl.files;

import io.continual.builder.Builder;
import io.continual.iam.access.AccessControlList;
import io.continual.services.ServiceContainer;
import io.continual.services.model.core.Model;
import io.continual.services.model.core.ModelObject;
import io.continual.services.model.core.ModelObjectComparator;
import io.continual.services.model.core.ModelObjectList;
import io.continual.services.model.core.ModelOperation;
import io.continual.services.model.core.ModelPathList;
import io.continual.services.model.core.ModelRelation;
import io.continual.services.model.core.ModelRequestContext;
import io.continual.services.model.core.exceptions.ModelItemDoesNotExistException;
import io.continual.services.model.core.exceptions.ModelRequestException;
import io.continual.services.model.core.exceptions.ModelServiceException;
import io.continual.services.model.impl.common.BasicModelRequestContextBuilder;
import io.continual.services.model.impl.common.SimpleModelQuery;
import io.continual.services.model.impl.files.FileSysRelnMgr;
import io.continual.services.model.impl.json.CommonJsonDbModel;
import io.continual.services.model.impl.json.CommonJsonDbObject;
import io.continual.services.model.impl.json.CommonJsonDbObjectContainer;
import io.continual.util.data.json.CommentedJsonTokener;
import io.continual.util.naming.Name;
import io.continual.util.naming.Path;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import org.json.JSONException;
import org.json.JSONObject;
import org.json.JSONTokener;

public class FileSystemModel
extends CommonJsonDbModel {
    private static final String kOldDataTag = "\u24ca";
    private final File fBaseDir;
    private final FileSysRelnMgr fRelnMgr;
    private static final String kRelnsDir = "relations";
    private static final Charset kUtf8 = Charset.forName("UTF8");

    public FileSystemModel(String acctId, String modelId, String baseDir) throws Builder.BuildFailure {
        super(acctId, modelId);
        this.fBaseDir = new File(baseDir);
        this.fRelnMgr = new FileSysRelnMgr(new File(this.fBaseDir, kRelnsDir));
    }

    public FileSystemModel(String acctId, String modelId, File baseDir) throws Builder.BuildFailure {
        this(acctId, modelId, baseDir.getAbsolutePath());
    }

    public FileSystemModel(ServiceContainer sc, JSONObject config) throws Builder.BuildFailure {
        this(sc.getExprEval(config).evaluateText(config.getString("acctId")), sc.getExprEval(config).evaluateText(config.getString("modelId")), sc.getExprEval(config).evaluateText(config.getString("baseDir")));
    }

    @Override
    public long getMaxPathLength() {
        return 8160L;
    }

    @Override
    public long getMaxRelnNameLength() {
        return 255L;
    }

    @Override
    public long getMaxSerializedObjectLength() {
        return 0xFFFFFFFFL;
    }

    @Override
    public Model.ModelRequestContextBuilder getRequestContextBuilder() {
        return new BasicModelRequestContextBuilder();
    }

    @Override
    public ModelPathList listObjectsStartingWith(ModelRequestContext context, Path prefix) throws ModelServiceException, ModelRequestException {
        final LinkedList<Path> result = new LinkedList<Path>();
        File objDir = this.getObjectDir();
        File container = this.pathToDir(objDir, prefix);
        if (!container.isDirectory()) {
            if (container.equals(objDir)) {
                return ModelPathList.wrap(new LinkedList<Path>());
            }
            return null;
        }
        for (File obj : container.listFiles()) {
            if (!obj.isFile()) continue;
            result.add(prefix.makeChildItem(Name.fromString((String)obj.getName())));
        }
        return new ModelPathList(){

            @Override
            public Iterator<Path> iterator() {
                return result.iterator();
            }
        };
    }

    @Override
    public FsModelQuery startQuery() {
        return new FsModelQuery();
    }

    @Override
    public void relate(ModelRequestContext context, ModelRelation reln) throws ModelServiceException, ModelRequestException {
        this.fRelnMgr.relate(reln);
    }

    @Override
    public boolean unrelate(ModelRequestContext context, ModelRelation reln) throws ModelServiceException, ModelRequestException {
        return this.fRelnMgr.unrelate(reln);
    }

    @Override
    public List<ModelRelation> getInboundRelations(ModelRequestContext context, Path forObject) throws ModelServiceException, ModelRequestException {
        return this.fRelnMgr.getInboundRelations(forObject);
    }

    @Override
    public List<ModelRelation> getOutboundRelations(ModelRequestContext context, Path forObject) throws ModelServiceException, ModelRequestException {
        return this.fRelnMgr.getOutboundRelations(forObject);
    }

    @Override
    public List<ModelRelation> getInboundRelationsNamed(ModelRequestContext context, Path forObject, String named) throws ModelServiceException, ModelRequestException {
        return this.fRelnMgr.getInboundRelationsNamed(forObject, named);
    }

    @Override
    public List<ModelRelation> getOutboundRelationsNamed(ModelRequestContext context, Path forObject, String named) throws ModelServiceException, ModelRequestException {
        return this.fRelnMgr.getOutboundRelationsNamed(forObject, named);
    }

    private File getFileFor(Path mop) {
        return new File(this.getObjectDir(), mop.toString());
    }

    @Override
    protected ModelObject loadObject(ModelRequestContext context, Path objectPath) throws ModelServiceException, ModelRequestException {
        File obj = this.getFileFor(objectPath);
        if (obj.isFile()) {
            AccessControlList acl;
            boolean oldModel;
            JSONObject rawData;
            try (FileInputStream fis = new FileInputStream(obj);){
                rawData = new JSONObject((JSONTokener)new CommentedJsonTokener((InputStream)fis));
            }
            catch (JSONException x) {
                throw new ModelRequestException("The object data is corrupt.");
            }
            catch (IOException x) {
                throw new ModelServiceException(x);
            }
            JSONObject inner = rawData.optJSONObject(kOldDataTag);
            boolean bl = oldModel = inner != null;
            if (oldModel) {
                rawData.remove(kOldDataTag);
                rawData.put("data", (Object)inner);
            }
            CommonJsonDbObject loadedObj = new CommonJsonDbObject(objectPath.toString(), rawData);
            if (oldModel && (acl = loadedObj.getAccessControlList()).getEntries().size() == 0) {
                acl.setOwner("_updated_").permit("*", ModelOperation.kAllOperationStrings);
            }
            return loadedObj;
        }
        if (obj.isDirectory()) {
            LinkedList<Path> result = new LinkedList<Path>();
            for (String child : obj.list()) {
                result.add(Path.getRootPath().makeChildItem(Name.fromString((String)child)));
            }
            return CommonJsonDbObjectContainer.createObjectContainer(objectPath.toString(), result);
        }
        if (objectPath.isRootPath()) {
            return CommonJsonDbObjectContainer.createObjectContainer(objectPath.toString(), new LinkedList<Path>());
        }
        if (!obj.exists()) {
            throw new ModelItemDoesNotExistException(objectPath);
        }
        throw new ModelServiceException("Path is corrupt: " + objectPath.toString());
    }

    @Override
    protected void internalStore(ModelRequestContext context, Path objectPath, ModelObject o) throws ModelRequestException, ModelServiceException {
        File obj = this.getFileFor(objectPath);
        if (obj.exists() && !obj.isFile()) {
            throw new ModelRequestException(objectPath.toString() + " exists as a container.");
        }
        File parentDir = obj.getParentFile();
        if (parentDir.exists() && !parentDir.isDirectory()) {
            throw new ModelRequestException("Parent " + objectPath.getParentPath().toString() + " is an object.");
        }
        if (!parentDir.exists() && !parentDir.mkdirs()) {
            throw new ModelRequestException(objectPath.toString() + " parent path unavailable.");
        }
        try (FileOutputStream fos = new FileOutputStream(obj);){
            fos.write(o.toJson().toString().getBytes(kUtf8));
        }
        catch (IOException x) {
            throw new ModelServiceException(x);
        }
    }

    @Override
    protected boolean internalRemove(ModelRequestContext context, Path objectPath) throws ModelRequestException, ModelServiceException {
        File obj = this.getFileFor(objectPath);
        if (!obj.exists()) {
            return false;
        }
        if (obj.exists() && !obj.isFile()) {
            throw new ModelRequestException(objectPath.toString() + " exists as a container.");
        }
        return obj.delete();
    }

    private File getObjectDir() {
        return new File(this.fBaseDir, "objects");
    }

    private File pathToDir(File base, Path p) {
        if (p.isRootPath()) {
            return base;
        }
        return new File(this.pathToDir(base, p.getParentPath()), p.getItemName().toString());
    }

    private class FsModelQuery
    extends SimpleModelQuery {
        private FsModelQuery() {
        }

        private List<Path> collectObjectsUnder(File dir, Path pathPrefix) {
            LinkedList<Path> result = new LinkedList<Path>();
            for (File f : dir.listFiles()) {
                String namePart = f.getName();
                Path p = pathPrefix.makeChildItem(Name.fromString((String)namePart));
                if (f.isFile()) {
                    result.add(p);
                    continue;
                }
                if (!f.isDirectory()) continue;
                result.addAll(this.collectObjectsUnder(f, p));
            }
            return result;
        }

        @Override
        public ModelObjectList execute(ModelRequestContext context) throws ModelRequestException, ModelServiceException {
            long startIndex;
            ModelObjectComparator orderBy;
            final LinkedList<ModelObject> result = new LinkedList<ModelObject>();
            File objDir = FileSystemModel.this.getObjectDir();
            File container = FileSystemModel.this.pathToDir(objDir, this.getPathPrefix());
            if (container.isDirectory()) {
                for (Path p : this.collectObjectsUnder(container, this.getPathPrefix())) {
                    ModelObject mo = FileSystemModel.this.load(context, p);
                    if (mo == null) continue;
                    boolean match = true;
                    for (SimpleModelQuery.Filter filter : this.getFilters()) {
                        if (filter.matches(mo)) continue;
                        match = false;
                        break;
                    }
                    if (!match) continue;
                    result.add(mo);
                }
            }
            if ((orderBy = this.getOrdering()) != null) {
                Collections.sort(result, new Comparator<ModelObject>(){

                    @Override
                    public int compare(ModelObject o1, ModelObject o2) {
                        return orderBy.compare(o1, o2);
                    }
                });
            }
            long toDump = startIndex = (long)this.getPageSize() * (long)this.getPageNumber();
            while (toDump > 0L && result.size() > 0) {
                result.removeFirst();
            }
            while (result.size() > this.getPageSize()) {
                result.removeLast();
            }
            return new ModelObjectList(){

                @Override
                public Iterator<ModelObject> iterator() {
                    return result.iterator();
                }
            };
        }
    }
}

