/*
 * Decompiled with CFR 0.152.
 */
package io.continual.services.model.impl.json;

import io.continual.iam.access.AccessControlList;
import io.continual.iam.access.AclUpdateListener;
import io.continual.services.model.core.ModelObject;
import io.continual.services.model.core.ModelObjectMetadata;
import io.continual.util.data.json.JsonUtil;
import io.continual.util.data.json.JsonVisitor;
import io.continual.util.time.Clock;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;
import java.util.UUID;
import org.json.JSONArray;
import org.json.JSONObject;

public class CommonJsonDbObject
implements ModelObject,
AclUpdateListener {
    private final String fId;
    private final AccessControlList fAcl;
    private final JSONObject fRaw;
    public static final String kDataTag = "data";
    public static final String kMetaTag = "meta";
    public static final String kMeta_AclTag = "acl";
    public static final String kMeta_CreateTs = "createMs";
    public static final String kMeta_UpdateTs = "updateMs";
    public static final String kMeta_LockedTypes = "types";

    public CommonJsonDbObject() {
        this(null, new JSONObject());
    }

    public CommonJsonDbObject(String id, JSONObject rawData) {
        this.fId = id;
        this.fRaw = rawData;
        JSONObject meta = this.getMeta();
        this.fAcl = AccessControlList.deserialize((JSONObject)meta.optJSONObject(kMeta_AclTag), (AclUpdateListener)this);
    }

    public String getId() {
        return this.fId;
    }

    public AccessControlList getAccessControlList() {
        return this.fAcl;
    }

    public void onAclUpdate(AccessControlList acl) {
        if (acl != this.fAcl) {
            throw new IllegalArgumentException("ACL update notification from wrong ACL.");
        }
        this.getMeta().put(kMeta_AclTag, (Object)this.fAcl.asJson());
    }

    public JSONObject toJson() {
        return JsonUtil.clone((JSONObject)this.fRaw);
    }

    @Override
    public ModelObjectMetadata getMetadata() {
        return new ModelObjectMetadata(){

            @Override
            public Set<String> getLockedTypes() {
                JSONArray types;
                TreeSet<String> result = new TreeSet<String>();
                JSONObject meta = CommonJsonDbObject.this.fRaw.optJSONObject(CommonJsonDbObject.kMetaTag);
                if (meta != null && (types = meta.optJSONArray(CommonJsonDbObject.kMeta_LockedTypes)) != null) {
                    List typeList = JsonVisitor.arrayToList((JSONArray)types);
                    result.addAll(typeList);
                }
                return result;
            }

            @Override
            public long getCreateTimeMs() {
                JSONObject meta = CommonJsonDbObject.this.fRaw.optJSONObject(CommonJsonDbObject.kMetaTag);
                return meta == null ? -1L : meta.optLong(CommonJsonDbObject.kMeta_CreateTs, -1L);
            }

            @Override
            public long getLastUpdateTimeMs() {
                JSONObject meta = CommonJsonDbObject.this.fRaw.optJSONObject(CommonJsonDbObject.kMetaTag);
                return meta == null ? -1L : meta.optLong(CommonJsonDbObject.kMeta_UpdateTs, -1L);
            }

            public JSONObject toJson() {
                return JsonUtil.clone((JSONObject)CommonJsonDbObject.this.getMeta());
            }

            @Override
            public AccessControlList getAccessControlList() {
                return CommonJsonDbObject.this.fAcl;
            }
        };
    }

    @Override
    public JSONObject getData() {
        JSONObject data = this.fRaw.optJSONObject(kDataTag);
        return data == null ? new JSONObject() : JsonUtil.clone((JSONObject)data);
    }

    @Override
    public void putData(JSONObject data) {
        this.fRaw.put(kDataTag, (Object)JsonUtil.clone((JSONObject)data));
        this.getMeta().put(kMeta_UpdateTs, Clock.now());
    }

    @Override
    public void patchData(JSONObject data) {
        JSONObject existing = this.getData();
        JsonUtil.copyInto((JSONObject)data, (JSONObject)existing);
        this.putData(existing);
    }

    private JSONObject getMeta() {
        JSONObject meta = this.fRaw.optJSONObject(kMetaTag);
        if (meta == null) {
            meta = new JSONObject().put(kMeta_CreateTs, Clock.now());
            this.fRaw.put(kMetaTag, (Object)meta);
        }
        return meta;
    }

    public static class Builder<T extends CommonJsonDbObject> {
        private String fId = null;
        private JSONObject fRawData = new JSONObject();
        private Constructor<T> fConstructor = new Constructor<T>(){

            @Override
            public T construct(String id, JSONObject rawData) {
                return new CommonJsonDbObject(id, rawData);
            }
        };

        public Builder<T> withId(String id) {
            this.fId = id;
            return this;
        }

        public Builder<T> withData(JSONObject newData, boolean merge) {
            JSONObject data = this.fRawData.optJSONObject(CommonJsonDbObject.kDataTag);
            if (merge) {
                if (data == null) {
                    data = new JSONObject();
                    this.fRawData.put(CommonJsonDbObject.kDataTag, (Object)data);
                }
                JsonUtil.overlay((JSONObject)data, (JSONObject)newData);
            } else {
                this.fRawData.put(CommonJsonDbObject.kDataTag, (Object)JsonUtil.clone((JSONObject)newData));
            }
            return this;
        }

        public Builder<T> withAcl(AccessControlList acl) {
            this.getMetaBlock().put(CommonJsonDbObject.kMeta_AclTag, (Object)acl.asJson());
            return this;
        }

        public Builder<T> withType(String type) {
            JSONObject data = this.getMetaBlock();
            JSONArray types = data.optJSONArray(CommonJsonDbObject.kMeta_LockedTypes);
            if (types == null) {
                types = new JSONArray();
                data.put(CommonJsonDbObject.kMeta_LockedTypes, (Object)types);
            }
            types.put((Object)type);
            return this;
        }

        public Builder<T> withCreateTimestampMs(long createTimeMs) {
            JSONObject data = this.getMetaBlock();
            data.put(CommonJsonDbObject.kMeta_CreateTs, createTimeMs);
            return this;
        }

        public Builder<T> withUpdateTimestampMs(long updateTimeMs) {
            JSONObject data = this.getMetaBlock();
            data.put(CommonJsonDbObject.kMeta_UpdateTs, updateTimeMs);
            return this;
        }

        public Builder<T> constructUsing(Constructor<T> cc) {
            this.fConstructor = cc;
            return this;
        }

        public T build() {
            if (this.fId == null) {
                this.fId = UUID.randomUUID().toString();
            }
            return this.fConstructor.construct(this.fId, this.fRawData);
        }

        private JSONObject getMetaBlock() {
            JSONObject metadata = this.fRawData.optJSONObject(CommonJsonDbObject.kMetaTag);
            if (metadata == null) {
                metadata = new JSONObject();
                this.fRawData.put(CommonJsonDbObject.kMetaTag, (Object)metadata);
            }
            return metadata;
        }

        public static interface Constructor<T extends CommonJsonDbObject> {
            public T construct(String var1, JSONObject var2);
        }
    }
}

