/*
 * Decompiled with CFR 0.152.
 */
package io.continual.restHttp;

import io.continual.http.service.framework.context.CHttpRequestContext;
import io.continual.iam.IamAuthLog;
import io.continual.iam.IamServiceManager;
import io.continual.iam.credentials.ApiKeyCredential;
import io.continual.iam.credentials.JwtCredential;
import io.continual.iam.credentials.UsernamePasswordCredential;
import io.continual.iam.exceptions.IamSvcException;
import io.continual.iam.identity.Identity;
import io.continual.iam.impl.common.ApiKeyAuthHelper;
import io.continual.iam.impl.common.BasicAuthHelper;
import io.continual.iam.impl.common.HeaderReader;
import io.continual.restHttp.ApiContextHelper;
import io.continual.util.nv.NvReadable;
import java.util.LinkedList;

public class AuthList<I extends Identity>
implements ApiContextHelper.Authenticator<I> {
    public static final String kSetting_ContinualProductTag = "apiKeyProductTag";
    public static final String kContinualProductTag = "continual";
    private final LinkedList<ApiContextHelper.Authenticator<I>> fAuthenticators = new LinkedList();

    public AuthList() {
        this.addAuthenticator(new ApiContextHelper.Authenticator<I>(){

            @Override
            public I authenticate(IamServiceManager<I, ?> am, CHttpRequestContext context) throws IamSvcException {
                NvReadable ds = context.systemSettings();
                String systag = ds.getString(AuthList.kSetting_ContinualProductTag, AuthList.kContinualProductTag);
                Identity authUser = null;
                ApiKeyCredential creds = ApiKeyAuthHelper.readApiKeyCredential((NvReadable)ds, (HeaderReader)new ApiContextHelper.LocalHeaderReader(context), (String)systag);
                if (creds != null && (authUser = am.getIdentityDb().authenticate(creds)) != null) {
                    IamAuthLog.authenticationEvent((String)authUser.getId(), (String)"API Key", (String)context.request().getBestRemoteAddress());
                }
                return authUser;
            }
        });
        this.addAuthenticator(new ApiContextHelper.Authenticator<I>(){

            @Override
            public I authenticate(IamServiceManager<I, ?> am, CHttpRequestContext context) throws IamSvcException {
                Identity authUser = null;
                try {
                    String queryParam;
                    String[] parts;
                    JwtCredential cred = null;
                    String authHeader = context.request().getFirstHeader("Authorization");
                    if (authHeader != null && authHeader.startsWith("Bearer ") && (parts = authHeader.split(" ")).length == 2) {
                        cred = JwtCredential.fromHeader((String)authHeader);
                    }
                    if (cred == null && (queryParam = context.request().getParameter("jwt", null)) != null) {
                        cred = new JwtCredential(queryParam);
                    }
                    if (cred != null && (authUser = am.getIdentityDb().authenticate(cred)) != null) {
                        IamAuthLog.authenticationEvent((String)authUser.getId(), (String)"JWT", (String)context.request().getBestRemoteAddress());
                    }
                }
                catch (JwtCredential.InvalidJwtToken invalidJwtToken) {
                    // empty catch block
                }
                return authUser;
            }
        });
        this.addAuthenticator(new ApiContextHelper.Authenticator<I>(){

            @Override
            public I authenticate(IamServiceManager<I, ?> am, CHttpRequestContext context) throws IamSvcException {
                NvReadable ds = context.systemSettings();
                Identity authUser = null;
                UsernamePasswordCredential upc = BasicAuthHelper.readUsernamePasswordCredential((NvReadable)ds, (HeaderReader)new ApiContextHelper.LocalHeaderReader(context));
                if (upc != null && (authUser = am.getIdentityDb().authenticate(upc)) != null) {
                    IamAuthLog.authenticationEvent((String)authUser.getId(), (String)"Username/Password", (String)context.request().getBestRemoteAddress());
                }
                return authUser;
            }
        });
    }

    public synchronized AuthList<I> addAuthenticator(ApiContextHelper.Authenticator<I> a) {
        this.fAuthenticators.add(a);
        return this;
    }

    @Override
    public synchronized I authenticate(IamServiceManager<I, ?> am, CHttpRequestContext context) throws IamSvcException {
        for (ApiContextHelper.Authenticator authenticator : this.fAuthenticators) {
            I result = authenticator.authenticate(am, context);
            if (result == null) continue;
            return result;
        }
        return null;
    }
}

