/*
 * Decompiled with CFR 0.152.
 */
package io.continual.restHttp;

import io.continual.http.service.framework.CHttpErrorHandler;
import io.continual.http.service.framework.context.CHttpRequestContext;
import io.continual.http.service.framework.routing.CHttpRequestRouter;
import io.continual.iam.access.AccessException;
import io.continual.restHttp.HttpRouter;
import io.continual.restHttp.HttpServlet;
import io.continual.util.nv.NvReadable;
import java.io.IOException;
import org.json.JSONException;
import org.json.JSONObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class BaseApiServiceRouter
implements HttpRouter {
    private static final Logger log = LoggerFactory.getLogger(BaseApiServiceRouter.class);

    protected void setupExceptionHandlers(HttpServlet servlet, CHttpRequestRouter rr, NvReadable p) throws IOException {
        rr.setHandlerForException(CHttpRequestRouter.noMatchingRoute.class, new CHttpErrorHandler(){

            public void handle(CHttpRequestContext ctx, Throwable cause) {
                ctx.response().sendErrorAndBody(404, new JSONObject().put("error", 404).put("message", (Object)"Not found. See the API docs.").toString(), "application/json");
            }
        });
        rr.setHandlerForException(JSONException.class, new CHttpErrorHandler(){

            public void handle(CHttpRequestContext ctx, Throwable cause) {
                ctx.response().sendErrorAndBody(400, new JSONObject().put("error", 400).put("message", (Object)"Bad request. See the API docs.").toString(), "application/json");
            }
        });
        rr.setHandlerForException(AccessException.class, new CHttpErrorHandler(){

            public void handle(CHttpRequestContext ctx, Throwable cause) {
                ctx.response().sendErrorAndBody(403, new JSONObject().put("error", 403).put("message", (Object)"Forbidden.").toString(), "application/json");
            }
        });
        rr.setHandlerForException(Throwable.class, new CHttpErrorHandler(){

            public void handle(CHttpRequestContext ctx, Throwable cause) {
                ctx.response().sendErrorAndBody(500, new JSONObject().put("error", 500).put("message", (Object)"There was a problem at the server.").toString(), "application/json");
                log.warn(cause.getMessage(), cause);
            }
        });
    }
}

