/*
 * Decompiled with CFR 0.152.
 */
package io.continual.restHttp;

import io.continual.builder.Builder;
import io.continual.http.service.framework.CHttpErrorHandler;
import io.continual.http.service.framework.context.CHttpRequestContext;
import io.continual.http.service.framework.routing.CHttpRequestRouter;
import io.continual.http.service.framework.routing.CHttpRouteSource;
import io.continual.http.service.framework.routing.playish.CHttpPlayishInstanceCallRoutingSource;
import io.continual.http.service.framework.routing.playish.CHttpPlayishRoutingFileSource;
import io.continual.restHttp.HttpRouter;
import io.continual.restHttp.HttpSessionContextHelper;
import java.io.IOException;
import java.net.URL;
import org.json.JSONObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class TypicalHttpRouter
implements HttpRouter {
    private static final Logger log = LoggerFactory.getLogger(TypicalHttpRouter.class);

    protected void setupTypicalApiRouter(CHttpRequestRouter rr) {
        rr.setHandlerForException(CHttpRequestRouter.noMatchingRoute.class, new CHttpErrorHandler(){

            public void handle(CHttpRequestContext ctx, Throwable cause) {
                ctx.response().sendErrorAndBody(404, new JSONObject().put("error", 404).put("message", (Object)"Not found. See the API docs.").toString(), "application/json");
            }
        });
        rr.setHandlerForException(HttpSessionContextHelper.NoLoginException.class, new CHttpErrorHandler(){

            public void handle(CHttpRequestContext ctx, Throwable cause) {
                ctx.response().sendErrorAndBody(401, new JSONObject().put("error", 401).put("message", (Object)"Check your credentials.").toString(), "application/json");
            }
        });
        rr.setHandlerForException(Throwable.class, new CHttpErrorHandler(){

            public void handle(CHttpRequestContext ctx, Throwable cause) {
                ctx.response().sendErrorAndBody(500, new JSONObject().put("error", 500).put("message", (Object)"There was a problem at the server.").toString(), "application/json");
            }
        });
    }

    protected void setupTypicalUiRouter(CHttpRequestRouter rr) {
        rr.setHandlerForException(CHttpRequestRouter.noMatchingRoute.class, new CHttpErrorHandler(){

            public void handle(CHttpRequestContext ctx, Throwable cause) {
                ctx.response().redirect("/");
            }
        });
        rr.setHandlerForException(HttpSessionContextHelper.NoLoginException.class, new CHttpErrorHandler(){

            public void handle(CHttpRequestContext ctx, Throwable cause) {
                ctx.response().redirect("/");
            }
        });
    }

    public void loadConfigs(CHttpRequestRouter rr, ConfigAndClass<?> ... configs) throws IOException, Builder.BuildFailure {
        for (ConfigAndClass<?> cc : configs) {
            log.debug("Loading routes from " + cc.fConfig);
            URL url = this.getClass().getResource(cc.fConfig);
            if (url != null) {
                if (cc.fHandlerInstance != null) {
                    rr.addRouteSource((CHttpRouteSource)new CHttpPlayishInstanceCallRoutingSource(cc.fHandlerInstance, url));
                    continue;
                }
                rr.addRouteSource((CHttpRouteSource)new CHttpPlayishRoutingFileSource(url));
                continue;
            }
            throw new IOException("Couldn't load resource " + cc.fConfig);
        }
    }

    public class ConfigAndClass<T> {
        public final String fConfig;
        public final T fHandlerInstance;

        public ConfigAndClass(String config, T handlerInstance) {
            this.fConfig = config;
            this.fHandlerInstance = handlerInstance;
        }
    }
}

