/*
 * Decompiled with CFR 0.152.
 */
package io.continual.email.impl;

import io.continual.email.TextService;
import io.continual.services.ServiceContainer;
import io.continual.services.SimpleService;
import io.continual.util.time.Clock;
import java.io.IOException;
import java.util.concurrent.TimeUnit;
import okhttp3.Credentials;
import okhttp3.FormBody;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.RequestBody;
import okhttp3.Response;
import org.json.JSONObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TwilioTextService
extends SimpleService
implements TextService {
    private final OkHttpClient fHttpClient;
    private final String fTwilioUser;
    private final String fTwilioPwd;
    private final String fFrom;
    private static final Logger log = LoggerFactory.getLogger(TwilioTextService.class);
    public static final int k200_ok = 200;
    public static final int k202_accepted = 202;
    public static final int k300_multipleChoices = 300;
    public static final int k400_badRequest = 400;
    public static final int k500_internalServerError = 500;
    public static final int k503_serviceUnavailable = 503;

    public TwilioTextService(ServiceContainer sc, JSONObject config) {
        this.fTwilioUser = config.getString("twilioUser");
        this.fTwilioPwd = config.getString("twilioKey");
        this.fFrom = config.getString("twilioFromNumber");
        OkHttpClient.Builder okb = new OkHttpClient.Builder().connectTimeout(15L, TimeUnit.SECONDS).writeTimeout(15L, TimeUnit.SECONDS).readTimeout(30L, TimeUnit.SECONDS);
        this.fHttpClient = okb.build();
    }

    @Override
    public void sendMessage(TextService.SmsBuilder msg) throws IOException {
        if (!(msg instanceof TwilioSmsBuilder)) {
            throw new IllegalArgumentException("builder is not from here");
        }
        TwilioSmsBuilder builder = (TwilioSmsBuilder)msg;
        String msgUrl = "https://api.twilio.com/2010-04-01/Accounts/" + this.fTwilioUser + "/Messages.json";
        FormBody formBody = new FormBody.Builder().add("To", builder.fTo).add("From", this.fFrom).add("Body", builder.fBody).build();
        Request req = new Request.Builder().url(msgUrl).addHeader("Authorization", Credentials.basic((String)this.fTwilioUser, (String)this.fTwilioPwd)).post((RequestBody)formBody).build();
        log.info("POST {} ({})", (Object)msgUrl, (Object)this.fTwilioUser);
        long trxStartMs = Clock.now();
        try (Response response = this.fHttpClient.newCall(req).execute();){
            long trxEndMs = Clock.now();
            long trxDurationMs = trxEndMs - trxStartMs;
            int statusCode = response.code();
            String statusText = response.message();
            String responseBody = response.body().string();
            log.info("    MR reply {} {} ({} ms): {}", new Object[]{statusCode, statusText, trxDurationMs, responseBody});
            if (TwilioTextService.isSuccess(statusCode)) {
                log.info("Twilio text to {} ok.", (Object)builder.fTo);
            } else if (TwilioTextService.isClientFailure(statusCode) || TwilioTextService.isServerFailure(statusCode)) {
                log.warn("Twilio error response: " + statusCode + ", " + statusText);
            }
        }
        catch (IOException x) {
            long trxEndMs = Clock.now();
            long trxDurationMs = trxEndMs - trxStartMs;
            log.warn("Twilio service error: {} ({} ms)" + x.getMessage(), (Object)trxDurationMs);
        }
    }

    @Override
    public TextService.SmsBuilder createMessage() {
        return new TwilioSmsBuilder();
    }

    public static boolean isSuccess(int code) {
        return code >= 200 && code < 300;
    }

    public static boolean isClientFailure(int code) {
        return code >= 400 && code < 500;
    }

    public static boolean isServerFailure(int code) {
        return code >= 500;
    }

    private static class TwilioSmsBuilder
    implements TextService.SmsBuilder {
        private String fTo;
        private String fBody;

        private TwilioSmsBuilder() {
        }

        @Override
        public TextService.SmsBuilder to(String phoneNumber) {
            this.fTo = phoneNumber;
            return this;
        }

        @Override
        public TextService.SmsBuilder withBody(String body) {
            this.fBody = body;
            return this;
        }
    }
}

