/*
 * Decompiled with CFR 0.152.
 */
package io.continual.email.impl;

import io.continual.email.EmailService;
import io.continual.email.impl.SimpleEmailService;
import io.continual.services.Service;
import io.continual.services.ServiceContainer;
import io.continual.util.console.CmdLineParser;
import io.continual.util.console.CmdLinePrefs;
import io.continual.util.console.ConfiguredConsole;
import io.continual.util.console.ConsoleProgram;
import io.continual.util.nv.NvReadable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import javax.mail.MessagingException;
import org.json.JSONObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EmailTestSender
extends ConfiguredConsole {
    private static final String kTo = "to";
    private static final Logger log = LoggerFactory.getLogger(EmailTestSender.class);

    protected ConfiguredConsole setupOptions(CmdLineParser p) {
        super.setupOptions(p);
        p.registerOptionWithValue(kTo, "t");
        return this;
    }

    protected ConsoleProgram.Looper init(NvReadable p, CmdLinePrefs clp) throws NvReadable.MissingReqdSettingException, NvReadable.InvalidSettingValueException, ConsoleProgram.StartupFailureException {
        String to = clp.getString(kTo);
        if (to == null || to.length() < 1) {
            throw new NvReadable.MissingReqdSettingException(kTo);
        }
        JSONObject config = new JSONObject().put("mailSmtpServer", (Object)"${SMTP_HOST}").put("mailSmtpServerPort", (Object)"${SMTP_PORT}").put("mailSmtpServerUseAuth", (Object)"${SMTP_USEAUTH}").put("mailSmtpServerSsl", (Object)"${SMTP_SSL}").put("mailLogin", (Object)"${SMTP_USERNAME}").put("mailPassword", (Object)"${SMTP_PASSWORD}").put("mailFromEmail", (Object)"${SMTP_FROM_EMAIL}").put("mailFromName", (Object)"${SMTP_FROM_NAME}");
        ServiceContainer sc = new ServiceContainer();
        SimpleEmailService svc = new SimpleEmailService(sc, config);
        try {
            svc.start();
            log.info("Service started.");
            Future<EmailService.MailStatus> status = svc.mail(svc.createMessage().to(to).withSubject("Test Email").withSimpleText("This is a test message from the continual.io SimpleEmailService."));
            log.info("Mail submitted.");
            EmailService.MailStatus ms = status.get(30L, TimeUnit.SECONDS);
            log.info("Mail status: " + EmailTestSender.stringFor(ms));
        }
        catch (Service.FailedToStart | InterruptedException | ExecutionException | TimeoutException | MessagingException e) {
            throw new ConsoleProgram.StartupFailureException((Exception)e);
        }
        finally {
            try {
                log.info("Service stopping.");
                svc.requestFinishAndWait(30L, TimeUnit.SECONDS);
                log.info("Service finished.");
            }
            catch (InterruptedException e) {
                log.warn("Service shutdown wait interrupted.");
            }
        }
        return null;
    }

    private static String stringFor(EmailService.MailStatus ms) {
        if (ms.didSend()) {
            return "sent";
        }
        if (ms.didFail()) {
            String msg = ms.getErrorMsg();
            return msg == null ? "failed" : "failed: " + msg;
        }
        return "unknown";
    }

    public static void main(String[] args) throws InterruptedException {
        try {
            EmailTestSender ets = new EmailTestSender();
            ets.runFromMain(args);
        }
        catch (ConsoleProgram.StartupFailureException | ConsoleProgram.UsageException | NvReadable.InvalidSettingValueException | NvReadable.LoadException | NvReadable.MissingReqdSettingException e) {
            System.err.println(e.getMessage());
        }
    }
}

