/*
 * Decompiled with CFR 0.152.
 */
package io.continual.iam.identity;

import io.continual.iam.identity.Identity;
import io.continual.util.data.json.JsonSerialized;
import org.json.JSONObject;

public class UserContext<I extends Identity>
implements JsonSerialized {
    private final I fIdentity;
    private final I fSponsor;

    public I getUser() {
        return this.fIdentity;
    }

    public Identity getSponsor() {
        return this.fSponsor != null ? this.fSponsor : this.fIdentity;
    }

    public String getEffectiveUserId() {
        return this.getUser().getId();
    }

    public String getActualUserId() {
        return this.getSponsor().getId();
    }

    public String toString() {
        if (this.fSponsor != null) {
            return this.fIdentity.getId() + " (" + this.fSponsor.getId() + ")";
        }
        return this.fIdentity.getId();
    }

    public JSONObject toJson() {
        JSONObject result = new JSONObject().put("identity", (Object)this.fIdentity.getId());
        if (this.fSponsor != null) {
            result.put("sponsor", (Object)this.fSponsor.getId());
        }
        return result;
    }

    private UserContext(I user, I byWhom) {
        this.fIdentity = user;
        this.fSponsor = byWhom != null && !byWhom.getId().equals(user.getId()) ? byWhom : null;
    }

    /* synthetic */ UserContext(Identity x0, Identity x1, 1 x2) {
        this(x0, x1);
    }

    public static class Builder<I extends Identity> {
        private I fForWhom;
        private I fByWhom;

        public Builder<I> forUser(I i) {
            this.fForWhom = i;
            return this;
        }

        public Builder<I> sponsoredByUser(I i) {
            this.fByWhom = i;
            return this;
        }

        public UserContext<I> build() {
            return new UserContext((Identity)this.fForWhom, (Identity)this.fByWhom, null);
        }
    }
}

