/*
 * Decompiled with CFR 0.152.
 */
package io.continual.iam.impl.common;

import io.continual.iam.exceptions.IamSvcException;
import io.continual.iam.identity.UserDataHolder;
import java.util.HashMap;
import java.util.Map;
import org.json.JSONObject;

public abstract class CommonJsonObject
implements UserDataHolder {
    @Override
    public abstract void reload() throws IamSvcException;

    protected void setValue(String name, String val) throws IamSvcException {
        JSONObject o = this.getDataRecord().optJSONObject("aux");
        if (o == null) {
            o = new JSONObject();
            this.getDataRecord().put("aux", (Object)o);
        }
        o.put(name, (Object)val);
        this.store();
    }

    protected String getValue(String name, String defval) {
        JSONObject o = this.getDataRecord().optJSONObject("aux");
        if (o == null) {
            return defval;
        }
        return o.optString(name, defval);
    }

    protected boolean getValue(String name, boolean defval) {
        JSONObject o = this.getDataRecord().optJSONObject("aux");
        if (o == null) {
            return defval;
        }
        return o.optBoolean(name, defval);
    }

    protected void removeValue(String name) throws IamSvcException {
        JSONObject o = this.getDataRecord().optJSONObject("aux");
        if (o != null) {
            o.remove(name);
        }
        this.store();
    }

    @Override
    public String getUserData(String key) throws IamSvcException {
        return this.getValue(key, null);
    }

    @Override
    public void putUserData(String key, String val) throws IamSvcException {
        this.setValue(key, val);
    }

    @Override
    public void removeUserData(String key) throws IamSvcException {
        this.removeValue(key);
    }

    @Override
    public Map<String, String> getAllUserData() throws IamSvcException {
        HashMap<String, String> result = new HashMap<String, String>();
        JSONObject o = this.getDataRecord().optJSONObject("aux");
        if (o != null) {
            for (Object key : o.keySet()) {
                Object val = o.get(key.toString());
                if (val == null) continue;
                result.put(key.toString(), val.toString());
            }
        }
        return result;
    }

    protected abstract JSONObject getDataRecord();

    protected abstract void store() throws IamSvcException;
}

