/*
 * Decompiled with CFR 0.152.
 */
package io.continual.util.console;

import io.continual.util.console.CmdLinePrefs;
import io.continual.util.console.ConsoleProgram;
import io.continual.util.data.TypeConvertor;
import java.util.HashMap;
import java.util.TreeSet;

public class CmdLineParser {
    private final HashMap<Character, String> fSingleToWord = new HashMap();
    private final TreeSet<String> fWordsNeedingValues = new TreeSet();
    private final HashMap<String, Option> fOptions = new HashMap();
    private int fMinFiles = 0;
    private int fMaxFiles = Integer.MAX_VALUE;

    public CmdLineParser registerOnOffOption(String word, Character singleChar, boolean defValue) {
        if (word == null) {
            throw new IllegalArgumentException("An option 'word' is required.");
        }
        if (singleChar != null) {
            this.fSingleToWord.put(singleChar, word);
        }
        this.fOptions.put(word, new OnOff(defValue));
        return this;
    }

    public CmdLineParser registerOptionWithValue(String word) {
        return this.registerOptionWithValue(word, null, null, null);
    }

    public CmdLineParser registerOptionWithValue(String word, String singleChar) {
        return this.registerOptionWithValue(word, singleChar, null, null);
    }

    public CmdLineParser registerOptionWithValue(String word, String singleChar, String defValue, String[] allowed) {
        if (word == null) {
            throw new IllegalArgumentException("An option 'word' is required.");
        }
        if (singleChar != null) {
            if (singleChar.length() > 1) {
                throw new IllegalArgumentException(singleChar + " is not a single character.");
            }
            this.fSingleToWord.put(Character.valueOf(singleChar.charAt(0)), word);
        }
        this.fWordsNeedingValues.add(word);
        this.fOptions.put(word, new Setting(word, defValue, allowed));
        return this;
    }

    public CmdLineParser requireNoFileArguments() {
        return this.requireFileArguments(0, 0);
    }

    public CmdLineParser requireOneFileArgument() {
        return this.requireFileArguments(1, 1);
    }

    public CmdLineParser requireMinFileArguments(int min) {
        return this.requireFileArguments(min, Integer.MAX_VALUE);
    }

    public CmdLineParser requireFileArguments(int exactly) {
        return this.requireFileArguments(exactly, exactly);
    }

    public CmdLineParser requireFileArguments(int min, int max) {
        this.fMinFiles = min;
        this.fMaxFiles = max;
        return this;
    }

    public boolean hasArg(String optionWord) {
        return this.fOptions.get(optionWord) != null;
    }

    public boolean isSet(String optionWord) {
        Option o = this.fOptions.get(optionWord);
        return o != null ? TypeConvertor.convertToBoolean(o.getDefault()) : false;
    }

    public String getArgFor(String optionWord) {
        Option o = this.fOptions.get(optionWord);
        return o != null ? o.getDefault() : "";
    }

    public CmdLinePrefs processArgs(String[] args) throws ConsoleProgram.UsageException {
        int i;
        CmdLinePrefs prefs = new CmdLinePrefs(this);
        boolean seenDashDash = false;
        for (i = 0; i < args.length && !seenDashDash; ++i) {
            String item = args[i];
            if (item.equals("--")) {
                seenDashDash = true;
                continue;
            }
            if (item.startsWith("--")) {
                String word = item.substring(2);
                if (this.reqsValue(word)) {
                    if (i + 1 == args.length) {
                        throw new ConsoleProgram.UsageException("Option " + item + " requires an argument.");
                    }
                    this.handleOption(prefs, word, args[i + 1]);
                    ++i;
                    continue;
                }
                this.handleOption(prefs, word);
                continue;
            }
            if (item.startsWith("-")) {
                int len = item.length();
                if (len == 1) {
                    throw new ConsoleProgram.UsageException("Can't process '-' alone.");
                }
                if (item.length() == 2) {
                    char c = item.charAt(1);
                    String word = this.fSingleToWord.get(Character.valueOf(c));
                    if (word == null) {
                        throw new ConsoleProgram.UsageException("Option '" + c + "' is invalid.");
                    }
                    if (this.reqsValue(word)) {
                        if (i == args.length) {
                            throw new ConsoleProgram.UsageException("Option " + item + " requires an argument.");
                        }
                        this.handleOption(prefs, word, args[i + 1]);
                        ++i;
                        continue;
                    }
                    this.handleOption(prefs, word);
                    continue;
                }
                for (char c : item.substring(1).toCharArray()) {
                    String optWord = this.fSingleToWord.get(Character.valueOf(c));
                    if (optWord == null) {
                        throw new ConsoleProgram.UsageException("Option '" + c + "' is invalid.");
                    }
                    this.handleOption(prefs, optWord);
                }
                continue;
            }
            seenDashDash = true;
            break;
        }
        int leftoverCount = 0;
        while (i < args.length) {
            prefs.addLeftover(args[i]);
            ++i;
            ++leftoverCount;
        }
        if (leftoverCount < this.fMinFiles || leftoverCount > this.fMaxFiles) {
            throw new ConsoleProgram.UsageException(this.getErrorMsgForWrongCount(leftoverCount));
        }
        return prefs;
    }

    private static String plural(String word, int count) {
        return count == 1 ? word : word + "s";
    }

    private String getErrorMsgForWrongCount(int count) {
        if (this.fMinFiles == this.fMaxFiles) {
            if (this.fMinFiles == 0) {
                return "You may not provide any arguments.";
            }
            return "You must provide " + this.fMinFiles + " " + CmdLineParser.plural("argument", this.fMinFiles) + ".";
        }
        String minPart = this.fMinFiles <= 0 ? null : "at least " + this.fMinFiles + " " + CmdLineParser.plural("argument", this.fMinFiles);
        String maxPart = this.fMaxFiles == Integer.MAX_VALUE ? null : "at most " + this.fMaxFiles + " " + CmdLineParser.plural("argument", this.fMaxFiles);
        return "You must provide " + (minPart != null ? minPart : "") + (minPart != null && maxPart != null ? " and " : "") + (maxPart != null ? maxPart : "") + ".";
    }

    private boolean reqsValue(String optWord) {
        return this.fWordsNeedingValues.contains(optWord);
    }

    private void handleOption(CmdLinePrefs prefs, String optWord) throws ConsoleProgram.UsageException {
        this.handleOption(prefs, optWord, Boolean.TRUE.toString());
    }

    private void handleOption(CmdLinePrefs prefs, String optWord, String value) throws ConsoleProgram.UsageException {
        Option o = this.fOptions.get(optWord);
        if (o == null) {
            throw new ConsoleProgram.UsageException("Unrecognized option \"" + optWord + "\"");
        }
        String valToUse = o.checkValue(value);
        prefs.set(optWord, valToUse);
    }

    private class Setting
    implements Option {
        private final String fSetting;
        private String fValue;
        private String[] fAllowed;

        public Setting(String name, String defVal, String[] allowed) {
            this.fSetting = name;
            this.fValue = defVal;
            this.fAllowed = allowed;
        }

        @Override
        public String checkValue(String val) throws ConsoleProgram.UsageException {
            boolean canSet = true;
            if (this.fAllowed != null) {
                canSet = false;
                for (String a : this.fAllowed) {
                    if (!a.equals(val)) continue;
                    canSet = true;
                    break;
                }
                if (!canSet) {
                    throw new ConsoleProgram.UsageException("Value " + val + " is not allowed for setting " + this.fSetting);
                }
            }
            return val;
        }

        @Override
        public String getDefault() {
            return this.fValue;
        }
    }

    private class OnOff
    implements Option {
        private final boolean fValue;

        public OnOff(boolean defVal) {
            this.fValue = defVal;
        }

        @Override
        public String checkValue(String val) {
            return "" + TypeConvertor.convertToBooleanBroad(val);
        }

        @Override
        public String getDefault() {
            return Boolean.toString(this.fValue);
        }
    }

    private static interface Option {
        public String checkValue(String var1) throws ConsoleProgram.UsageException;

        public String getDefault();
    }
}

