/*
 * Decompiled with CFR 0.152.
 */
package io.continual.util.data.csv;

import io.continual.util.data.csv.CsvEncoder;
import java.util.Date;

public class CsvLineBuilder {
    private final StringBuilder fBuilder = new StringBuilder();
    private final char fQuoteChar;
    private final char fSepChar;
    private final boolean fForceQuotes;
    private boolean fDoneOne = false;

    public CsvLineBuilder() {
        this('\"', ',', true);
    }

    public CsvLineBuilder(char quoteChar, char sepChar, boolean forceQuotes) {
        this.fQuoteChar = quoteChar;
        this.fSepChar = sepChar;
        this.fForceQuotes = forceQuotes;
    }

    public String toString() {
        return this.fBuilder.toString();
    }

    public CsvLineBuilder appendEmpty() {
        return this.appendLiteral("");
    }

    public CsvLineBuilder append(String value) {
        return this.appendLiteral(CsvEncoder.encodeForCsv(value, this.fQuoteChar, this.fSepChar, this.fForceQuotes));
    }

    public CsvLineBuilder append(long value) {
        return this.appendLiteral(Long.toString(value));
    }

    public CsvLineBuilder append(boolean value) {
        return this.appendLiteral(Boolean.toString(value));
    }

    public CsvLineBuilder append(double value) {
        return this.appendLiteral(Double.toString(value));
    }

    public CsvLineBuilder append(Date value) {
        return this.appendLiteral(CsvEncoder.encodeForCsv(value));
    }

    public CsvLineBuilder appendLiteral(String val) {
        if (this.fDoneOne) {
            this.fBuilder.append(',');
        }
        this.fBuilder.append(val);
        this.fDoneOne = true;
        return this;
    }
}

