/*
 * Decompiled with CFR 0.152.
 */
package io.continual.util.legal;

import java.util.ArrayList;
import java.util.List;

public class CopyrightGenerator {
    private final ArrayList<HolderInfo> fHolders = new ArrayList();

    public static CopyrightGenerator getStandardNotice() {
        return new CopyrightGenerator();
    }

    public CopyrightGenerator addHolder(String holder2, int fromYear) {
        this.fHolders.add(new HolderInfo(holder2, fromYear));
        return this;
    }

    public List<String> getCopyrightNotices() {
        ArrayList<String> result = new ArrayList<String>();
        for (HolderInfo hi : this.fHolders) {
            result.add(CopyrightGenerator.getCopyrightNotice(hi.fHolder, hi.fFromYr));
        }
        result.add(CopyrightGenerator.getCopyrightNotice("Continual.io Corporation", 2004));
        return result;
    }

    public static String getCopyrightNotice() {
        return CopyrightGenerator.getCopyrightNotice("Continual.io Corporation", 2004);
    }

    public static String getCopyrightNotice(String holder2, int fromYear) {
        return CopyrightGenerator.getCopyrightNotice(holder2, fromYear, CopyrightGenerator.thisYear());
    }

    public static String getCopyrightNotice(String holder2, int fromYear, int toYear) {
        StringBuffer sb = new StringBuffer();
        sb.append("(c) ");
        sb.append(CopyrightGenerator.getYearRange(fromYear, toYear));
        sb.append(", ");
        sb.append(holder2);
        return sb.toString();
    }

    public static String getYearRange(int fromYear, int toYear) {
        StringBuffer sb = new StringBuffer();
        sb.append(fromYear);
        if (toYear > fromYear) {
            sb.append("-");
            sb.append("" + toYear);
        }
        return sb.toString();
    }

    private static int thisYear() {
        return 2022;
    }

    private class HolderInfo {
        public final String fHolder;
        public final int fFromYr;

        public HolderInfo(String holder2, int fromYr) {
            this.fHolder = holder2;
            this.fFromYr = fromYr;
        }
    }
}

