/*
 * Decompiled with CFR 0.152.
 */
package io.continual.services.model.api.endpoints;

import io.continual.builder.Builder;
import io.continual.http.service.framework.context.CHttpRequestContext;
import io.continual.iam.IamService;
import io.continual.iam.IamServiceManager;
import io.continual.iam.exceptions.IamSvcException;
import io.continual.iam.identity.Identity;
import io.continual.iam.identity.UserContext;
import io.continual.restHttp.ApiContextHelper;
import io.continual.restHttp.HttpServlet;
import io.continual.services.model.core.exceptions.ModelRequestException;
import io.continual.services.model.core.exceptions.ModelServiceException;
import io.continual.services.model.service.ModelService;
import io.continual.services.model.service.ModelSession;
import io.continual.util.naming.Path;
import java.io.IOException;
import org.json.JSONException;
import org.json.JSONObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ModelApiContextHelper
extends ApiContextHelper<Identity> {
    private ModelService fModelService;
    private static final Logger log = LoggerFactory.getLogger(ModelApiContextHelper.class);

    public ModelApiContextHelper(ModelService ms) {
        this.fModelService = ms;
    }

    public static Path fixupPath(String path) {
        String pathToUse = path;
        if (path != null && !path.startsWith("/")) {
            pathToUse = "/" + path;
        }
        return path == null ? null : Path.fromString((String)pathToUse);
    }

    public void handleModelRequest(final CHttpRequestContext context, String acctId, String path, ModelApiHandler handler) throws ModelRequestException {
        try {
            final HttpServlet servlet = (HttpServlet)context.getServlet();
            final IamServiceManager as = ModelApiContextHelper.getAccountsSvc((CHttpRequestContext)context);
            ModelApiContextHelper.setupCorsHeaders((CHttpRequestContext)context);
            final UserContext userContext = ModelApiContextHelper.getUser((IamServiceManager)as, (CHttpRequestContext)context);
            if (userContext == null) {
                ModelApiContextHelper.sendNotAuth((CHttpRequestContext)context);
                return;
            }
            final Path actualPath = ModelApiContextHelper.fixupPath(path);
            ModelApiContext mac = new ModelApiContext(){

                @Override
                public CHttpRequestContext getHttpContext() {
                    return context;
                }

                @Override
                public HttpServlet getHttpServlet() {
                    return servlet;
                }

                @Override
                public UserContext<?> getUserContext() {
                    return userContext;
                }

                @Override
                public IamService<?, ?> getAccountService() {
                    return as;
                }

                @Override
                public ModelService getModelService() {
                    return ModelApiContextHelper.this.fModelService;
                }

                @Override
                public ModelSession getModelSession() throws IamSvcException, Builder.BuildFailure {
                    return this.getModelService().sessionBuilder().forUser(userContext.getUser()).build();
                }

                @Override
                public Path getRequestedPath() {
                    return actualPath;
                }

                @Override
                public void respondWithStatus(int statusCode, JSONObject data) throws IOException {
                    context.response().setStatus(statusCode).getStreamForTextResponse("application/json").println(data);
                }
            };
            handler.handle(mac);
        }
        catch (ModelRequestException e) {
            log.warn(e.getMessage());
            ModelApiContextHelper.sendJson((CHttpRequestContext)context, (int)400, (JSONObject)new JSONObject().put("status", 400).put("message", (Object)("There was a problem handling your request. " + e.getMessage())));
        }
        catch (ModelServiceException e) {
            log.warn(e.getMessage());
            ModelApiContextHelper.sendJson((CHttpRequestContext)context, (int)503, (JSONObject)new JSONObject().put("status", 503).put("message", (Object)"There was a problem handling your request."));
        }
        catch (Builder.BuildFailure e) {
            log.warn(e.getMessage());
            ModelApiContextHelper.sendJson((CHttpRequestContext)context, (int)503, (JSONObject)new JSONObject().put("status", 503).put("message", (Object)"There was a problem handling your request."));
        }
        catch (IamSvcException e) {
            log.warn(e.getMessage());
            ModelApiContextHelper.sendJson((CHttpRequestContext)context, (int)503, (JSONObject)new JSONObject().put("status", 503).put("message", (Object)"There was a problem handling your request."));
        }
        catch (IOException e) {
            log.warn(e.getMessage());
            context.response().sendError(500, "I/O problem writing the response, but... you got it???");
        }
        catch (JSONException e) {
            log.warn(e.getMessage());
            context.response().sendError(500, "There was a problem handling your API request.");
        }
    }

    public static interface ModelApiHandler {
        public void handle(ModelApiContext var1) throws IOException, JSONException, ModelRequestException, ModelServiceException, IamSvcException, Builder.BuildFailure;
    }

    public static interface ModelApiContext {
        public CHttpRequestContext getHttpContext();

        public HttpServlet getHttpServlet();

        public UserContext<?> getUserContext();

        public IamService<?, ?> getAccountService();

        public ModelService getModelService();

        public ModelSession getModelSession() throws IamSvcException, Builder.BuildFailure;

        public Path getRequestedPath();

        default public void respondOk(JSONObject data) throws IOException {
            this.respondWithStatus(200, data);
        }

        public void respondWithStatus(int var1, JSONObject var2) throws IOException;
    }
}

