/*
 * Decompiled with CFR 0.152.
 */
package io.continual.services.model.service.impl;

import io.continual.builder.Builder;
import io.continual.iam.exceptions.IamSvcException;
import io.continual.iam.identity.Identity;
import io.continual.iam.impl.common.CommonJsonIdentity;
import io.continual.services.ServiceContainer;
import io.continual.services.SimpleService;
import io.continual.services.model.core.Model;
import io.continual.services.model.core.ModelNotificationService;
import io.continual.services.model.core.ModelObject;
import io.continual.services.model.core.ModelRequestContext;
import io.continual.services.model.core.ModelSchemaRegistry;
import io.continual.services.model.core.exceptions.ModelRequestException;
import io.continual.services.model.core.exceptions.ModelServiceException;
import io.continual.services.model.impl.common.BuiltinSchemaReg;
import io.continual.services.model.impl.delegator.DelegatingModel;
import io.continual.services.model.impl.delegator.ModelMount;
import io.continual.services.model.service.ModelService;
import io.continual.services.model.service.ModelSession;
import io.continual.services.model.service.ModelSessionBuilder;
import io.continual.services.model.service.impl.NoopNotifier;
import io.continual.services.model.service.impl.StdMountTableEntry;
import io.continual.util.collections.LruCache;
import io.continual.util.data.json.JsonUtil;
import io.continual.util.data.json.JsonVisitor;
import io.continual.util.naming.Name;
import io.continual.util.naming.Path;
import java.util.LinkedList;
import java.util.Map;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class StdModelService
extends SimpleService
implements ModelService {
    private final Model fSettingsModel;
    private final LinkedList<JSONObject> fGlobalMounts;
    private final BuiltinSchemaReg fGlobalSchemas;
    private final ModelNotificationService fNotifications;
    private final LruCache<String, StdModelSession> fSessions;

    public StdModelService(ServiceContainer sc, JSONObject config) throws Builder.BuildFailure {
        this.fSettingsModel = (Model)sc.get(config.optString("settings", "settingsModel"), Model.class);
        if (this.fSettingsModel == null) {
            throw new Builder.BuildFailure("A settings model is required. Set to 'settings' the object name, or define a 'settingsModel' instance.");
        }
        try {
            ModelRequestContext mrc = this.fSettingsModel.getRequestContextBuilder().build();
            ModelObject globalMounts = this.fSettingsModel.load(mrc, Path.fromString((String)"/globalMounts"));
            this.fGlobalMounts = new LinkedList();
            JsonVisitor.forEachElement((JSONArray)globalMounts.getData().optJSONArray("globalMounts"), (JsonVisitor.ArrayVisitor)new JsonVisitor.ArrayVisitor<JSONObject, Builder.BuildFailure>(){

                public boolean visit(JSONObject globalMount) throws JSONException, Builder.BuildFailure {
                    StdModelService.this.fGlobalMounts.add(globalMount);
                    return true;
                }
            });
            this.fGlobalSchemas = new BuiltinSchemaReg(1024L);
            NoopNotifier notifier = new NoopNotifier();
            String notifierName = config.optString("notifier", null);
            if (notifierName != null) {
                notifier = (ModelNotificationService)sc.get(notifierName, ModelNotificationService.class);
            }
            this.fNotifications = notifier;
            if (this.fNotifications == null) {
                throw new Builder.BuildFailure("No notification service connected.");
            }
        }
        catch (ModelRequestException | ModelServiceException x) {
            throw new Builder.BuildFailure(x);
        }
        this.fSessions = new LruCache(config.optLong("sessionCacheSize", 1024L));
    }

    @Override
    public StdModelSessionBuilder sessionBuilder() {
        return new StdModelSessionBuilder();
    }

    private class StdModelSession
    implements ModelSession {
        private final DelegatingModel fModel;

        public StdModelSession(StdModelSessionBuilder builder) throws IamSvcException, Builder.BuildFailure {
            this.fModel = new DelegatingModel(builder.fUser.getId(), "{top}");
            final JSONObject userSettings = JsonVisitor.mapOfStringsToObject((Map)builder.fUser.getAllUserData()).put("userId", (Object)builder.fUser.getId());
            ModelRequestContext mrc = StdModelService.this.fSettingsModel.getRequestContextBuilder().forUser((Identity)new CommonJsonIdentity("system", new JSONObject(), null)).build();
            Path userSettingsPath = Path.getRootPath().makeChildItem(Name.fromString((String)"userSettings")).makeChildItem(Name.fromString((String)builder.fUser.getId()));
            try {
                if (!StdModelService.this.fSettingsModel.exists(mrc, userSettingsPath)) {
                    StdModelService.this.fSettingsModel.store(mrc, userSettingsPath, new JSONObject());
                }
                ModelObject userSettingsObject = StdModelService.this.fSettingsModel.load(mrc, userSettingsPath);
                JsonVisitor.forEachElement((JSONArray)userSettingsObject.getData().optJSONArray("models"), (JsonVisitor.ArrayVisitor)new JsonVisitor.ArrayVisitor<JSONObject, Builder.BuildFailure>(){

                    public boolean visit(JSONObject model) throws JSONException, Builder.BuildFailure {
                        StdModelSession.this.fModel.mount((ModelMount)StdModelSession.this.mountFromJson(model, userSettings));
                        return true;
                    }
                });
            }
            catch (ModelRequestException | ModelServiceException x) {
                throw new Builder.BuildFailure(x);
            }
            for (JSONObject globalMountConfig : StdModelService.this.fGlobalMounts) {
                this.fModel.mount((ModelMount)this.mountFromJson(globalMountConfig, userSettings));
            }
        }

        private StdMountTableEntry mountFromJson(JSONObject mountConfig, JSONObject userSettings) throws Builder.BuildFailure {
            JSONObject userConfig = JsonUtil.clone((JSONObject)mountConfig.getJSONObject("model")).put("UserData", (Object)userSettings);
            Model m = (Model)Builder.withBaseClass(Model.class).withClassNameInData().usingData(userConfig).providingContext((Object)new ServiceContainer()).build();
            return new StdMountTableEntry(Path.fromString((String)mountConfig.getString("path")), m);
        }

        @Override
        public Model getModel() {
            return this.fModel;
        }

        @Override
        public ModelSchemaRegistry getSchemaRegistry() {
            return StdModelService.this.fGlobalSchemas;
        }

        @Override
        public ModelNotificationService getNotificationSvc() {
            return StdModelService.this.fNotifications;
        }
    }

    private class StdModelSessionBuilder
    implements ModelSessionBuilder {
        private Identity fUser;

        private StdModelSessionBuilder() {
        }

        @Override
        public ModelSessionBuilder forUser(Identity user) {
            this.fUser = user;
            return this;
        }

        @Override
        public ModelSession build() throws IamSvcException, Builder.BuildFailure {
            if (this.fUser == null) {
                throw new NullPointerException("user may not be null");
            }
            StdModelSession result = (StdModelSession)StdModelService.this.fSessions.get((Object)this.fUser.getId());
            if (result == null) {
                result = new StdModelSession(this);
                StdModelService.this.fSessions.put((Object)this.fUser.getId(), (Object)result);
            }
            return result;
        }
    }
}

