/*
 * Decompiled with CFR 0.152.
 */
package io.continual.iam.identity;

import io.continual.iam.exceptions.IamBadRequestException;
import io.continual.iam.exceptions.IamIdentityDoesNotExist;
import io.continual.iam.exceptions.IamIdentityExists;
import io.continual.iam.exceptions.IamSvcException;
import io.continual.iam.identity.ApiKey;
import io.continual.iam.identity.Identity;
import io.continual.iam.identity.IdentityDb;
import io.continual.iam.identity.JwtValidator;
import java.util.Collection;
import java.util.List;
import java.util.Map;

public interface IdentityManager<I extends Identity>
extends IdentityDb<I> {
    public boolean userExists(String var1) throws IamSvcException;

    public boolean userOrAliasExists(String var1) throws IamSvcException;

    public I loadUser(String var1) throws IamSvcException;

    public I loadUserOrAlias(String var1) throws IamSvcException;

    public List<String> findUsers(String var1) throws IamSvcException;

    public I createUser(String var1) throws IamIdentityExists, IamSvcException;

    public I createAnonymousUser() throws IamSvcException;

    public void deleteUser(String var1) throws IamSvcException;

    public void addAlias(String var1, String var2) throws IamSvcException, IamBadRequestException;

    public void removeAlias(String var1) throws IamBadRequestException, IamSvcException;

    public Collection<String> getAliasesFor(String var1) throws IamSvcException, IamIdentityDoesNotExist;

    public boolean completePasswordReset(String var1, String var2) throws IamSvcException;

    public ApiKey loadApiKeyRecord(String var1) throws IamSvcException;

    public void restoreApiKey(ApiKey var1) throws IamIdentityDoesNotExist, IamBadRequestException, IamSvcException;

    public void addJwtValidator(JwtValidator var1);

    public Collection<String> getAllUsers() throws IamSvcException;

    public Map<String, I> loadAllUsers() throws IamSvcException;
}

