/*
 * Decompiled with CFR 0.152.
 */
package io.continual.shaded.com.rabbitmq.tools.jsonrpc;

import io.continual.shaded.com.rabbitmq.tools.json.JSONUtil;
import io.continual.shaded.com.rabbitmq.tools.jsonrpc.ParameterDescription;
import java.lang.reflect.Method;
import java.util.List;
import java.util.Map;

public class ProcedureDescription {
    public String name;
    public String summary;
    public String help;
    public boolean idempotent;
    private ParameterDescription[] params;
    private String returnType;
    private String javaReturnType;
    private Class<?> _javaReturnTypeAsClass;
    private Method method;

    public ProcedureDescription(Map<String, Object> pm) {
        JSONUtil.tryFill(this, pm);
        List p = (List)pm.get("params");
        this.params = new ParameterDescription[p.size()];
        int count = 0;
        for (Map param_map : p) {
            ParameterDescription param = new ParameterDescription(param_map);
            this.params[count++] = param;
        }
    }

    public ProcedureDescription(Method m) {
        this.method = m;
        this.name = m.getName();
        this.summary = "";
        this.help = "";
        this.idempotent = false;
        Class<?>[] parameterTypes = m.getParameterTypes();
        this.params = new ParameterDescription[parameterTypes.length];
        for (int i = 0; i < parameterTypes.length; ++i) {
            this.params[i] = new ParameterDescription(i, parameterTypes[i]);
        }
        this.returnType = ParameterDescription.lookup(m.getReturnType());
        this.javaReturnType = m.getReturnType().getName();
    }

    public ProcedureDescription() {
    }

    public String getReturn() {
        return this.returnType;
    }

    public void setReturn(String value) {
        this.returnType = value;
    }

    public Method internal_getMethod() {
        return this.method;
    }

    public String getJavaReturnType() {
        return this.javaReturnType;
    }

    public void setJavaReturnType(String javaReturnType) {
        this.javaReturnType = javaReturnType;
        this._javaReturnTypeAsClass = this.computeReturnTypeAsJavaClass();
    }

    public Class<?> getReturnType() {
        return this._javaReturnTypeAsClass;
    }

    private Class<?> computeReturnTypeAsJavaClass() {
        try {
            if ("int".equals(this.javaReturnType)) {
                return Integer.TYPE;
            }
            if ("double".equals(this.javaReturnType)) {
                return Double.TYPE;
            }
            if ("long".equals(this.javaReturnType)) {
                return Long.TYPE;
            }
            if ("boolean".equals(this.javaReturnType)) {
                return Boolean.TYPE;
            }
            if ("char".equals(this.javaReturnType)) {
                return Character.TYPE;
            }
            if ("byte".equals(this.javaReturnType)) {
                return Byte.TYPE;
            }
            if ("short".equals(this.javaReturnType)) {
                return Short.TYPE;
            }
            if ("float".equals(this.javaReturnType)) {
                return Float.TYPE;
            }
            if ("void".equals(this.javaReturnType)) {
                return Void.TYPE;
            }
            return Class.forName(this.javaReturnType);
        }
        catch (ClassNotFoundException e) {
            throw new IllegalStateException("Unable to load class: " + this.javaReturnType, e);
        }
    }

    public ParameterDescription[] internal_getParams() {
        return this.params;
    }

    public int arity() {
        return this.params == null ? 0 : this.params.length;
    }

    public ParameterDescription[] getParams() {
        return this.params;
    }
}

