/*
 * Decompiled with CFR 0.152.
 */
package io.continual.http.util;

import io.continual.http.service.framework.context.CHttpRequest;
import io.continual.http.service.framework.context.CHttpRequestContext;
import io.continual.util.time.Clock;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.util.LinkedList;
import java.util.List;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;
import org.json.JSONTokener;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JsonBodyReader {
    public static long kDefaultTimeoutMs = 10000L;
    public static long kMaxBytes = 0x2000000L;
    private static final Charset utf8 = Charset.forName("UTF-8");
    private static final Logger log = LoggerFactory.getLogger(JsonBodyReader.class);

    public static List<JSONObject> readBodyForObjects(CHttpRequestContext context) throws IOException, JSONException {
        return JsonBodyReader.readBodyForObjects(context, null);
    }

    public static List<JSONObject> readBodyForObjects(CHttpRequestContext context, String path) throws JSONException {
        try {
            byte[] bytes = JsonBodyReader.readBytes(context.request(), kDefaultTimeoutMs);
            return JsonBodyReader.readBodyForObjects(bytes, path);
        }
        catch (IOException e) {
            return new LinkedList<JSONObject>();
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static List<JSONObject> readBodyForObjects(byte[] bytes, String path) throws IOException, JSONException {
        String jsonStream;
        boolean isSingleObject;
        LinkedList<JSONObject> result = new LinkedList<JSONObject>();
        ByteArrayInputStream s = new ByteArrayInputStream(bytes);
        JSONTokener t = new JSONTokener((InputStream)s);
        char c = t.next();
        while (Character.isWhitespace(c)) {
            c = t.next();
        }
        switch (c) {
            case '{': {
                isSingleObject = true;
                break;
            }
            case '[': {
                isSingleObject = false;
                break;
            }
            default: {
                throw new JSONException("Expected an object or an array of objects.");
            }
        }
        s.close();
        if (isSingleObject) {
            jsonStream = new String(bytes, utf8);
            JSONObject o = new JSONObject(jsonStream);
            if (path != null) {
                Object oo = o.opt(path);
                if (oo instanceof JSONObject) {
                    result.add((JSONObject)oo);
                    return result;
                } else {
                    if (!(oo instanceof JSONArray)) throw new JSONException("Couldn't read object at path [" + path + "].");
                    result.addAll(JsonBodyReader.readArrayForObjects((JSONArray)oo));
                }
                return result;
            } else {
                result.add(o);
            }
            return result;
        } else {
            jsonStream = new String(bytes);
            JSONArray a = new JSONArray(jsonStream);
            result.addAll(JsonBodyReader.readArrayForObjects(a));
        }
        return result;
    }

    public static JSONObject readBody(CHttpRequestContext context) throws IOException, JSONException {
        return JsonBodyReader.readBody(context, kDefaultTimeoutMs);
    }

    public static JSONObject readBody(CHttpRequestContext context, long timeoutMs) throws IOException, JSONException {
        return JsonBodyReader.readBody(context.request(), timeoutMs);
    }

    public static JSONObject readBody(CHttpRequest req) throws IOException, JSONException {
        return JsonBodyReader.readBody(req, kDefaultTimeoutMs);
    }

    public static JSONObject readBody(CHttpRequest req, long timeoutMs) throws IOException, JSONException {
        byte[] bytes = JsonBodyReader.readBytes(req, timeoutMs);
        String jsonStream = new String(bytes);
        return new JSONObject(jsonStream);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static byte[] readBytes(CHttpRequest req, long timeoutMs) throws IOException {
        int clen = req.getContentLength();
        log.trace("Incoming content-length is " + clen);
        if (clen == -1) {
            throw new IOException("The content length header must be provided.");
        }
        if ((long)clen > kMaxBytes) {
            throw new IOException("Input too large.");
        }
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        InputStream is = req.getBodyStream();
        if (is == null) {
            throw new IOException("No input stream on request.");
        }
        long totalBytesRead = 0L;
        try {
            int len;
            byte[] b = new byte[4096];
            long lastReadMs = Clock.now();
            boolean complete = false;
            do {
                if ((len = is.read(b)) > 0) {
                    lastReadMs = Clock.now();
                    if ((totalBytesRead += (long)len) > kMaxBytes) {
                        throw new IOException("Input too large.");
                    }
                    baos.write(b, 0, len);
                    complete = totalBytesRead >= (long)clen;
                    continue;
                }
                if (len != 0 || lastReadMs + timeoutMs >= Clock.now()) continue;
                log.info("Read timed out. Total " + totalBytesRead + " bytes, content-length was " + clen);
                throw new IOException("Timed out waiting for input.");
            } while (len != -1 && !complete);
        }
        finally {
            is.close();
        }
        if (totalBytesRead < (long)clen) {
            throw new IOException("Expected " + clen + " bytes, received " + totalBytesRead);
        }
        byte[] bytes = new byte[clen];
        System.arraycopy(baos.toByteArray(), 0, bytes, 0, clen);
        return bytes;
    }

    private static List<JSONObject> readArrayForObjects(JSONArray a) throws JSONException {
        LinkedList<JSONObject> result = new LinkedList<JSONObject>();
        int len = a.length();
        for (int i = 0; i < len; ++i) {
            Object o = a.get(i);
            if (!(o instanceof JSONObject)) {
                throw new JSONException("Expected an object or an array of objects.");
            }
            result.add((JSONObject)o);
        }
        return result;
    }
}

