/*
 * Decompiled with CFR 0.152.
 */
package io.continual.util.data.exprEval;

import io.continual.util.data.TypeConvertor;
import io.continual.util.data.exprEval.ExprDataSource;
import io.continual.util.data.json.JsonVisitor;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class ExpressionEvaluator {
    private final ExprDataSource[] fSources;

    public ExpressionEvaluator(ExprDataSource ... srcs) {
        this.fSources = srcs;
    }

    public Object evaluateSymbol(String expr) {
        return ExpressionEvaluator.evaluateSymbol(expr, this.fSources);
    }

    public String evaluateText(String expr) {
        return ExpressionEvaluator.evaluateText(expr, this.fSources);
    }

    public int evaluateTextToInt(Object value, int defaultValue) {
        return ExpressionEvaluator.evaluateTextToInt(value, defaultValue, this.fSources);
    }

    public long evaluateTextToLong(Object value, long defaultValue) {
        return ExpressionEvaluator.evaluateTextToLong(value, defaultValue, this.fSources);
    }

    public boolean evaluateTextToBoolean(Object value, boolean defaultValue) {
        return ExpressionEvaluator.evaluateTextToBoolean(value, defaultValue, this.fSources);
    }

    public JSONObject evaluateJsonObject(JSONObject value) {
        return ExpressionEvaluator.evaluateJsonObject(value, this.fSources);
    }

    public JSONArray evaluateJsonArray(JSONArray value) {
        return ExpressionEvaluator.evaluateJsonArray(value, this.fSources);
    }

    public static Object evaluateSymbol(String symbol, ExprDataSource ... srcs) {
        for (ExprDataSource src : srcs) {
            Object result = src.eval(symbol);
            if (result == null) continue;
            return result;
        }
        return null;
    }

    public static String evaluateText(String sourceString, ExprDataSource ... srcs) {
        if (sourceString == null) {
            return null;
        }
        StringBuffer sb = new StringBuffer();
        do {
            Object symval;
            int open;
            if ((open = sourceString.indexOf("${")) < 0) {
                sb.append(sourceString);
                sourceString = "";
                continue;
            }
            int closer = sourceString.indexOf(125);
            if (closer < 0) {
                sb.append(sourceString);
                sourceString = "";
                continue;
            }
            sb.append(sourceString.substring(0, open));
            String key = sourceString.substring(open + 2, closer).trim();
            String defval = null;
            int vertBar = key.indexOf(124);
            if (vertBar > -1) {
                defval = key.substring(vertBar + 1).trim();
                key = key.substring(0, vertBar).trim();
            }
            ExprDataSource[] allSrcs = srcs;
            if (defval != null) {
                final String finalDefVal = defval;
                allSrcs = new ExprDataSource[srcs.length + 1];
                System.arraycopy(srcs, 0, allSrcs, 0, srcs.length);
                allSrcs[srcs.length] = new ExprDataSource(){

                    @Override
                    public Object eval(String label) {
                        return finalDefVal;
                    }
                };
            }
            sb.append((symval = ExpressionEvaluator.evaluateSymbol(key, allSrcs)) == null ? "" : symval.toString());
            sourceString = sourceString.substring(closer + 1);
        } while (sourceString.length() > 0);
        return sb.toString();
    }

    public static JSONObject evaluateJsonObject(JSONObject data2, final ExprDataSource ... srcs) {
        if (data2 == null) {
            return null;
        }
        final JSONObject result = new JSONObject();
        JsonVisitor.forEachElement(data2, new JsonVisitor.ObjectVisitor<Object, JSONException>(){

            @Override
            public boolean visit(String key, Object val) throws JSONException {
                if (val instanceof String) {
                    result.put(key, (Object)ExpressionEvaluator.evaluateText((String)val, srcs));
                } else if (val instanceof JSONObject) {
                    result.put(key, (Object)ExpressionEvaluator.evaluateJsonObject((JSONObject)val, srcs));
                } else if (val instanceof JSONArray) {
                    result.put(key, (Object)ExpressionEvaluator.evaluateJsonArray((JSONArray)val, srcs));
                } else {
                    result.put(key, val);
                }
                return true;
            }
        });
        return result;
    }

    public static JSONArray evaluateJsonArray(JSONArray data2, final ExprDataSource ... srcs) {
        if (data2 == null) {
            return null;
        }
        final JSONArray result = new JSONArray();
        JsonVisitor.forEachElement(data2, new JsonVisitor.ArrayVisitor<Object, JSONException>(){

            @Override
            public boolean visit(Object val) throws JSONException {
                if (val instanceof String) {
                    result.put((Object)ExpressionEvaluator.evaluateText((String)val, srcs));
                } else if (val instanceof JSONObject) {
                    result.put((Object)ExpressionEvaluator.evaluateJsonObject((JSONObject)val, srcs));
                } else if (val instanceof JSONArray) {
                    result.put((Object)ExpressionEvaluator.evaluateJsonArray((JSONArray)val, srcs));
                } else {
                    result.put(val);
                }
                return true;
            }
        });
        return result;
    }

    public static int evaluateTextToInt(Object value, int defaultValue, ExprDataSource ... srcs) {
        if (value == null) {
            return defaultValue;
        }
        if (value instanceof Integer) {
            return (Integer)value;
        }
        String evalVal = ExpressionEvaluator.evaluateText(value.toString(), srcs);
        if (evalVal == null) {
            return defaultValue;
        }
        return TypeConvertor.convertToInt(evalVal.toString(), defaultValue);
    }

    public static long evaluateTextToLong(Object value, long defaultValue, ExprDataSource ... srcs) {
        if (value == null) {
            return defaultValue;
        }
        if (value instanceof Long) {
            return (Long)value;
        }
        if (value instanceof Integer) {
            return ((Integer)value).intValue();
        }
        String evalVal = ExpressionEvaluator.evaluateText(value.toString(), srcs);
        if (evalVal == null) {
            return defaultValue;
        }
        return TypeConvertor.convertToLong(evalVal.toString(), defaultValue);
    }

    public static boolean evaluateTextToBoolean(Object value, boolean defaultValue, ExprDataSource ... srcs) {
        if (value == null) {
            return defaultValue;
        }
        if (value instanceof Boolean) {
            return (Boolean)value;
        }
        String evalVal = ExpressionEvaluator.evaluateText(value.toString(), srcs);
        if (evalVal == null) {
            return defaultValue;
        }
        return TypeConvertor.convertToBooleanBroad(evalVal.toString());
    }
}

