/*
 * Decompiled with CFR 0.152.
 */
package io.continual.http.app.htmlForms.mime;

import io.continual.http.app.htmlForms.mime.CHttpMimePart;
import io.continual.http.app.htmlForms.mime.CHttpMimePartFactory;
import io.continual.util.collections.MultiMap;
import io.continual.util.data.HumanReadableHelper;
import io.continual.util.data.StringUtils;
import java.io.BufferedInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CHttpMimePartsReader {
    private final String fBoundaryLine;
    private final String fBoundaryEndMarker;
    private int fPartIndex;
    private boolean fInPartHeader;
    private MultiMap<String, String> fPartHeaders;
    private final CHttpMimePartFactory fPartFactory;
    private CHttpMimePart fCurrentPart;
    private final ArrayList<CHttpMimePart> fAllParts;
    private static final int kPartBytesBufferSize = 2048;
    private static final Logger log = LoggerFactory.getLogger(CHttpMimePartsReader.class);

    public CHttpMimePartsReader(String boundary, CHttpMimePartFactory mpf) {
        this.fBoundaryLine = "--" + boundary;
        this.fBoundaryEndMarker = this.fBoundaryLine + "--";
        this.fPartIndex = -1;
        this.fInPartHeader = false;
        this.fPartHeaders = null;
        this.fPartFactory = mpf;
        this.fCurrentPart = null;
        this.fAllParts = new ArrayList();
    }

    public void read(InputStream in) throws IOException {
        String line;
        BufferedInputStream bis = new BufferedInputStream(in);
        while ((line = CHttpMimePartsReader.readLine(bis)) != null) {
            if (line.equals(this.fBoundaryLine)) {
                this.onPartBoundary(++this.fPartIndex);
                this.fInPartHeader = true;
                this.fPartHeaders = new MultiMap();
                continue;
            }
            if (line.equals(this.fBoundaryEndMarker)) {
                this.onPartBoundary(++this.fPartIndex);
                this.onStreamEnd();
                break;
            }
            if (this.fPartIndex == -1) continue;
            if (this.fInPartHeader && line.length() == 0) {
                this.fInPartHeader = false;
                this.onPartHeaders(this.fPartHeaders);
                this.readPartBytes(bis);
                line = CHttpMimePartsReader.readLine(bis);
                if (line != null && line.length() <= 0) continue;
                log.warn("Unexpected state in MIME reader. After MIME part, found line [" + line + "].");
                continue;
            }
            if (this.fInPartHeader) {
                int colon = line.indexOf(58);
                if (colon == -1) continue;
                String key = line.substring(0, colon).trim().toLowerCase();
                String val = line.substring(colon + 1).trim();
                this.fPartHeaders.put((Object)key, (Object)val);
                continue;
            }
            log.warn("Unexpected state in MIME reader.");
        }
    }

    public List<CHttpMimePart> getParts() {
        return this.fAllParts;
    }

    public static MultiMap<String, String> parseContentDisposition(String cd) {
        MultiMap result = new MultiMap();
        String[] parts = cd.split(";");
        if (parts.length > 0) {
            result.put((Object)"disposition", (Object)parts[0]);
            for (int i = 1; i < parts.length; ++i) {
                int eq = parts[i].indexOf(61);
                if (eq > -1) {
                    String name = parts[i].substring(0, eq).trim();
                    String val = StringUtils.dequote((String)parts[i].substring(eq + 1).trim());
                    result.put((Object)name, (Object)val);
                    continue;
                }
                result.put((Object)parts[i], (Object)parts[i]);
            }
        }
        return result;
    }

    protected void onPartBoundary(int i) throws IOException {
        this.closeCurrentPart();
    }

    protected void onPartHeaders(MultiMap<String, String> headers) throws IOException {
        this.closeCurrentPart();
        this.fCurrentPart = this.fPartFactory.createPart(headers);
    }

    protected void onPartBytes(byte[] line, int offset, int length) throws IOException {
        if (this.fCurrentPart != null) {
            this.fCurrentPart.write(line, offset, length);
        }
    }

    protected void onStreamEnd() {
    }

    private void closeCurrentPart() throws IOException {
        if (this.fCurrentPart != null) {
            this.fCurrentPart.close();
            this.fAllParts.add(this.fCurrentPart);
            this.fCurrentPart = null;
        }
    }

    private static String readLine(BufferedInputStream bis) throws IOException {
        int b;
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        boolean eol = false;
        while (!eol && (b = bis.read()) != -1) {
            if (b == 13 || b == 10) {
                eol = true;
                bis.mark(1);
                if (b != 13 || (b = bis.read()) == 10) continue;
                bis.reset();
                continue;
            }
            baos.write(b);
        }
        String result = "";
        if (baos.size() > 0) {
            result = new String(baos.toByteArray());
        }
        return result;
    }

    private void readPartBytes(BufferedInputStream bis) throws IOException {
        byte[] buffer = new byte[2048];
        int readSoFar = 0;
        long readTotal = 0L;
        int boundaryTagLen = this.fBoundaryLine.length() + 2;
        byte[] boundaryLineBytes = ("\r\n" + this.fBoundaryLine).getBytes();
        while (true) {
            bis.mark(2);
            int b = bis.read();
            if (b == 13) {
                this.onPartBytes(buffer, 0, readSoFar);
                readSoFar = 0;
                bis.reset();
                bis.mark(boundaryTagLen);
                int read = bis.read(buffer, 0, boundaryTagLen);
                if (read == boundaryTagLen && CHttpMimePartsReader.startsWith(buffer, boundaryLineBytes)) {
                    bis.reset();
                    return;
                }
                bis.reset();
                buffer[readSoFar++] = (byte)(bis.read() & 0xFF);
                ++readTotal;
            } else {
                if (b == -1) {
                    throw new IOException("Stream ended without part boundary.");
                }
                buffer[readSoFar++] = (byte)(b & 0xFF);
                ++readTotal;
                if (readSoFar == 2048) {
                    this.onPartBytes(buffer, 0, readSoFar);
                    readSoFar = 0;
                }
            }
            if (readTotal % 0x100000L != 0L) continue;
            log.info(HumanReadableHelper.byteCountValue((long)readTotal) + " read");
        }
    }

    public static boolean startsWith(byte[] source, byte[] match) {
        return CHttpMimePartsReader.startsWith(source, 0, match);
    }

    public static boolean startsWith(byte[] source, int offset, byte[] match) {
        if (match.length > source.length - offset) {
            return false;
        }
        for (int i = 0; i < match.length; ++i) {
            if (source[offset + i] == match[i]) continue;
            return false;
        }
        return true;
    }
}

