/*
 * Decompiled with CFR 0.152.
 */
package io.continual.http.service.framework.routing.playish;

import io.continual.http.service.framework.context.CHttpRequestContext;
import io.continual.http.service.framework.routing.playish.CHttpPlayishRouteHandler;
import io.continual.http.service.framework.routing.playish.StaticDirHandler;
import io.continual.util.data.StreamTools;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URL;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StaticFileHandler
implements CHttpPlayishRouteHandler {
    public static final String kMaxAge = "chttp.staticFile.cache.maxAgeSeconds";
    private final String fFile;
    private final String fContentType;
    private static final Logger log = LoggerFactory.getLogger(StaticFileHandler.class);

    public StaticFileHandler(String routedPath, String staticFile) {
        String file = staticFile.endsWith("/") ? staticFile + routedPath : staticFile;
        this.fFile = file = file.replaceAll("//", "/");
        this.fContentType = StaticDirHandler.mapToContentType(this.fFile);
    }

    @Override
    public void handle(CHttpRequestContext context, List<String> args) throws IOException {
        int cacheMaxAge = context.systemSettings().getInt(kMaxAge, -1);
        if (cacheMaxAge > 0) {
            context.response().writeHeader("Cache-Control", "max-age=" + cacheMaxAge, true);
        }
        log.info("finding stream [" + this.fFile + "]");
        URL f = context.getServlet().findStream(this.fFile);
        if (f == null) {
            log.warn("404 [" + this.fFile + "] not found");
            context.response().sendError(404, this.fFile + " was not found on this server.");
        } else {
            StreamTools.copyStream((InputStream)f.openStream(), (OutputStream)context.response().getStreamForBinaryResponse(this.fContentType));
        }
    }

    @Override
    public boolean actionMatches(String fullPath) {
        return false;
    }
}

